/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterTransitGatewayMulticastGroupMembersResponse extends Ec2Response
        implements
        ToCopyableBuilder<RegisterTransitGatewayMulticastGroupMembersResponse.Builder, RegisterTransitGatewayMulticastGroupMembersResponse> {
    private static final SdkField<TransitGatewayMulticastRegisteredGroupMembers> REGISTERED_MULTICAST_GROUP_MEMBERS_FIELD = SdkField
            .<TransitGatewayMulticastRegisteredGroupMembers> builder(MarshallingType.SDK_POJO)
            .memberName("RegisteredMulticastGroupMembers")
            .getter(getter(RegisterTransitGatewayMulticastGroupMembersResponse::registeredMulticastGroupMembers))
            .setter(setter(Builder::registeredMulticastGroupMembers))
            .constructor(TransitGatewayMulticastRegisteredGroupMembers::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisteredMulticastGroupMembers")
                    .unmarshallLocationName("registeredMulticastGroupMembers").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(REGISTERED_MULTICAST_GROUP_MEMBERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TransitGatewayMulticastRegisteredGroupMembers registeredMulticastGroupMembers;

    private RegisterTransitGatewayMulticastGroupMembersResponse(BuilderImpl builder) {
        super(builder);
        this.registeredMulticastGroupMembers = builder.registeredMulticastGroupMembers;
    }

    /**
     * <p>
     * Information about the registered transit gateway multicast group members.
     * </p>
     * 
     * @return Information about the registered transit gateway multicast group members.
     */
    public final TransitGatewayMulticastRegisteredGroupMembers registeredMulticastGroupMembers() {
        return registeredMulticastGroupMembers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registeredMulticastGroupMembers());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTransitGatewayMulticastGroupMembersResponse)) {
            return false;
        }
        RegisterTransitGatewayMulticastGroupMembersResponse other = (RegisterTransitGatewayMulticastGroupMembersResponse) obj;
        return Objects.equals(registeredMulticastGroupMembers(), other.registeredMulticastGroupMembers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterTransitGatewayMulticastGroupMembersResponse")
                .add("RegisteredMulticastGroupMembers", registeredMulticastGroupMembers()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegisteredMulticastGroupMembers":
            return Optional.ofNullable(clazz.cast(registeredMulticastGroupMembers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RegisteredMulticastGroupMembers", REGISTERED_MULTICAST_GROUP_MEMBERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterTransitGatewayMulticastGroupMembersResponse, T> g) {
        return obj -> g.apply((RegisterTransitGatewayMulticastGroupMembersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, RegisterTransitGatewayMulticastGroupMembersResponse> {
        /**
         * <p>
         * Information about the registered transit gateway multicast group members.
         * </p>
         * 
         * @param registeredMulticastGroupMembers
         *        Information about the registered transit gateway multicast group members.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredMulticastGroupMembers(TransitGatewayMulticastRegisteredGroupMembers registeredMulticastGroupMembers);

        /**
         * <p>
         * Information about the registered transit gateway multicast group members.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TransitGatewayMulticastRegisteredGroupMembers.Builder} avoiding the need to create one manually via
         * {@link TransitGatewayMulticastRegisteredGroupMembers#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransitGatewayMulticastRegisteredGroupMembers.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #registeredMulticastGroupMembers(TransitGatewayMulticastRegisteredGroupMembers)}.
         * 
         * @param registeredMulticastGroupMembers
         *        a consumer that will call methods on {@link TransitGatewayMulticastRegisteredGroupMembers.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registeredMulticastGroupMembers(TransitGatewayMulticastRegisteredGroupMembers)
         */
        default Builder registeredMulticastGroupMembers(
                Consumer<TransitGatewayMulticastRegisteredGroupMembers.Builder> registeredMulticastGroupMembers) {
            return registeredMulticastGroupMembers(TransitGatewayMulticastRegisteredGroupMembers.builder()
                    .applyMutation(registeredMulticastGroupMembers).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private TransitGatewayMulticastRegisteredGroupMembers registeredMulticastGroupMembers;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterTransitGatewayMulticastGroupMembersResponse model) {
            super(model);
            registeredMulticastGroupMembers(model.registeredMulticastGroupMembers);
        }

        public final TransitGatewayMulticastRegisteredGroupMembers.Builder getRegisteredMulticastGroupMembers() {
            return registeredMulticastGroupMembers != null ? registeredMulticastGroupMembers.toBuilder() : null;
        }

        public final void setRegisteredMulticastGroupMembers(
                TransitGatewayMulticastRegisteredGroupMembers.BuilderImpl registeredMulticastGroupMembers) {
            this.registeredMulticastGroupMembers = registeredMulticastGroupMembers != null ? registeredMulticastGroupMembers
                    .build() : null;
        }

        @Override
        public final Builder registeredMulticastGroupMembers(
                TransitGatewayMulticastRegisteredGroupMembers registeredMulticastGroupMembers) {
            this.registeredMulticastGroupMembers = registeredMulticastGroupMembers;
            return this;
        }

        @Override
        public RegisterTransitGatewayMulticastGroupMembersResponse build() {
            return new RegisterTransitGatewayMulticastGroupMembersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
