/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AllocateAddressResponse extends Ec2Response implements
        ToCopyableBuilder<AllocateAddressResponse.Builder, AllocateAddressResponse> {
    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AllocationId")
            .getter(getter(AllocateAddressResponse::allocationId))
            .setter(setter(Builder::allocationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId")
                    .unmarshallLocationName("allocationId").build()).build();

    private static final SdkField<String> PUBLIC_IPV4_POOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PublicIpv4Pool")
            .getter(getter(AllocateAddressResponse::publicIpv4Pool))
            .setter(setter(Builder::publicIpv4Pool))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIpv4Pool")
                    .unmarshallLocationName("publicIpv4Pool").build()).build();

    private static final SdkField<String> NETWORK_BORDER_GROUP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkBorderGroup")
            .getter(getter(AllocateAddressResponse::networkBorderGroup))
            .setter(setter(Builder::networkBorderGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkBorderGroup")
                    .unmarshallLocationName("networkBorderGroup").build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Domain")
            .getter(getter(AllocateAddressResponse::domainAsString))
            .setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain")
                    .unmarshallLocationName("domain").build()).build();

    private static final SdkField<String> CUSTOMER_OWNED_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CustomerOwnedIp")
            .getter(getter(AllocateAddressResponse::customerOwnedIp))
            .setter(setter(Builder::customerOwnedIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerOwnedIp")
                    .unmarshallLocationName("customerOwnedIp").build()).build();

    private static final SdkField<String> CUSTOMER_OWNED_IPV4_POOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CustomerOwnedIpv4Pool")
            .getter(getter(AllocateAddressResponse::customerOwnedIpv4Pool))
            .setter(setter(Builder::customerOwnedIpv4Pool))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerOwnedIpv4Pool")
                    .unmarshallLocationName("customerOwnedIpv4Pool").build()).build();

    private static final SdkField<String> CARRIER_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CarrierIp")
            .getter(getter(AllocateAddressResponse::carrierIp))
            .setter(setter(Builder::carrierIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CarrierIp")
                    .unmarshallLocationName("carrierIp").build()).build();

    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PublicIp")
            .getter(getter(AllocateAddressResponse::publicIp))
            .setter(setter(Builder::publicIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp")
                    .unmarshallLocationName("publicIp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_ID_FIELD,
            PUBLIC_IPV4_POOL_FIELD, NETWORK_BORDER_GROUP_FIELD, DOMAIN_FIELD, CUSTOMER_OWNED_IP_FIELD,
            CUSTOMER_OWNED_IPV4_POOL_FIELD, CARRIER_IP_FIELD, PUBLIC_IP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String allocationId;

    private final String publicIpv4Pool;

    private final String networkBorderGroup;

    private final String domain;

    private final String customerOwnedIp;

    private final String customerOwnedIpv4Pool;

    private final String carrierIp;

    private final String publicIp;

    private AllocateAddressResponse(BuilderImpl builder) {
        super(builder);
        this.allocationId = builder.allocationId;
        this.publicIpv4Pool = builder.publicIpv4Pool;
        this.networkBorderGroup = builder.networkBorderGroup;
        this.domain = builder.domain;
        this.customerOwnedIp = builder.customerOwnedIp;
        this.customerOwnedIpv4Pool = builder.customerOwnedIpv4Pool;
        this.carrierIp = builder.carrierIp;
        this.publicIp = builder.publicIp;
    }

    /**
     * <p>
     * The ID that represents the allocation of the Elastic IP address.
     * </p>
     * 
     * @return The ID that represents the allocation of the Elastic IP address.
     */
    public final String allocationId() {
        return allocationId;
    }

    /**
     * <p>
     * The ID of an address pool that you own.
     * </p>
     * 
     * @return The ID of an address pool that you own.
     */
    public final String publicIpv4Pool() {
        return publicIpv4Pool;
    }

    /**
     * <p>
     * The set of Availability Zones, Local Zones, or Wavelength Zones from which Amazon Web Services advertises IP
     * addresses.
     * </p>
     * 
     * @return The set of Availability Zones, Local Zones, or Wavelength Zones from which Amazon Web Services advertises
     *         IP addresses.
     */
    public final String networkBorderGroup() {
        return networkBorderGroup;
    }

    /**
     * <p>
     * The network (<code>vpc</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link DomainType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainAsString}.
     * </p>
     * 
     * @return The network (<code>vpc</code>).
     * @see DomainType
     */
    public final DomainType domain() {
        return DomainType.fromValue(domain);
    }

    /**
     * <p>
     * The network (<code>vpc</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link DomainType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainAsString}.
     * </p>
     * 
     * @return The network (<code>vpc</code>).
     * @see DomainType
     */
    public final String domainAsString() {
        return domain;
    }

    /**
     * <p>
     * The customer-owned IP address.
     * </p>
     * 
     * @return The customer-owned IP address.
     */
    public final String customerOwnedIp() {
        return customerOwnedIp;
    }

    /**
     * <p>
     * The ID of the customer-owned address pool.
     * </p>
     * 
     * @return The ID of the customer-owned address pool.
     */
    public final String customerOwnedIpv4Pool() {
        return customerOwnedIpv4Pool;
    }

    /**
     * <p>
     * The carrier IP address. Available only for network interfaces that reside in a subnet in a Wavelength Zone.
     * </p>
     * 
     * @return The carrier IP address. Available only for network interfaces that reside in a subnet in a Wavelength
     *         Zone.
     */
    public final String carrierIp() {
        return carrierIp;
    }

    /**
     * <p>
     * The Amazon-owned IP address. Not available when using an address pool that you own.
     * </p>
     * 
     * @return The Amazon-owned IP address. Not available when using an address pool that you own.
     */
    public final String publicIp() {
        return publicIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(publicIpv4Pool());
        hashCode = 31 * hashCode + Objects.hashCode(networkBorderGroup());
        hashCode = 31 * hashCode + Objects.hashCode(domainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(customerOwnedIp());
        hashCode = 31 * hashCode + Objects.hashCode(customerOwnedIpv4Pool());
        hashCode = 31 * hashCode + Objects.hashCode(carrierIp());
        hashCode = 31 * hashCode + Objects.hashCode(publicIp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateAddressResponse)) {
            return false;
        }
        AllocateAddressResponse other = (AllocateAddressResponse) obj;
        return Objects.equals(allocationId(), other.allocationId()) && Objects.equals(publicIpv4Pool(), other.publicIpv4Pool())
                && Objects.equals(networkBorderGroup(), other.networkBorderGroup())
                && Objects.equals(domainAsString(), other.domainAsString())
                && Objects.equals(customerOwnedIp(), other.customerOwnedIp())
                && Objects.equals(customerOwnedIpv4Pool(), other.customerOwnedIpv4Pool())
                && Objects.equals(carrierIp(), other.carrierIp()) && Objects.equals(publicIp(), other.publicIp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AllocateAddressResponse").add("AllocationId", allocationId())
                .add("PublicIpv4Pool", publicIpv4Pool()).add("NetworkBorderGroup", networkBorderGroup())
                .add("Domain", domainAsString()).add("CustomerOwnedIp", customerOwnedIp())
                .add("CustomerOwnedIpv4Pool", customerOwnedIpv4Pool()).add("CarrierIp", carrierIp()).add("PublicIp", publicIp())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllocationId":
            return Optional.ofNullable(clazz.cast(allocationId()));
        case "PublicIpv4Pool":
            return Optional.ofNullable(clazz.cast(publicIpv4Pool()));
        case "NetworkBorderGroup":
            return Optional.ofNullable(clazz.cast(networkBorderGroup()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domainAsString()));
        case "CustomerOwnedIp":
            return Optional.ofNullable(clazz.cast(customerOwnedIp()));
        case "CustomerOwnedIpv4Pool":
            return Optional.ofNullable(clazz.cast(customerOwnedIpv4Pool()));
        case "CarrierIp":
            return Optional.ofNullable(clazz.cast(carrierIp()));
        case "PublicIp":
            return Optional.ofNullable(clazz.cast(publicIp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AllocationId", ALLOCATION_ID_FIELD);
        map.put("PublicIpv4Pool", PUBLIC_IPV4_POOL_FIELD);
        map.put("NetworkBorderGroup", NETWORK_BORDER_GROUP_FIELD);
        map.put("Domain", DOMAIN_FIELD);
        map.put("CustomerOwnedIp", CUSTOMER_OWNED_IP_FIELD);
        map.put("CustomerOwnedIpv4Pool", CUSTOMER_OWNED_IPV4_POOL_FIELD);
        map.put("CarrierIp", CARRIER_IP_FIELD);
        map.put("PublicIp", PUBLIC_IP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AllocateAddressResponse, T> g) {
        return obj -> g.apply((AllocateAddressResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, AllocateAddressResponse> {
        /**
         * <p>
         * The ID that represents the allocation of the Elastic IP address.
         * </p>
         * 
         * @param allocationId
         *        The ID that represents the allocation of the Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationId(String allocationId);

        /**
         * <p>
         * The ID of an address pool that you own.
         * </p>
         * 
         * @param publicIpv4Pool
         *        The ID of an address pool that you own.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIpv4Pool(String publicIpv4Pool);

        /**
         * <p>
         * The set of Availability Zones, Local Zones, or Wavelength Zones from which Amazon Web Services advertises IP
         * addresses.
         * </p>
         * 
         * @param networkBorderGroup
         *        The set of Availability Zones, Local Zones, or Wavelength Zones from which Amazon Web Services
         *        advertises IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkBorderGroup(String networkBorderGroup);

        /**
         * <p>
         * The network (<code>vpc</code>).
         * </p>
         * 
         * @param domain
         *        The network (<code>vpc</code>).
         * @see DomainType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainType
         */
        Builder domain(String domain);

        /**
         * <p>
         * The network (<code>vpc</code>).
         * </p>
         * 
         * @param domain
         *        The network (<code>vpc</code>).
         * @see DomainType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainType
         */
        Builder domain(DomainType domain);

        /**
         * <p>
         * The customer-owned IP address.
         * </p>
         * 
         * @param customerOwnedIp
         *        The customer-owned IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerOwnedIp(String customerOwnedIp);

        /**
         * <p>
         * The ID of the customer-owned address pool.
         * </p>
         * 
         * @param customerOwnedIpv4Pool
         *        The ID of the customer-owned address pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerOwnedIpv4Pool(String customerOwnedIpv4Pool);

        /**
         * <p>
         * The carrier IP address. Available only for network interfaces that reside in a subnet in a Wavelength Zone.
         * </p>
         * 
         * @param carrierIp
         *        The carrier IP address. Available only for network interfaces that reside in a subnet in a Wavelength
         *        Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder carrierIp(String carrierIp);

        /**
         * <p>
         * The Amazon-owned IP address. Not available when using an address pool that you own.
         * </p>
         * 
         * @param publicIp
         *        The Amazon-owned IP address. Not available when using an address pool that you own.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String allocationId;

        private String publicIpv4Pool;

        private String networkBorderGroup;

        private String domain;

        private String customerOwnedIp;

        private String customerOwnedIpv4Pool;

        private String carrierIp;

        private String publicIp;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateAddressResponse model) {
            super(model);
            allocationId(model.allocationId);
            publicIpv4Pool(model.publicIpv4Pool);
            networkBorderGroup(model.networkBorderGroup);
            domain(model.domain);
            customerOwnedIp(model.customerOwnedIp);
            customerOwnedIpv4Pool(model.customerOwnedIpv4Pool);
            carrierIp(model.carrierIp);
            publicIp(model.publicIp);
        }

        public final String getAllocationId() {
            return allocationId;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final String getPublicIpv4Pool() {
            return publicIpv4Pool;
        }

        public final void setPublicIpv4Pool(String publicIpv4Pool) {
            this.publicIpv4Pool = publicIpv4Pool;
        }

        @Override
        public final Builder publicIpv4Pool(String publicIpv4Pool) {
            this.publicIpv4Pool = publicIpv4Pool;
            return this;
        }

        public final String getNetworkBorderGroup() {
            return networkBorderGroup;
        }

        public final void setNetworkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
        }

        @Override
        public final Builder networkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(DomainType domain) {
            this.domain(domain == null ? null : domain.toString());
            return this;
        }

        public final String getCustomerOwnedIp() {
            return customerOwnedIp;
        }

        public final void setCustomerOwnedIp(String customerOwnedIp) {
            this.customerOwnedIp = customerOwnedIp;
        }

        @Override
        public final Builder customerOwnedIp(String customerOwnedIp) {
            this.customerOwnedIp = customerOwnedIp;
            return this;
        }

        public final String getCustomerOwnedIpv4Pool() {
            return customerOwnedIpv4Pool;
        }

        public final void setCustomerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
        }

        @Override
        public final Builder customerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
            return this;
        }

        public final String getCarrierIp() {
            return carrierIp;
        }

        public final void setCarrierIp(String carrierIp) {
            this.carrierIp = carrierIp;
        }

        @Override
        public final Builder carrierIp(String carrierIp) {
            this.carrierIp = carrierIp;
            return this;
        }

        public final String getPublicIp() {
            return publicIp;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        @Override
        public AllocateAddressResponse build() {
            return new AllocateAddressResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
