/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisionIpamByoasnRequest extends Ec2Request implements
        ToCopyableBuilder<ProvisionIpamByoasnRequest.Builder, ProvisionIpamByoasnRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ProvisionIpamByoasnRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> IPAM_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamId")
            .getter(getter(ProvisionIpamByoasnRequest::ipamId))
            .setter(setter(Builder::ipamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamId")
                    .unmarshallLocationName("IpamId").build()).build();

    private static final SdkField<String> ASN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Asn")
            .getter(getter(ProvisionIpamByoasnRequest::asn))
            .setter(setter(Builder::asn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Asn").unmarshallLocationName("Asn")
                    .build()).build();

    private static final SdkField<AsnAuthorizationContext> ASN_AUTHORIZATION_CONTEXT_FIELD = SdkField
            .<AsnAuthorizationContext> builder(MarshallingType.SDK_POJO)
            .memberName("AsnAuthorizationContext")
            .getter(getter(ProvisionIpamByoasnRequest::asnAuthorizationContext))
            .setter(setter(Builder::asnAuthorizationContext))
            .constructor(AsnAuthorizationContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AsnAuthorizationContext")
                    .unmarshallLocationName("AsnAuthorizationContext").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, IPAM_ID_FIELD,
            ASN_FIELD, ASN_AUTHORIZATION_CONTEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean dryRun;

    private final String ipamId;

    private final String asn;

    private final AsnAuthorizationContext asnAuthorizationContext;

    private ProvisionIpamByoasnRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.ipamId = builder.ipamId;
        this.asn = builder.asn;
        this.asnAuthorizationContext = builder.asnAuthorizationContext;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * An IPAM ID.
     * </p>
     * 
     * @return An IPAM ID.
     */
    public final String ipamId() {
        return ipamId;
    }

    /**
     * <p>
     * A public 2-byte or 4-byte ASN.
     * </p>
     * 
     * @return A public 2-byte or 4-byte ASN.
     */
    public final String asn() {
        return asn;
    }

    /**
     * <p>
     * An ASN authorization context.
     * </p>
     * 
     * @return An ASN authorization context.
     */
    public final AsnAuthorizationContext asnAuthorizationContext() {
        return asnAuthorizationContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(ipamId());
        hashCode = 31 * hashCode + Objects.hashCode(asn());
        hashCode = 31 * hashCode + Objects.hashCode(asnAuthorizationContext());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionIpamByoasnRequest)) {
            return false;
        }
        ProvisionIpamByoasnRequest other = (ProvisionIpamByoasnRequest) obj;
        return Objects.equals(dryRun(), other.dryRun()) && Objects.equals(ipamId(), other.ipamId())
                && Objects.equals(asn(), other.asn())
                && Objects.equals(asnAuthorizationContext(), other.asnAuthorizationContext());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisionIpamByoasnRequest").add("DryRun", dryRun()).add("IpamId", ipamId()).add("Asn", asn())
                .add("AsnAuthorizationContext", asnAuthorizationContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "IpamId":
            return Optional.ofNullable(clazz.cast(ipamId()));
        case "Asn":
            return Optional.ofNullable(clazz.cast(asn()));
        case "AsnAuthorizationContext":
            return Optional.ofNullable(clazz.cast(asnAuthorizationContext()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("IpamId", IPAM_ID_FIELD);
        map.put("Asn", ASN_FIELD);
        map.put("AsnAuthorizationContext", ASN_AUTHORIZATION_CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisionIpamByoasnRequest, T> g) {
        return obj -> g.apply((ProvisionIpamByoasnRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ProvisionIpamByoasnRequest> {
        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * An IPAM ID.
         * </p>
         * 
         * @param ipamId
         *        An IPAM ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamId(String ipamId);

        /**
         * <p>
         * A public 2-byte or 4-byte ASN.
         * </p>
         * 
         * @param asn
         *        A public 2-byte or 4-byte ASN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asn(String asn);

        /**
         * <p>
         * An ASN authorization context.
         * </p>
         * 
         * @param asnAuthorizationContext
         *        An ASN authorization context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asnAuthorizationContext(AsnAuthorizationContext asnAuthorizationContext);

        /**
         * <p>
         * An ASN authorization context.
         * </p>
         * This is a convenience method that creates an instance of the {@link AsnAuthorizationContext.Builder} avoiding
         * the need to create one manually via {@link AsnAuthorizationContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AsnAuthorizationContext.Builder#build()} is called immediately
         * and its result is passed to {@link #asnAuthorizationContext(AsnAuthorizationContext)}.
         * 
         * @param asnAuthorizationContext
         *        a consumer that will call methods on {@link AsnAuthorizationContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #asnAuthorizationContext(AsnAuthorizationContext)
         */
        default Builder asnAuthorizationContext(Consumer<AsnAuthorizationContext.Builder> asnAuthorizationContext) {
            return asnAuthorizationContext(AsnAuthorizationContext.builder().applyMutation(asnAuthorizationContext).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String ipamId;

        private String asn;

        private AsnAuthorizationContext asnAuthorizationContext;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionIpamByoasnRequest model) {
            super(model);
            dryRun(model.dryRun);
            ipamId(model.ipamId);
            asn(model.asn);
            asnAuthorizationContext(model.asnAuthorizationContext);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getIpamId() {
            return ipamId;
        }

        public final void setIpamId(String ipamId) {
            this.ipamId = ipamId;
        }

        @Override
        public final Builder ipamId(String ipamId) {
            this.ipamId = ipamId;
            return this;
        }

        public final String getAsn() {
            return asn;
        }

        public final void setAsn(String asn) {
            this.asn = asn;
        }

        @Override
        public final Builder asn(String asn) {
            this.asn = asn;
            return this;
        }

        public final AsnAuthorizationContext.Builder getAsnAuthorizationContext() {
            return asnAuthorizationContext != null ? asnAuthorizationContext.toBuilder() : null;
        }

        public final void setAsnAuthorizationContext(AsnAuthorizationContext.BuilderImpl asnAuthorizationContext) {
            this.asnAuthorizationContext = asnAuthorizationContext != null ? asnAuthorizationContext.build() : null;
        }

        @Override
        public final Builder asnAuthorizationContext(AsnAuthorizationContext asnAuthorizationContext) {
            this.asnAuthorizationContext = asnAuthorizationContext;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ProvisionIpamByoasnRequest build() {
            return new ProvisionIpamByoasnRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
