/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Capacity Reservation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityReservation implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityReservation.Builder, CapacityReservation> {
    private static final SdkField<String> CAPACITY_RESERVATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityReservationId")
            .getter(getter(CapacityReservation::capacityReservationId))
            .setter(setter(Builder::capacityReservationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationId")
                    .unmarshallLocationName("capacityReservationId").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(CapacityReservation::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<String> CAPACITY_RESERVATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityReservationArn")
            .getter(getter(CapacityReservation::capacityReservationArn))
            .setter(setter(Builder::capacityReservationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationArn")
                    .unmarshallLocationName("capacityReservationArn").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZoneId")
            .getter(getter(CapacityReservation::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId")
                    .unmarshallLocationName("availabilityZoneId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceType")
            .getter(getter(CapacityReservation::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("instanceType").build()).build();

    private static final SdkField<String> INSTANCE_PLATFORM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstancePlatform")
            .getter(getter(CapacityReservation::instancePlatformAsString))
            .setter(setter(Builder::instancePlatform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePlatform")
                    .unmarshallLocationName("instancePlatform").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(CapacityReservation::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<String> TENANCY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Tenancy")
            .getter(getter(CapacityReservation::tenancyAsString))
            .setter(setter(Builder::tenancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy")
                    .unmarshallLocationName("tenancy").build()).build();

    private static final SdkField<Integer> TOTAL_INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalInstanceCount")
            .getter(getter(CapacityReservation::totalInstanceCount))
            .setter(setter(Builder::totalInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalInstanceCount")
                    .unmarshallLocationName("totalInstanceCount").build()).build();

    private static final SdkField<Integer> AVAILABLE_INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AvailableInstanceCount")
            .getter(getter(CapacityReservation::availableInstanceCount))
            .setter(setter(Builder::availableInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableInstanceCount")
                    .unmarshallLocationName("availableInstanceCount").build()).build();

    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EbsOptimized")
            .getter(getter(CapacityReservation::ebsOptimized))
            .setter(setter(Builder::ebsOptimized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized")
                    .unmarshallLocationName("ebsOptimized").build()).build();

    private static final SdkField<Boolean> EPHEMERAL_STORAGE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EphemeralStorage")
            .getter(getter(CapacityReservation::ephemeralStorage))
            .setter(setter(Builder::ephemeralStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EphemeralStorage")
                    .unmarshallLocationName("ephemeralStorage").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(CapacityReservation::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<Instant> START_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartDate")
            .getter(getter(CapacityReservation::startDate))
            .setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate")
                    .unmarshallLocationName("startDate").build()).build();

    private static final SdkField<Instant> END_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndDate")
            .getter(getter(CapacityReservation::endDate))
            .setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate")
                    .unmarshallLocationName("endDate").build()).build();

    private static final SdkField<String> END_DATE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EndDateType")
            .getter(getter(CapacityReservation::endDateTypeAsString))
            .setter(setter(Builder::endDateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDateType")
                    .unmarshallLocationName("endDateType").build()).build();

    private static final SdkField<String> INSTANCE_MATCH_CRITERIA_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceMatchCriteria")
            .getter(getter(CapacityReservation::instanceMatchCriteriaAsString))
            .setter(setter(Builder::instanceMatchCriteria))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMatchCriteria")
                    .unmarshallLocationName("instanceMatchCriteria").build()).build();

    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateDate")
            .getter(getter(CapacityReservation::createDate))
            .setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate")
                    .unmarshallLocationName("createDate").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CapacityReservation::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutpostArn")
            .getter(getter(CapacityReservation::outpostArn))
            .setter(setter(Builder::outpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn")
                    .unmarshallLocationName("outpostArn").build()).build();

    private static final SdkField<String> CAPACITY_RESERVATION_FLEET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityReservationFleetId")
            .getter(getter(CapacityReservation::capacityReservationFleetId))
            .setter(setter(Builder::capacityReservationFleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationFleetId")
                    .unmarshallLocationName("capacityReservationFleetId").build()).build();

    private static final SdkField<String> PLACEMENT_GROUP_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PlacementGroupArn")
            .getter(getter(CapacityReservation::placementGroupArn))
            .setter(setter(Builder::placementGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementGroupArn")
                    .unmarshallLocationName("placementGroupArn").build()).build();

    private static final SdkField<List<CapacityAllocation>> CAPACITY_ALLOCATIONS_FIELD = SdkField
            .<List<CapacityAllocation>> builder(MarshallingType.LIST)
            .memberName("CapacityAllocations")
            .getter(getter(CapacityReservation::capacityAllocations))
            .setter(setter(Builder::capacityAllocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityAllocationSet")
                    .unmarshallLocationName("capacityAllocationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<CapacityAllocation> builder(MarshallingType.SDK_POJO)
                                            .constructor(CapacityAllocation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> RESERVATION_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReservationType")
            .getter(getter(CapacityReservation::reservationTypeAsString))
            .setter(setter(Builder::reservationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationType")
                    .unmarshallLocationName("reservationType").build()).build();

    private static final SdkField<String> UNUSED_RESERVATION_BILLING_OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UnusedReservationBillingOwnerId")
            .getter(getter(CapacityReservation::unusedReservationBillingOwnerId))
            .setter(setter(Builder::unusedReservationBillingOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnusedReservationBillingOwnerId")
                    .unmarshallLocationName("unusedReservationBillingOwnerId").build()).build();

    private static final SdkField<CapacityReservationCommitmentInfo> COMMITMENT_INFO_FIELD = SdkField
            .<CapacityReservationCommitmentInfo> builder(MarshallingType.SDK_POJO)
            .memberName("CommitmentInfo")
            .getter(getter(CapacityReservation::commitmentInfo))
            .setter(setter(Builder::commitmentInfo))
            .constructor(CapacityReservationCommitmentInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitmentInfo")
                    .unmarshallLocationName("commitmentInfo").build()).build();

    private static final SdkField<String> DELIVERY_PREFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DeliveryPreference")
            .getter(getter(CapacityReservation::deliveryPreferenceAsString))
            .setter(setter(Builder::deliveryPreference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryPreference")
                    .unmarshallLocationName("deliveryPreference").build()).build();

    private static final SdkField<String> CAPACITY_BLOCK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityBlockId")
            .getter(getter(CapacityReservation::capacityBlockId))
            .setter(setter(Builder::capacityBlockId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockId")
                    .unmarshallLocationName("capacityBlockId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CAPACITY_RESERVATION_ID_FIELD, OWNER_ID_FIELD, CAPACITY_RESERVATION_ARN_FIELD,
                    AVAILABILITY_ZONE_ID_FIELD, INSTANCE_TYPE_FIELD, INSTANCE_PLATFORM_FIELD, AVAILABILITY_ZONE_FIELD,
                    TENANCY_FIELD, TOTAL_INSTANCE_COUNT_FIELD, AVAILABLE_INSTANCE_COUNT_FIELD, EBS_OPTIMIZED_FIELD,
                    EPHEMERAL_STORAGE_FIELD, STATE_FIELD, START_DATE_FIELD, END_DATE_FIELD, END_DATE_TYPE_FIELD,
                    INSTANCE_MATCH_CRITERIA_FIELD, CREATE_DATE_FIELD, TAGS_FIELD, OUTPOST_ARN_FIELD,
                    CAPACITY_RESERVATION_FLEET_ID_FIELD, PLACEMENT_GROUP_ARN_FIELD, CAPACITY_ALLOCATIONS_FIELD,
                    RESERVATION_TYPE_FIELD, UNUSED_RESERVATION_BILLING_OWNER_ID_FIELD, COMMITMENT_INFO_FIELD,
                    DELIVERY_PREFERENCE_FIELD, CAPACITY_BLOCK_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String capacityReservationId;

    private final String ownerId;

    private final String capacityReservationArn;

    private final String availabilityZoneId;

    private final String instanceType;

    private final String instancePlatform;

    private final String availabilityZone;

    private final String tenancy;

    private final Integer totalInstanceCount;

    private final Integer availableInstanceCount;

    private final Boolean ebsOptimized;

    private final Boolean ephemeralStorage;

    private final String state;

    private final Instant startDate;

    private final Instant endDate;

    private final String endDateType;

    private final String instanceMatchCriteria;

    private final Instant createDate;

    private final List<Tag> tags;

    private final String outpostArn;

    private final String capacityReservationFleetId;

    private final String placementGroupArn;

    private final List<CapacityAllocation> capacityAllocations;

    private final String reservationType;

    private final String unusedReservationBillingOwnerId;

    private final CapacityReservationCommitmentInfo commitmentInfo;

    private final String deliveryPreference;

    private final String capacityBlockId;

    private CapacityReservation(BuilderImpl builder) {
        this.capacityReservationId = builder.capacityReservationId;
        this.ownerId = builder.ownerId;
        this.capacityReservationArn = builder.capacityReservationArn;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.instanceType = builder.instanceType;
        this.instancePlatform = builder.instancePlatform;
        this.availabilityZone = builder.availabilityZone;
        this.tenancy = builder.tenancy;
        this.totalInstanceCount = builder.totalInstanceCount;
        this.availableInstanceCount = builder.availableInstanceCount;
        this.ebsOptimized = builder.ebsOptimized;
        this.ephemeralStorage = builder.ephemeralStorage;
        this.state = builder.state;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.endDateType = builder.endDateType;
        this.instanceMatchCriteria = builder.instanceMatchCriteria;
        this.createDate = builder.createDate;
        this.tags = builder.tags;
        this.outpostArn = builder.outpostArn;
        this.capacityReservationFleetId = builder.capacityReservationFleetId;
        this.placementGroupArn = builder.placementGroupArn;
        this.capacityAllocations = builder.capacityAllocations;
        this.reservationType = builder.reservationType;
        this.unusedReservationBillingOwnerId = builder.unusedReservationBillingOwnerId;
        this.commitmentInfo = builder.commitmentInfo;
        this.deliveryPreference = builder.deliveryPreference;
        this.capacityBlockId = builder.capacityBlockId;
    }

    /**
     * <p>
     * The ID of the Capacity Reservation.
     * </p>
     * 
     * @return The ID of the Capacity Reservation.
     */
    public final String capacityReservationId() {
        return capacityReservationId;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the Capacity Reservation.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the Capacity Reservation.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Capacity Reservation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Capacity Reservation.
     */
    public final String capacityReservationArn() {
        return capacityReservationArn;
    }

    /**
     * <p>
     * The ID of the Availability Zone in which the capacity is reserved.
     * </p>
     * 
     * @return The ID of the Availability Zone in which the capacity is reserved.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * The type of instance for which the Capacity Reservation reserves capacity.
     * </p>
     * 
     * @return The type of instance for which the Capacity Reservation reserves capacity.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The type of operating system for which the Capacity Reservation reserves capacity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instancePlatform}
     * will return {@link CapacityReservationInstancePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #instancePlatformAsString}.
     * </p>
     * 
     * @return The type of operating system for which the Capacity Reservation reserves capacity.
     * @see CapacityReservationInstancePlatform
     */
    public final CapacityReservationInstancePlatform instancePlatform() {
        return CapacityReservationInstancePlatform.fromValue(instancePlatform);
    }

    /**
     * <p>
     * The type of operating system for which the Capacity Reservation reserves capacity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instancePlatform}
     * will return {@link CapacityReservationInstancePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #instancePlatformAsString}.
     * </p>
     * 
     * @return The type of operating system for which the Capacity Reservation reserves capacity.
     * @see CapacityReservationInstancePlatform
     */
    public final String instancePlatformAsString() {
        return instancePlatform;
    }

    /**
     * <p>
     * The Availability Zone in which the capacity is reserved.
     * </p>
     * 
     * @return The Availability Zone in which the capacity is reserved.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy
     * settings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>default</code> - The Capacity Reservation is created on hardware that is shared with other Amazon Web
     * Services accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a
     * single Amazon Web Services account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link CapacityReservationTenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #tenancyAsString}.
     * </p>
     * 
     * @return Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following
     *         tenancy settings:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>default</code> - The Capacity Reservation is created on hardware that is shared with other Amazon
     *         Web Services accounts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated
     *         to a single Amazon Web Services account.
     *         </p>
     *         </li>
     * @see CapacityReservationTenancy
     */
    public final CapacityReservationTenancy tenancy() {
        return CapacityReservationTenancy.fromValue(tenancy);
    }

    /**
     * <p>
     * Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy
     * settings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>default</code> - The Capacity Reservation is created on hardware that is shared with other Amazon Web
     * Services accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a
     * single Amazon Web Services account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link CapacityReservationTenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #tenancyAsString}.
     * </p>
     * 
     * @return Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following
     *         tenancy settings:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>default</code> - The Capacity Reservation is created on hardware that is shared with other Amazon
     *         Web Services accounts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated
     *         to a single Amazon Web Services account.
     *         </p>
     *         </li>
     * @see CapacityReservationTenancy
     */
    public final String tenancyAsString() {
        return tenancy;
    }

    /**
     * <p>
     * The total number of instances for which the Capacity Reservation reserves capacity.
     * </p>
     * 
     * @return The total number of instances for which the Capacity Reservation reserves capacity.
     */
    public final Integer totalInstanceCount() {
        return totalInstanceCount;
    }

    /**
     * <p>
     * The remaining capacity. Indicates the number of instances that can be launched in the Capacity Reservation.
     * </p>
     * 
     * @return The remaining capacity. Indicates the number of instances that can be launched in the Capacity
     *         Reservation.
     */
    public final Integer availableInstanceCount() {
        return availableInstanceCount;
    }

    /**
     * <p>
     * Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides dedicated
     * throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This
     * optimization isn't available with all instance types. Additional usage charges apply when using an EBS- optimized
     * instance.
     * </p>
     * 
     * @return Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides
     *         dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O
     *         performance. This optimization isn't available with all instance types. Additional usage charges apply
     *         when using an EBS- optimized instance.
     */
    public final Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * <i>Deprecated.</i>
     * </p>
     * 
     * @return <i>Deprecated.</i>
     */
    public final Boolean ephemeralStorage() {
        return ephemeralStorage;
    }

    /**
     * <p>
     * The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>active</code> - The capacity is available for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in your
     * reservation request. The reserved capacity is no longer available for your use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cancelled</code> - The Capacity Reservation was canceled. The reserved capacity is no longer available for
     * your use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is still
     * pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failed</code> - The Capacity Reservation request has failed. A request can fail due to request parameters
     * that are not valid, capacity constraints, or instance limit constraints. You can view a failed request for 60
     * minutes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>scheduled</code> - (<i>Future-dated Capacity Reservations</i>) The future-dated Capacity Reservation
     * request was approved and the Capacity Reservation is scheduled for delivery on the requested start date.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>payment-pending</code> - (<i>Capacity Blocks</i>) The upfront payment has not been processed yet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>payment-failed</code> - (<i>Capacity Blocks</i>) The upfront payment was not processed in the 12-hour time
     * frame. Your Capacity Block was released.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>assessing</code> - (<i>Future-dated Capacity Reservations</i>) Amazon EC2 is assessing your request for a
     * future-dated Capacity Reservation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>delayed</code> - (<i>Future-dated Capacity Reservations</i>) Amazon EC2 encountered a delay in provisioning
     * the requested future-dated Capacity Reservation. Amazon EC2 is unable to deliver the requested capacity by the
     * requested start date and time.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unsupported</code> - (<i>Future-dated Capacity Reservations</i>) Amazon EC2 can't support the future-dated
     * Capacity Reservation request due to capacity constraints. You can view unsupported requests for 30 days. The
     * Capacity Reservation will not be delivered.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CapacityReservationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following
     *         states:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>active</code> - The capacity is available for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in
     *         your reservation request. The reserved capacity is no longer available for your use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cancelled</code> - The Capacity Reservation was canceled. The reserved capacity is no longer
     *         available for your use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is
     *         still pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>failed</code> - The Capacity Reservation request has failed. A request can fail due to request
     *         parameters that are not valid, capacity constraints, or instance limit constraints. You can view a failed
     *         request for 60 minutes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>scheduled</code> - (<i>Future-dated Capacity Reservations</i>) The future-dated Capacity
     *         Reservation request was approved and the Capacity Reservation is scheduled for delivery on the requested
     *         start date.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>payment-pending</code> - (<i>Capacity Blocks</i>) The upfront payment has not been processed yet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>payment-failed</code> - (<i>Capacity Blocks</i>) The upfront payment was not processed in the
     *         12-hour time frame. Your Capacity Block was released.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>assessing</code> - (<i>Future-dated Capacity Reservations</i>) Amazon EC2 is assessing your request
     *         for a future-dated Capacity Reservation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>delayed</code> - (<i>Future-dated Capacity Reservations</i>) Amazon EC2 encountered a delay in
     *         provisioning the requested future-dated Capacity Reservation. Amazon EC2 is unable to deliver the
     *         requested capacity by the requested start date and time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unsupported</code> - (<i>Future-dated Capacity Reservations</i>) Amazon EC2 can't support the
     *         future-dated Capacity Reservation request due to capacity constraints. You can view unsupported requests
     *         for 30 days. The Capacity Reservation will not be delivered.
     *         </p>
     *         </li>
     * @see CapacityReservationState
     */
    public final CapacityReservationState state() {
        return CapacityReservationState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>active</code> - The capacity is available for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in your
     * reservation request. The reserved capacity is no longer available for your use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cancelled</code> - The Capacity Reservation was canceled. The reserved capacity is no longer available for
     * your use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is still
     * pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failed</code> - The Capacity Reservation request has failed. A request can fail due to request parameters
     * that are not valid, capacity constraints, or instance limit constraints. You can view a failed request for 60
     * minutes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>scheduled</code> - (<i>Future-dated Capacity Reservations</i>) The future-dated Capacity Reservation
     * request was approved and the Capacity Reservation is scheduled for delivery on the requested start date.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>payment-pending</code> - (<i>Capacity Blocks</i>) The upfront payment has not been processed yet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>payment-failed</code> - (<i>Capacity Blocks</i>) The upfront payment was not processed in the 12-hour time
     * frame. Your Capacity Block was released.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>assessing</code> - (<i>Future-dated Capacity Reservations</i>) Amazon EC2 is assessing your request for a
     * future-dated Capacity Reservation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>delayed</code> - (<i>Future-dated Capacity Reservations</i>) Amazon EC2 encountered a delay in provisioning
     * the requested future-dated Capacity Reservation. Amazon EC2 is unable to deliver the requested capacity by the
     * requested start date and time.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unsupported</code> - (<i>Future-dated Capacity Reservations</i>) Amazon EC2 can't support the future-dated
     * Capacity Reservation request due to capacity constraints. You can view unsupported requests for 30 days. The
     * Capacity Reservation will not be delivered.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CapacityReservationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following
     *         states:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>active</code> - The capacity is available for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in
     *         your reservation request. The reserved capacity is no longer available for your use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cancelled</code> - The Capacity Reservation was canceled. The reserved capacity is no longer
     *         available for your use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is
     *         still pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>failed</code> - The Capacity Reservation request has failed. A request can fail due to request
     *         parameters that are not valid, capacity constraints, or instance limit constraints. You can view a failed
     *         request for 60 minutes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>scheduled</code> - (<i>Future-dated Capacity Reservations</i>) The future-dated Capacity
     *         Reservation request was approved and the Capacity Reservation is scheduled for delivery on the requested
     *         start date.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>payment-pending</code> - (<i>Capacity Blocks</i>) The upfront payment has not been processed yet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>payment-failed</code> - (<i>Capacity Blocks</i>) The upfront payment was not processed in the
     *         12-hour time frame. Your Capacity Block was released.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>assessing</code> - (<i>Future-dated Capacity Reservations</i>) Amazon EC2 is assessing your request
     *         for a future-dated Capacity Reservation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>delayed</code> - (<i>Future-dated Capacity Reservations</i>) Amazon EC2 encountered a delay in
     *         provisioning the requested future-dated Capacity Reservation. Amazon EC2 is unable to deliver the
     *         requested capacity by the requested start date and time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unsupported</code> - (<i>Future-dated Capacity Reservations</i>) Amazon EC2 can't support the
     *         future-dated Capacity Reservation request due to capacity constraints. You can view unsupported requests
     *         for 30 days. The Capacity Reservation will not be delivered.
     *         </p>
     *         </li>
     * @see CapacityReservationState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The date and time the Capacity Reservation was started.
     * </p>
     * 
     * @return The date and time the Capacity Reservation was started.
     */
    public final Instant startDate() {
        return startDate;
    }

    /**
     * <p>
     * The date and time the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is
     * released and you can no longer launch instances into it. The Capacity Reservation's state changes to
     * <code>expired</code> when it reaches its end date and time.
     * </p>
     * 
     * @return The date and time the Capacity Reservation expires. When a Capacity Reservation expires, the reserved
     *         capacity is released and you can no longer launch instances into it. The Capacity Reservation's state
     *         changes to <code>expired</code> when it reaches its end date and time.
     */
    public final Instant endDate() {
        return endDate;
    }

    /**
     * <p>
     * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following
     * end types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endDateType} will
     * return {@link EndDateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endDateTypeAsString}.
     * </p>
     * 
     * @return Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
     *         following end types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.
     *         </p>
     *         </li>
     * @see EndDateType
     */
    public final EndDateType endDateType() {
        return EndDateType.fromValue(endDateType);
    }

    /**
     * <p>
     * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following
     * end types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endDateType} will
     * return {@link EndDateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endDateTypeAsString}.
     * </p>
     * 
     * @return Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
     *         following end types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.
     *         </p>
     *         </li>
     * @see EndDateType
     */
    public final String endDateTypeAsString() {
        return endDateType;
    }

    /**
     * <p>
     * Indicates the type of instance launches that the Capacity Reservation accepts. The options include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>open</code> - The Capacity Reservation accepts all instances that have matching attributes (instance type,
     * platform, and Availability Zone). Instances that have matching attributes launch into the Capacity Reservation
     * automatically without specifying any additional parameters.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes (instance
     * type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only
     * permitted instances can use the reserved capacity.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceMatchCriteria} will return {@link InstanceMatchCriteria#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #instanceMatchCriteriaAsString}.
     * </p>
     * 
     * @return Indicates the type of instance launches that the Capacity Reservation accepts. The options include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>open</code> - The Capacity Reservation accepts all instances that have matching attributes
     *         (instance type, platform, and Availability Zone). Instances that have matching attributes launch into the
     *         Capacity Reservation automatically without specifying any additional parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes
     *         (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This
     *         ensures that only permitted instances can use the reserved capacity.
     *         </p>
     *         </li>
     * @see InstanceMatchCriteria
     */
    public final InstanceMatchCriteria instanceMatchCriteria() {
        return InstanceMatchCriteria.fromValue(instanceMatchCriteria);
    }

    /**
     * <p>
     * Indicates the type of instance launches that the Capacity Reservation accepts. The options include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>open</code> - The Capacity Reservation accepts all instances that have matching attributes (instance type,
     * platform, and Availability Zone). Instances that have matching attributes launch into the Capacity Reservation
     * automatically without specifying any additional parameters.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes (instance
     * type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only
     * permitted instances can use the reserved capacity.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceMatchCriteria} will return {@link InstanceMatchCriteria#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #instanceMatchCriteriaAsString}.
     * </p>
     * 
     * @return Indicates the type of instance launches that the Capacity Reservation accepts. The options include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>open</code> - The Capacity Reservation accepts all instances that have matching attributes
     *         (instance type, platform, and Availability Zone). Instances that have matching attributes launch into the
     *         Capacity Reservation automatically without specifying any additional parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes
     *         (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This
     *         ensures that only permitted instances can use the reserved capacity.
     *         </p>
     *         </li>
     * @see InstanceMatchCriteria
     */
    public final String instanceMatchCriteriaAsString() {
        return instanceMatchCriteria;
    }

    /**
     * <p>
     * The date and time the Capacity Reservation was created.
     * </p>
     * 
     * @return The date and time the Capacity Reservation was created.
     */
    public final Instant createDate() {
        return createDate;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags assigned to the Capacity Reservation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Any tags assigned to the Capacity Reservation.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Outpost on which the Capacity Reservation was created.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Outpost on which the Capacity Reservation was created.
     */
    public final String outpostArn() {
        return outpostArn;
    }

    /**
     * <p>
     * The ID of the Capacity Reservation Fleet to which the Capacity Reservation belongs. Only valid for Capacity
     * Reservations that were created by a Capacity Reservation Fleet.
     * </p>
     * 
     * @return The ID of the Capacity Reservation Fleet to which the Capacity Reservation belongs. Only valid for
     *         Capacity Reservations that were created by a Capacity Reservation Fleet.
     */
    public final String capacityReservationFleetId() {
        return capacityReservationFleetId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the cluster placement group in which the Capacity Reservation was created. For
     * more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-cpg.html"> Capacity
     * Reservations for cluster placement groups</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the cluster placement group in which the Capacity Reservation was
     *         created. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-cpg.html"> Capacity Reservations for cluster
     *         placement groups</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final String placementGroupArn() {
        return placementGroupArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the CapacityAllocations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapacityAllocations() {
        return capacityAllocations != null && !(capacityAllocations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about instance capacity usage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapacityAllocations} method.
     * </p>
     * 
     * @return Information about instance capacity usage.
     */
    public final List<CapacityAllocation> capacityAllocations() {
        return capacityAllocations;
    }

    /**
     * <p>
     * The type of Capacity Reservation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reservationType}
     * will return {@link CapacityReservationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reservationTypeAsString}.
     * </p>
     * 
     * @return The type of Capacity Reservation.
     * @see CapacityReservationType
     */
    public final CapacityReservationType reservationType() {
        return CapacityReservationType.fromValue(reservationType);
    }

    /**
     * <p>
     * The type of Capacity Reservation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reservationType}
     * will return {@link CapacityReservationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reservationTypeAsString}.
     * </p>
     * 
     * @return The type of Capacity Reservation.
     * @see CapacityReservationType
     */
    public final String reservationTypeAsString() {
        return reservationType;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account to which billing of the unused capacity of the Capacity Reservation is
     * assigned.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account to which billing of the unused capacity of the Capacity
     *         Reservation is assigned.
     */
    public final String unusedReservationBillingOwnerId() {
        return unusedReservationBillingOwnerId;
    }

    /**
     * <p>
     * Information about your commitment for a future-dated Capacity Reservation.
     * </p>
     * 
     * @return Information about your commitment for a future-dated Capacity Reservation.
     */
    public final CapacityReservationCommitmentInfo commitmentInfo() {
        return commitmentInfo;
    }

    /**
     * <p>
     * The delivery method for a future-dated Capacity Reservation. <code>incremental</code> indicates that the
     * requested capacity is delivered in addition to any running instances and reserved capacity that you have in your
     * account at the requested date and time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deliveryPreference} will return {@link CapacityReservationDeliveryPreference#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #deliveryPreferenceAsString}.
     * </p>
     * 
     * @return The delivery method for a future-dated Capacity Reservation. <code>incremental</code> indicates that the
     *         requested capacity is delivered in addition to any running instances and reserved capacity that you have
     *         in your account at the requested date and time.
     * @see CapacityReservationDeliveryPreference
     */
    public final CapacityReservationDeliveryPreference deliveryPreference() {
        return CapacityReservationDeliveryPreference.fromValue(deliveryPreference);
    }

    /**
     * <p>
     * The delivery method for a future-dated Capacity Reservation. <code>incremental</code> indicates that the
     * requested capacity is delivered in addition to any running instances and reserved capacity that you have in your
     * account at the requested date and time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deliveryPreference} will return {@link CapacityReservationDeliveryPreference#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #deliveryPreferenceAsString}.
     * </p>
     * 
     * @return The delivery method for a future-dated Capacity Reservation. <code>incremental</code> indicates that the
     *         requested capacity is delivered in addition to any running instances and reserved capacity that you have
     *         in your account at the requested date and time.
     * @see CapacityReservationDeliveryPreference
     */
    public final String deliveryPreferenceAsString() {
        return deliveryPreference;
    }

    /**
     * <p>
     * The ID of the Capacity Block.
     * </p>
     * 
     * @return The ID of the Capacity Block.
     */
    public final String capacityBlockId() {
        return capacityBlockId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationArn());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(instancePlatformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(tenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(totalInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(availableInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(ephemeralStorage());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        hashCode = 31 * hashCode + Objects.hashCode(endDateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceMatchCriteriaAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationFleetId());
        hashCode = 31 * hashCode + Objects.hashCode(placementGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapacityAllocations() ? capacityAllocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(reservationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(unusedReservationBillingOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(commitmentInfo());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(capacityBlockId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityReservation)) {
            return false;
        }
        CapacityReservation other = (CapacityReservation) obj;
        return Objects.equals(capacityReservationId(), other.capacityReservationId())
                && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(capacityReservationArn(), other.capacityReservationArn())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(instancePlatformAsString(), other.instancePlatformAsString())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(tenancyAsString(), other.tenancyAsString())
                && Objects.equals(totalInstanceCount(), other.totalInstanceCount())
                && Objects.equals(availableInstanceCount(), other.availableInstanceCount())
                && Objects.equals(ebsOptimized(), other.ebsOptimized())
                && Objects.equals(ephemeralStorage(), other.ephemeralStorage())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(startDate(), other.startDate())
                && Objects.equals(endDate(), other.endDate())
                && Objects.equals(endDateTypeAsString(), other.endDateTypeAsString())
                && Objects.equals(instanceMatchCriteriaAsString(), other.instanceMatchCriteriaAsString())
                && Objects.equals(createDate(), other.createDate()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(outpostArn(), other.outpostArn())
                && Objects.equals(capacityReservationFleetId(), other.capacityReservationFleetId())
                && Objects.equals(placementGroupArn(), other.placementGroupArn())
                && hasCapacityAllocations() == other.hasCapacityAllocations()
                && Objects.equals(capacityAllocations(), other.capacityAllocations())
                && Objects.equals(reservationTypeAsString(), other.reservationTypeAsString())
                && Objects.equals(unusedReservationBillingOwnerId(), other.unusedReservationBillingOwnerId())
                && Objects.equals(commitmentInfo(), other.commitmentInfo())
                && Objects.equals(deliveryPreferenceAsString(), other.deliveryPreferenceAsString())
                && Objects.equals(capacityBlockId(), other.capacityBlockId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityReservation").add("CapacityReservationId", capacityReservationId())
                .add("OwnerId", ownerId()).add("CapacityReservationArn", capacityReservationArn())
                .add("AvailabilityZoneId", availabilityZoneId()).add("InstanceType", instanceType())
                .add("InstancePlatform", instancePlatformAsString()).add("AvailabilityZone", availabilityZone())
                .add("Tenancy", tenancyAsString()).add("TotalInstanceCount", totalInstanceCount())
                .add("AvailableInstanceCount", availableInstanceCount()).add("EbsOptimized", ebsOptimized())
                .add("EphemeralStorage", ephemeralStorage()).add("State", stateAsString()).add("StartDate", startDate())
                .add("EndDate", endDate()).add("EndDateType", endDateTypeAsString())
                .add("InstanceMatchCriteria", instanceMatchCriteriaAsString()).add("CreateDate", createDate())
                .add("Tags", hasTags() ? tags() : null).add("OutpostArn", outpostArn())
                .add("CapacityReservationFleetId", capacityReservationFleetId()).add("PlacementGroupArn", placementGroupArn())
                .add("CapacityAllocations", hasCapacityAllocations() ? capacityAllocations() : null)
                .add("ReservationType", reservationTypeAsString())
                .add("UnusedReservationBillingOwnerId", unusedReservationBillingOwnerId())
                .add("CommitmentInfo", commitmentInfo()).add("DeliveryPreference", deliveryPreferenceAsString())
                .add("CapacityBlockId", capacityBlockId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityReservationId":
            return Optional.ofNullable(clazz.cast(capacityReservationId()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "CapacityReservationArn":
            return Optional.ofNullable(clazz.cast(capacityReservationArn()));
        case "AvailabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "InstancePlatform":
            return Optional.ofNullable(clazz.cast(instancePlatformAsString()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "Tenancy":
            return Optional.ofNullable(clazz.cast(tenancyAsString()));
        case "TotalInstanceCount":
            return Optional.ofNullable(clazz.cast(totalInstanceCount()));
        case "AvailableInstanceCount":
            return Optional.ofNullable(clazz.cast(availableInstanceCount()));
        case "EbsOptimized":
            return Optional.ofNullable(clazz.cast(ebsOptimized()));
        case "EphemeralStorage":
            return Optional.ofNullable(clazz.cast(ephemeralStorage()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StartDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "EndDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        case "EndDateType":
            return Optional.ofNullable(clazz.cast(endDateTypeAsString()));
        case "InstanceMatchCriteria":
            return Optional.ofNullable(clazz.cast(instanceMatchCriteriaAsString()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "OutpostArn":
            return Optional.ofNullable(clazz.cast(outpostArn()));
        case "CapacityReservationFleetId":
            return Optional.ofNullable(clazz.cast(capacityReservationFleetId()));
        case "PlacementGroupArn":
            return Optional.ofNullable(clazz.cast(placementGroupArn()));
        case "CapacityAllocations":
            return Optional.ofNullable(clazz.cast(capacityAllocations()));
        case "ReservationType":
            return Optional.ofNullable(clazz.cast(reservationTypeAsString()));
        case "UnusedReservationBillingOwnerId":
            return Optional.ofNullable(clazz.cast(unusedReservationBillingOwnerId()));
        case "CommitmentInfo":
            return Optional.ofNullable(clazz.cast(commitmentInfo()));
        case "DeliveryPreference":
            return Optional.ofNullable(clazz.cast(deliveryPreferenceAsString()));
        case "CapacityBlockId":
            return Optional.ofNullable(clazz.cast(capacityBlockId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CapacityReservationId", CAPACITY_RESERVATION_ID_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("CapacityReservationArn", CAPACITY_RESERVATION_ARN_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("InstancePlatform", INSTANCE_PLATFORM_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("Tenancy", TENANCY_FIELD);
        map.put("TotalInstanceCount", TOTAL_INSTANCE_COUNT_FIELD);
        map.put("AvailableInstanceCount", AVAILABLE_INSTANCE_COUNT_FIELD);
        map.put("EbsOptimized", EBS_OPTIMIZED_FIELD);
        map.put("EphemeralStorage", EPHEMERAL_STORAGE_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StartDate", START_DATE_FIELD);
        map.put("EndDate", END_DATE_FIELD);
        map.put("EndDateType", END_DATE_TYPE_FIELD);
        map.put("InstanceMatchCriteria", INSTANCE_MATCH_CRITERIA_FIELD);
        map.put("CreateDate", CREATE_DATE_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("OutpostArn", OUTPOST_ARN_FIELD);
        map.put("CapacityReservationFleetId", CAPACITY_RESERVATION_FLEET_ID_FIELD);
        map.put("PlacementGroupArn", PLACEMENT_GROUP_ARN_FIELD);
        map.put("CapacityAllocationSet", CAPACITY_ALLOCATIONS_FIELD);
        map.put("ReservationType", RESERVATION_TYPE_FIELD);
        map.put("UnusedReservationBillingOwnerId", UNUSED_RESERVATION_BILLING_OWNER_ID_FIELD);
        map.put("CommitmentInfo", COMMITMENT_INFO_FIELD);
        map.put("DeliveryPreference", DELIVERY_PREFERENCE_FIELD);
        map.put("CapacityBlockId", CAPACITY_BLOCK_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityReservation, T> g) {
        return obj -> g.apply((CapacityReservation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityReservation> {
        /**
         * <p>
         * The ID of the Capacity Reservation.
         * </p>
         * 
         * @param capacityReservationId
         *        The ID of the Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationId(String capacityReservationId);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the Capacity Reservation.
         * </p>
         * 
         * @param ownerId
         *        The ID of the Amazon Web Services account that owns the Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Capacity Reservation.
         * </p>
         * 
         * @param capacityReservationArn
         *        The Amazon Resource Name (ARN) of the Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationArn(String capacityReservationArn);

        /**
         * <p>
         * The ID of the Availability Zone in which the capacity is reserved.
         * </p>
         * 
         * @param availabilityZoneId
         *        The ID of the Availability Zone in which the capacity is reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * The type of instance for which the Capacity Reservation reserves capacity.
         * </p>
         * 
         * @param instanceType
         *        The type of instance for which the Capacity Reservation reserves capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The type of operating system for which the Capacity Reservation reserves capacity.
         * </p>
         * 
         * @param instancePlatform
         *        The type of operating system for which the Capacity Reservation reserves capacity.
         * @see CapacityReservationInstancePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationInstancePlatform
         */
        Builder instancePlatform(String instancePlatform);

        /**
         * <p>
         * The type of operating system for which the Capacity Reservation reserves capacity.
         * </p>
         * 
         * @param instancePlatform
         *        The type of operating system for which the Capacity Reservation reserves capacity.
         * @see CapacityReservationInstancePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationInstancePlatform
         */
        Builder instancePlatform(CapacityReservationInstancePlatform instancePlatform);

        /**
         * <p>
         * The Availability Zone in which the capacity is reserved.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which the capacity is reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following
         * tenancy settings:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>default</code> - The Capacity Reservation is created on hardware that is shared with other Amazon Web
         * Services accounts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a
         * single Amazon Web Services account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tenancy
         *        Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the
         *        following tenancy settings:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>default</code> - The Capacity Reservation is created on hardware that is shared with other
         *        Amazon Web Services accounts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is
         *        dedicated to a single Amazon Web Services account.
         *        </p>
         *        </li>
         * @see CapacityReservationTenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationTenancy
         */
        Builder tenancy(String tenancy);

        /**
         * <p>
         * Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following
         * tenancy settings:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>default</code> - The Capacity Reservation is created on hardware that is shared with other Amazon Web
         * Services accounts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a
         * single Amazon Web Services account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tenancy
         *        Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the
         *        following tenancy settings:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>default</code> - The Capacity Reservation is created on hardware that is shared with other
         *        Amazon Web Services accounts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is
         *        dedicated to a single Amazon Web Services account.
         *        </p>
         *        </li>
         * @see CapacityReservationTenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationTenancy
         */
        Builder tenancy(CapacityReservationTenancy tenancy);

        /**
         * <p>
         * The total number of instances for which the Capacity Reservation reserves capacity.
         * </p>
         * 
         * @param totalInstanceCount
         *        The total number of instances for which the Capacity Reservation reserves capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalInstanceCount(Integer totalInstanceCount);

        /**
         * <p>
         * The remaining capacity. Indicates the number of instances that can be launched in the Capacity Reservation.
         * </p>
         * 
         * @param availableInstanceCount
         *        The remaining capacity. Indicates the number of instances that can be launched in the Capacity
         *        Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableInstanceCount(Integer availableInstanceCount);

        /**
         * <p>
         * Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides
         * dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance.
         * This optimization isn't available with all instance types. Additional usage charges apply when using an EBS-
         * optimized instance.
         * </p>
         * 
         * @param ebsOptimized
         *        Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization
         *        provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal
         *        I/O performance. This optimization isn't available with all instance types. Additional usage charges
         *        apply when using an EBS- optimized instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * <i>Deprecated.</i>
         * </p>
         * 
         * @param ephemeralStorage
         *        <i>Deprecated.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ephemeralStorage(Boolean ephemeralStorage);

        /**
         * <p>
         * The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>active</code> - The capacity is available for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in your
         * reservation request. The reserved capacity is no longer available for your use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cancelled</code> - The Capacity Reservation was canceled. The reserved capacity is no longer available
         * for your use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is still
         * pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>failed</code> - The Capacity Reservation request has failed. A request can fail due to request
         * parameters that are not valid, capacity constraints, or instance limit constraints. You can view a failed
         * request for 60 minutes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>scheduled</code> - (<i>Future-dated Capacity Reservations</i>) The future-dated Capacity Reservation
         * request was approved and the Capacity Reservation is scheduled for delivery on the requested start date.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>payment-pending</code> - (<i>Capacity Blocks</i>) The upfront payment has not been processed yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>payment-failed</code> - (<i>Capacity Blocks</i>) The upfront payment was not processed in the 12-hour
         * time frame. Your Capacity Block was released.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>assessing</code> - (<i>Future-dated Capacity Reservations</i>) Amazon EC2 is assessing your request for
         * a future-dated Capacity Reservation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>delayed</code> - (<i>Future-dated Capacity Reservations</i>) Amazon EC2 encountered a delay in
         * provisioning the requested future-dated Capacity Reservation. Amazon EC2 is unable to deliver the requested
         * capacity by the requested start date and time.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unsupported</code> - (<i>Future-dated Capacity Reservations</i>) Amazon EC2 can't support the
         * future-dated Capacity Reservation request due to capacity constraints. You can view unsupported requests for
         * 30 days. The Capacity Reservation will not be delivered.
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following
         *        states:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>active</code> - The capacity is available for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified
         *        in your reservation request. The reserved capacity is no longer available for your use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cancelled</code> - The Capacity Reservation was canceled. The reserved capacity is no longer
         *        available for your use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning
         *        is still pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>failed</code> - The Capacity Reservation request has failed. A request can fail due to request
         *        parameters that are not valid, capacity constraints, or instance limit constraints. You can view a
         *        failed request for 60 minutes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>scheduled</code> - (<i>Future-dated Capacity Reservations</i>) The future-dated Capacity
         *        Reservation request was approved and the Capacity Reservation is scheduled for delivery on the
         *        requested start date.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>payment-pending</code> - (<i>Capacity Blocks</i>) The upfront payment has not been processed
         *        yet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>payment-failed</code> - (<i>Capacity Blocks</i>) The upfront payment was not processed in the
         *        12-hour time frame. Your Capacity Block was released.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>assessing</code> - (<i>Future-dated Capacity Reservations</i>) Amazon EC2 is assessing your
         *        request for a future-dated Capacity Reservation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>delayed</code> - (<i>Future-dated Capacity Reservations</i>) Amazon EC2 encountered a delay in
         *        provisioning the requested future-dated Capacity Reservation. Amazon EC2 is unable to deliver the
         *        requested capacity by the requested start date and time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unsupported</code> - (<i>Future-dated Capacity Reservations</i>) Amazon EC2 can't support the
         *        future-dated Capacity Reservation request due to capacity constraints. You can view unsupported
         *        requests for 30 days. The Capacity Reservation will not be delivered.
         *        </p>
         *        </li>
         * @see CapacityReservationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>active</code> - The capacity is available for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in your
         * reservation request. The reserved capacity is no longer available for your use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cancelled</code> - The Capacity Reservation was canceled. The reserved capacity is no longer available
         * for your use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is still
         * pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>failed</code> - The Capacity Reservation request has failed. A request can fail due to request
         * parameters that are not valid, capacity constraints, or instance limit constraints. You can view a failed
         * request for 60 minutes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>scheduled</code> - (<i>Future-dated Capacity Reservations</i>) The future-dated Capacity Reservation
         * request was approved and the Capacity Reservation is scheduled for delivery on the requested start date.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>payment-pending</code> - (<i>Capacity Blocks</i>) The upfront payment has not been processed yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>payment-failed</code> - (<i>Capacity Blocks</i>) The upfront payment was not processed in the 12-hour
         * time frame. Your Capacity Block was released.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>assessing</code> - (<i>Future-dated Capacity Reservations</i>) Amazon EC2 is assessing your request for
         * a future-dated Capacity Reservation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>delayed</code> - (<i>Future-dated Capacity Reservations</i>) Amazon EC2 encountered a delay in
         * provisioning the requested future-dated Capacity Reservation. Amazon EC2 is unable to deliver the requested
         * capacity by the requested start date and time.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unsupported</code> - (<i>Future-dated Capacity Reservations</i>) Amazon EC2 can't support the
         * future-dated Capacity Reservation request due to capacity constraints. You can view unsupported requests for
         * 30 days. The Capacity Reservation will not be delivered.
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following
         *        states:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>active</code> - The capacity is available for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified
         *        in your reservation request. The reserved capacity is no longer available for your use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cancelled</code> - The Capacity Reservation was canceled. The reserved capacity is no longer
         *        available for your use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning
         *        is still pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>failed</code> - The Capacity Reservation request has failed. A request can fail due to request
         *        parameters that are not valid, capacity constraints, or instance limit constraints. You can view a
         *        failed request for 60 minutes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>scheduled</code> - (<i>Future-dated Capacity Reservations</i>) The future-dated Capacity
         *        Reservation request was approved and the Capacity Reservation is scheduled for delivery on the
         *        requested start date.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>payment-pending</code> - (<i>Capacity Blocks</i>) The upfront payment has not been processed
         *        yet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>payment-failed</code> - (<i>Capacity Blocks</i>) The upfront payment was not processed in the
         *        12-hour time frame. Your Capacity Block was released.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>assessing</code> - (<i>Future-dated Capacity Reservations</i>) Amazon EC2 is assessing your
         *        request for a future-dated Capacity Reservation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>delayed</code> - (<i>Future-dated Capacity Reservations</i>) Amazon EC2 encountered a delay in
         *        provisioning the requested future-dated Capacity Reservation. Amazon EC2 is unable to deliver the
         *        requested capacity by the requested start date and time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unsupported</code> - (<i>Future-dated Capacity Reservations</i>) Amazon EC2 can't support the
         *        future-dated Capacity Reservation request due to capacity constraints. You can view unsupported
         *        requests for 30 days. The Capacity Reservation will not be delivered.
         *        </p>
         *        </li>
         * @see CapacityReservationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationState
         */
        Builder state(CapacityReservationState state);

        /**
         * <p>
         * The date and time the Capacity Reservation was started.
         * </p>
         * 
         * @param startDate
         *        The date and time the Capacity Reservation was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <p>
         * The date and time the Capacity Reservation expires. When a Capacity Reservation expires, the reserved
         * capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes
         * to <code>expired</code> when it reaches its end date and time.
         * </p>
         * 
         * @param endDate
         *        The date and time the Capacity Reservation expires. When a Capacity Reservation expires, the reserved
         *        capacity is released and you can no longer launch instances into it. The Capacity Reservation's state
         *        changes to <code>expired</code> when it reaches its end date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(Instant endDate);

        /**
         * <p>
         * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
         * following end types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.
         * </p>
         * </li>
         * </ul>
         * 
         * @param endDateType
         *        Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
         *        following end types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.
         *        </p>
         *        </li>
         * @see EndDateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndDateType
         */
        Builder endDateType(String endDateType);

        /**
         * <p>
         * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
         * following end types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.
         * </p>
         * </li>
         * </ul>
         * 
         * @param endDateType
         *        Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
         *        following end types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.
         *        </p>
         *        </li>
         * @see EndDateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndDateType
         */
        Builder endDateType(EndDateType endDateType);

        /**
         * <p>
         * Indicates the type of instance launches that the Capacity Reservation accepts. The options include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>open</code> - The Capacity Reservation accepts all instances that have matching attributes (instance
         * type, platform, and Availability Zone). Instances that have matching attributes launch into the Capacity
         * Reservation automatically without specifying any additional parameters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes
         * (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This
         * ensures that only permitted instances can use the reserved capacity.
         * </p>
         * </li>
         * </ul>
         * 
         * @param instanceMatchCriteria
         *        Indicates the type of instance launches that the Capacity Reservation accepts. The options
         *        include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>open</code> - The Capacity Reservation accepts all instances that have matching attributes
         *        (instance type, platform, and Availability Zone). Instances that have matching attributes launch into
         *        the Capacity Reservation automatically without specifying any additional parameters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes
         *        (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This
         *        ensures that only permitted instances can use the reserved capacity.
         *        </p>
         *        </li>
         * @see InstanceMatchCriteria
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceMatchCriteria
         */
        Builder instanceMatchCriteria(String instanceMatchCriteria);

        /**
         * <p>
         * Indicates the type of instance launches that the Capacity Reservation accepts. The options include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>open</code> - The Capacity Reservation accepts all instances that have matching attributes (instance
         * type, platform, and Availability Zone). Instances that have matching attributes launch into the Capacity
         * Reservation automatically without specifying any additional parameters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes
         * (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This
         * ensures that only permitted instances can use the reserved capacity.
         * </p>
         * </li>
         * </ul>
         * 
         * @param instanceMatchCriteria
         *        Indicates the type of instance launches that the Capacity Reservation accepts. The options
         *        include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>open</code> - The Capacity Reservation accepts all instances that have matching attributes
         *        (instance type, platform, and Availability Zone). Instances that have matching attributes launch into
         *        the Capacity Reservation automatically without specifying any additional parameters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes
         *        (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This
         *        ensures that only permitted instances can use the reserved capacity.
         *        </p>
         *        </li>
         * @see InstanceMatchCriteria
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceMatchCriteria
         */
        Builder instanceMatchCriteria(InstanceMatchCriteria instanceMatchCriteria);

        /**
         * <p>
         * The date and time the Capacity Reservation was created.
         * </p>
         * 
         * @param createDate
         *        The date and time the Capacity Reservation was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * Any tags assigned to the Capacity Reservation.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the Capacity Reservation.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the Capacity Reservation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Outpost on which the Capacity Reservation was created.
         * </p>
         * 
         * @param outpostArn
         *        The Amazon Resource Name (ARN) of the Outpost on which the Capacity Reservation was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArn(String outpostArn);

        /**
         * <p>
         * The ID of the Capacity Reservation Fleet to which the Capacity Reservation belongs. Only valid for Capacity
         * Reservations that were created by a Capacity Reservation Fleet.
         * </p>
         * 
         * @param capacityReservationFleetId
         *        The ID of the Capacity Reservation Fleet to which the Capacity Reservation belongs. Only valid for
         *        Capacity Reservations that were created by a Capacity Reservation Fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationFleetId(String capacityReservationFleetId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the cluster placement group in which the Capacity Reservation was created.
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-cpg.html"> Capacity
         * Reservations for cluster placement groups</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param placementGroupArn
         *        The Amazon Resource Name (ARN) of the cluster placement group in which the Capacity Reservation was
         *        created. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-cpg.html"> Capacity Reservations for
         *        cluster placement groups</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementGroupArn(String placementGroupArn);

        /**
         * <p>
         * Information about instance capacity usage.
         * </p>
         * 
         * @param capacityAllocations
         *        Information about instance capacity usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityAllocations(Collection<CapacityAllocation> capacityAllocations);

        /**
         * <p>
         * Information about instance capacity usage.
         * </p>
         * 
         * @param capacityAllocations
         *        Information about instance capacity usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityAllocations(CapacityAllocation... capacityAllocations);

        /**
         * <p>
         * Information about instance capacity usage.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.CapacityAllocation.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.CapacityAllocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.CapacityAllocation.Builder#build()} is called immediately
         * and its result is passed to {@link #capacityAllocations(List<CapacityAllocation>)}.
         * 
         * @param capacityAllocations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.CapacityAllocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityAllocations(java.util.Collection<CapacityAllocation>)
         */
        Builder capacityAllocations(Consumer<CapacityAllocation.Builder>... capacityAllocations);

        /**
         * <p>
         * The type of Capacity Reservation.
         * </p>
         * 
         * @param reservationType
         *        The type of Capacity Reservation.
         * @see CapacityReservationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationType
         */
        Builder reservationType(String reservationType);

        /**
         * <p>
         * The type of Capacity Reservation.
         * </p>
         * 
         * @param reservationType
         *        The type of Capacity Reservation.
         * @see CapacityReservationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationType
         */
        Builder reservationType(CapacityReservationType reservationType);

        /**
         * <p>
         * The ID of the Amazon Web Services account to which billing of the unused capacity of the Capacity Reservation
         * is assigned.
         * </p>
         * 
         * @param unusedReservationBillingOwnerId
         *        The ID of the Amazon Web Services account to which billing of the unused capacity of the Capacity
         *        Reservation is assigned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unusedReservationBillingOwnerId(String unusedReservationBillingOwnerId);

        /**
         * <p>
         * Information about your commitment for a future-dated Capacity Reservation.
         * </p>
         * 
         * @param commitmentInfo
         *        Information about your commitment for a future-dated Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitmentInfo(CapacityReservationCommitmentInfo commitmentInfo);

        /**
         * <p>
         * Information about your commitment for a future-dated Capacity Reservation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CapacityReservationCommitmentInfo.Builder} avoiding the need to create one manually via
         * {@link CapacityReservationCommitmentInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityReservationCommitmentInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #commitmentInfo(CapacityReservationCommitmentInfo)}.
         * 
         * @param commitmentInfo
         *        a consumer that will call methods on {@link CapacityReservationCommitmentInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commitmentInfo(CapacityReservationCommitmentInfo)
         */
        default Builder commitmentInfo(Consumer<CapacityReservationCommitmentInfo.Builder> commitmentInfo) {
            return commitmentInfo(CapacityReservationCommitmentInfo.builder().applyMutation(commitmentInfo).build());
        }

        /**
         * <p>
         * The delivery method for a future-dated Capacity Reservation. <code>incremental</code> indicates that the
         * requested capacity is delivered in addition to any running instances and reserved capacity that you have in
         * your account at the requested date and time.
         * </p>
         * 
         * @param deliveryPreference
         *        The delivery method for a future-dated Capacity Reservation. <code>incremental</code> indicates that
         *        the requested capacity is delivered in addition to any running instances and reserved capacity that
         *        you have in your account at the requested date and time.
         * @see CapacityReservationDeliveryPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationDeliveryPreference
         */
        Builder deliveryPreference(String deliveryPreference);

        /**
         * <p>
         * The delivery method for a future-dated Capacity Reservation. <code>incremental</code> indicates that the
         * requested capacity is delivered in addition to any running instances and reserved capacity that you have in
         * your account at the requested date and time.
         * </p>
         * 
         * @param deliveryPreference
         *        The delivery method for a future-dated Capacity Reservation. <code>incremental</code> indicates that
         *        the requested capacity is delivered in addition to any running instances and reserved capacity that
         *        you have in your account at the requested date and time.
         * @see CapacityReservationDeliveryPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationDeliveryPreference
         */
        Builder deliveryPreference(CapacityReservationDeliveryPreference deliveryPreference);

        /**
         * <p>
         * The ID of the Capacity Block.
         * </p>
         * 
         * @param capacityBlockId
         *        The ID of the Capacity Block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityBlockId(String capacityBlockId);
    }

    static final class BuilderImpl implements Builder {
        private String capacityReservationId;

        private String ownerId;

        private String capacityReservationArn;

        private String availabilityZoneId;

        private String instanceType;

        private String instancePlatform;

        private String availabilityZone;

        private String tenancy;

        private Integer totalInstanceCount;

        private Integer availableInstanceCount;

        private Boolean ebsOptimized;

        private Boolean ephemeralStorage;

        private String state;

        private Instant startDate;

        private Instant endDate;

        private String endDateType;

        private String instanceMatchCriteria;

        private Instant createDate;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String outpostArn;

        private String capacityReservationFleetId;

        private String placementGroupArn;

        private List<CapacityAllocation> capacityAllocations = DefaultSdkAutoConstructList.getInstance();

        private String reservationType;

        private String unusedReservationBillingOwnerId;

        private CapacityReservationCommitmentInfo commitmentInfo;

        private String deliveryPreference;

        private String capacityBlockId;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityReservation model) {
            capacityReservationId(model.capacityReservationId);
            ownerId(model.ownerId);
            capacityReservationArn(model.capacityReservationArn);
            availabilityZoneId(model.availabilityZoneId);
            instanceType(model.instanceType);
            instancePlatform(model.instancePlatform);
            availabilityZone(model.availabilityZone);
            tenancy(model.tenancy);
            totalInstanceCount(model.totalInstanceCount);
            availableInstanceCount(model.availableInstanceCount);
            ebsOptimized(model.ebsOptimized);
            ephemeralStorage(model.ephemeralStorage);
            state(model.state);
            startDate(model.startDate);
            endDate(model.endDate);
            endDateType(model.endDateType);
            instanceMatchCriteria(model.instanceMatchCriteria);
            createDate(model.createDate);
            tags(model.tags);
            outpostArn(model.outpostArn);
            capacityReservationFleetId(model.capacityReservationFleetId);
            placementGroupArn(model.placementGroupArn);
            capacityAllocations(model.capacityAllocations);
            reservationType(model.reservationType);
            unusedReservationBillingOwnerId(model.unusedReservationBillingOwnerId);
            commitmentInfo(model.commitmentInfo);
            deliveryPreference(model.deliveryPreference);
            capacityBlockId(model.capacityBlockId);
        }

        public final String getCapacityReservationId() {
            return capacityReservationId;
        }

        public final void setCapacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
        }

        @Override
        public final Builder capacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getCapacityReservationArn() {
            return capacityReservationArn;
        }

        public final void setCapacityReservationArn(String capacityReservationArn) {
            this.capacityReservationArn = capacityReservationArn;
        }

        @Override
        public final Builder capacityReservationArn(String capacityReservationArn) {
            this.capacityReservationArn = capacityReservationArn;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getInstancePlatform() {
            return instancePlatform;
        }

        public final void setInstancePlatform(String instancePlatform) {
            this.instancePlatform = instancePlatform;
        }

        @Override
        public final Builder instancePlatform(String instancePlatform) {
            this.instancePlatform = instancePlatform;
            return this;
        }

        @Override
        public final Builder instancePlatform(CapacityReservationInstancePlatform instancePlatform) {
            this.instancePlatform(instancePlatform == null ? null : instancePlatform.toString());
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getTenancy() {
            return tenancy;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(CapacityReservationTenancy tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        public final Integer getTotalInstanceCount() {
            return totalInstanceCount;
        }

        public final void setTotalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
        }

        @Override
        public final Builder totalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
            return this;
        }

        public final Integer getAvailableInstanceCount() {
            return availableInstanceCount;
        }

        public final void setAvailableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
        }

        @Override
        public final Builder availableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
            return this;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final Boolean getEphemeralStorage() {
            return ephemeralStorage;
        }

        public final void setEphemeralStorage(Boolean ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
        }

        @Override
        public final Builder ephemeralStorage(Boolean ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CapacityReservationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getStartDate() {
            return startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getEndDate() {
            return endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final String getEndDateType() {
            return endDateType;
        }

        public final void setEndDateType(String endDateType) {
            this.endDateType = endDateType;
        }

        @Override
        public final Builder endDateType(String endDateType) {
            this.endDateType = endDateType;
            return this;
        }

        @Override
        public final Builder endDateType(EndDateType endDateType) {
            this.endDateType(endDateType == null ? null : endDateType.toString());
            return this;
        }

        public final String getInstanceMatchCriteria() {
            return instanceMatchCriteria;
        }

        public final void setInstanceMatchCriteria(String instanceMatchCriteria) {
            this.instanceMatchCriteria = instanceMatchCriteria;
        }

        @Override
        public final Builder instanceMatchCriteria(String instanceMatchCriteria) {
            this.instanceMatchCriteria = instanceMatchCriteria;
            return this;
        }

        @Override
        public final Builder instanceMatchCriteria(InstanceMatchCriteria instanceMatchCriteria) {
            this.instanceMatchCriteria(instanceMatchCriteria == null ? null : instanceMatchCriteria.toString());
            return this;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOutpostArn() {
            return outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final String getCapacityReservationFleetId() {
            return capacityReservationFleetId;
        }

        public final void setCapacityReservationFleetId(String capacityReservationFleetId) {
            this.capacityReservationFleetId = capacityReservationFleetId;
        }

        @Override
        public final Builder capacityReservationFleetId(String capacityReservationFleetId) {
            this.capacityReservationFleetId = capacityReservationFleetId;
            return this;
        }

        public final String getPlacementGroupArn() {
            return placementGroupArn;
        }

        public final void setPlacementGroupArn(String placementGroupArn) {
            this.placementGroupArn = placementGroupArn;
        }

        @Override
        public final Builder placementGroupArn(String placementGroupArn) {
            this.placementGroupArn = placementGroupArn;
            return this;
        }

        public final List<CapacityAllocation.Builder> getCapacityAllocations() {
            List<CapacityAllocation.Builder> result = CapacityAllocationsCopier.copyToBuilder(this.capacityAllocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityAllocations(Collection<CapacityAllocation.BuilderImpl> capacityAllocations) {
            this.capacityAllocations = CapacityAllocationsCopier.copyFromBuilder(capacityAllocations);
        }

        @Override
        public final Builder capacityAllocations(Collection<CapacityAllocation> capacityAllocations) {
            this.capacityAllocations = CapacityAllocationsCopier.copy(capacityAllocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityAllocations(CapacityAllocation... capacityAllocations) {
            capacityAllocations(Arrays.asList(capacityAllocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityAllocations(Consumer<CapacityAllocation.Builder>... capacityAllocations) {
            capacityAllocations(Stream.of(capacityAllocations).map(c -> CapacityAllocation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getReservationType() {
            return reservationType;
        }

        public final void setReservationType(String reservationType) {
            this.reservationType = reservationType;
        }

        @Override
        public final Builder reservationType(String reservationType) {
            this.reservationType = reservationType;
            return this;
        }

        @Override
        public final Builder reservationType(CapacityReservationType reservationType) {
            this.reservationType(reservationType == null ? null : reservationType.toString());
            return this;
        }

        public final String getUnusedReservationBillingOwnerId() {
            return unusedReservationBillingOwnerId;
        }

        public final void setUnusedReservationBillingOwnerId(String unusedReservationBillingOwnerId) {
            this.unusedReservationBillingOwnerId = unusedReservationBillingOwnerId;
        }

        @Override
        public final Builder unusedReservationBillingOwnerId(String unusedReservationBillingOwnerId) {
            this.unusedReservationBillingOwnerId = unusedReservationBillingOwnerId;
            return this;
        }

        public final CapacityReservationCommitmentInfo.Builder getCommitmentInfo() {
            return commitmentInfo != null ? commitmentInfo.toBuilder() : null;
        }

        public final void setCommitmentInfo(CapacityReservationCommitmentInfo.BuilderImpl commitmentInfo) {
            this.commitmentInfo = commitmentInfo != null ? commitmentInfo.build() : null;
        }

        @Override
        public final Builder commitmentInfo(CapacityReservationCommitmentInfo commitmentInfo) {
            this.commitmentInfo = commitmentInfo;
            return this;
        }

        public final String getDeliveryPreference() {
            return deliveryPreference;
        }

        public final void setDeliveryPreference(String deliveryPreference) {
            this.deliveryPreference = deliveryPreference;
        }

        @Override
        public final Builder deliveryPreference(String deliveryPreference) {
            this.deliveryPreference = deliveryPreference;
            return this;
        }

        @Override
        public final Builder deliveryPreference(CapacityReservationDeliveryPreference deliveryPreference) {
            this.deliveryPreference(deliveryPreference == null ? null : deliveryPreference.toString());
            return this;
        }

        public final String getCapacityBlockId() {
            return capacityBlockId;
        }

        public final void setCapacityBlockId(String capacityBlockId) {
            this.capacityBlockId = capacityBlockId;
        }

        @Override
        public final Builder capacityBlockId(String capacityBlockId) {
            this.capacityBlockId = capacityBlockId;
            return this;
        }

        @Override
        public CapacityReservation build() {
            return new CapacityReservation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
