/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableCapacityManagerResponse extends Ec2Response implements
        ToCopyableBuilder<EnableCapacityManagerResponse.Builder, EnableCapacityManagerResponse> {
    private static final SdkField<String> CAPACITY_MANAGER_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityManagerStatus")
            .getter(getter(EnableCapacityManagerResponse::capacityManagerStatusAsString))
            .setter(setter(Builder::capacityManagerStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityManagerStatus")
                    .unmarshallLocationName("capacityManagerStatus").build()).build();

    private static final SdkField<Boolean> ORGANIZATIONS_ACCESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("OrganizationsAccess")
            .getter(getter(EnableCapacityManagerResponse::organizationsAccess))
            .setter(setter(Builder::organizationsAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationsAccess")
                    .unmarshallLocationName("organizationsAccess").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_MANAGER_STATUS_FIELD,
            ORGANIZATIONS_ACCESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String capacityManagerStatus;

    private final Boolean organizationsAccess;

    private EnableCapacityManagerResponse(BuilderImpl builder) {
        super(builder);
        this.capacityManagerStatus = builder.capacityManagerStatus;
        this.organizationsAccess = builder.organizationsAccess;
    }

    /**
     * <p>
     * The current status of Capacity Manager after the enable operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capacityManagerStatus} will return {@link CapacityManagerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #capacityManagerStatusAsString}.
     * </p>
     * 
     * @return The current status of Capacity Manager after the enable operation.
     * @see CapacityManagerStatus
     */
    public final CapacityManagerStatus capacityManagerStatus() {
        return CapacityManagerStatus.fromValue(capacityManagerStatus);
    }

    /**
     * <p>
     * The current status of Capacity Manager after the enable operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capacityManagerStatus} will return {@link CapacityManagerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #capacityManagerStatusAsString}.
     * </p>
     * 
     * @return The current status of Capacity Manager after the enable operation.
     * @see CapacityManagerStatus
     */
    public final String capacityManagerStatusAsString() {
        return capacityManagerStatus;
    }

    /**
     * <p>
     * Indicates whether Organizations access is enabled for cross-account data aggregation.
     * </p>
     * 
     * @return Indicates whether Organizations access is enabled for cross-account data aggregation.
     */
    public final Boolean organizationsAccess() {
        return organizationsAccess;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(capacityManagerStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(organizationsAccess());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableCapacityManagerResponse)) {
            return false;
        }
        EnableCapacityManagerResponse other = (EnableCapacityManagerResponse) obj;
        return Objects.equals(capacityManagerStatusAsString(), other.capacityManagerStatusAsString())
                && Objects.equals(organizationsAccess(), other.organizationsAccess());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableCapacityManagerResponse").add("CapacityManagerStatus", capacityManagerStatusAsString())
                .add("OrganizationsAccess", organizationsAccess()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityManagerStatus":
            return Optional.ofNullable(clazz.cast(capacityManagerStatusAsString()));
        case "OrganizationsAccess":
            return Optional.ofNullable(clazz.cast(organizationsAccess()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CapacityManagerStatus", CAPACITY_MANAGER_STATUS_FIELD);
        map.put("OrganizationsAccess", ORGANIZATIONS_ACCESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableCapacityManagerResponse, T> g) {
        return obj -> g.apply((EnableCapacityManagerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, EnableCapacityManagerResponse> {
        /**
         * <p>
         * The current status of Capacity Manager after the enable operation.
         * </p>
         * 
         * @param capacityManagerStatus
         *        The current status of Capacity Manager after the enable operation.
         * @see CapacityManagerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityManagerStatus
         */
        Builder capacityManagerStatus(String capacityManagerStatus);

        /**
         * <p>
         * The current status of Capacity Manager after the enable operation.
         * </p>
         * 
         * @param capacityManagerStatus
         *        The current status of Capacity Manager after the enable operation.
         * @see CapacityManagerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityManagerStatus
         */
        Builder capacityManagerStatus(CapacityManagerStatus capacityManagerStatus);

        /**
         * <p>
         * Indicates whether Organizations access is enabled for cross-account data aggregation.
         * </p>
         * 
         * @param organizationsAccess
         *        Indicates whether Organizations access is enabled for cross-account data aggregation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationsAccess(Boolean organizationsAccess);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String capacityManagerStatus;

        private Boolean organizationsAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableCapacityManagerResponse model) {
            super(model);
            capacityManagerStatus(model.capacityManagerStatus);
            organizationsAccess(model.organizationsAccess);
        }

        public final String getCapacityManagerStatus() {
            return capacityManagerStatus;
        }

        public final void setCapacityManagerStatus(String capacityManagerStatus) {
            this.capacityManagerStatus = capacityManagerStatus;
        }

        @Override
        public final Builder capacityManagerStatus(String capacityManagerStatus) {
            this.capacityManagerStatus = capacityManagerStatus;
            return this;
        }

        @Override
        public final Builder capacityManagerStatus(CapacityManagerStatus capacityManagerStatus) {
            this.capacityManagerStatus(capacityManagerStatus == null ? null : capacityManagerStatus.toString());
            return this;
        }

        public final Boolean getOrganizationsAccess() {
            return organizationsAccess;
        }

        public final void setOrganizationsAccess(Boolean organizationsAccess) {
            this.organizationsAccess = organizationsAccess;
        }

        @Override
        public final Builder organizationsAccess(Boolean organizationsAccess) {
            this.organizationsAccess = organizationsAccess;
            return this;
        }

        @Override
        public EnableCapacityManagerResponse build() {
            return new EnableCapacityManagerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
