/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.SnapshotReturnCodes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteSnapshotReturnCode
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeleteSnapshotReturnCode> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(DeleteSnapshotReturnCode.getter(DeleteSnapshotReturnCode::snapshotId)).setter(DeleteSnapshotReturnCode.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").unmarshallLocationName("snapshotId").build()}).build();
    private static final SdkField<String> RETURN_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReturnCode").getter(DeleteSnapshotReturnCode.getter(DeleteSnapshotReturnCode::returnCodeAsString)).setter(DeleteSnapshotReturnCode.setter(Builder::returnCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnCode").unmarshallLocationName("returnCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD, RETURN_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteSnapshotReturnCode.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String snapshotId;
    private final String returnCode;

    private DeleteSnapshotReturnCode(BuilderImpl builder) {
        this.snapshotId = builder.snapshotId;
        this.returnCode = builder.returnCode;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final SnapshotReturnCodes returnCode() {
        return SnapshotReturnCodes.fromValue(this.returnCode);
    }

    public final String returnCodeAsString() {
        return this.returnCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnCodeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSnapshotReturnCode)) {
            return false;
        }
        DeleteSnapshotReturnCode other = (DeleteSnapshotReturnCode)obj;
        return Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.returnCodeAsString(), other.returnCodeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteSnapshotReturnCode").add("SnapshotId", (Object)this.snapshotId()).add("ReturnCode", (Object)this.returnCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "ReturnCode": {
                return Optional.ofNullable(clazz.cast(this.returnCodeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("ReturnCode", RETURN_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteSnapshotReturnCode, T> g) {
        return obj -> g.apply((DeleteSnapshotReturnCode)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String snapshotId;
        private String returnCode;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSnapshotReturnCode model) {
            this.snapshotId(model.snapshotId);
            this.returnCode(model.returnCode);
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getReturnCode() {
            return this.returnCode;
        }

        public final void setReturnCode(String returnCode) {
            this.returnCode = returnCode;
        }

        @Override
        public final Builder returnCode(String returnCode) {
            this.returnCode = returnCode;
            return this;
        }

        @Override
        public final Builder returnCode(SnapshotReturnCodes returnCode) {
            this.returnCode(returnCode == null ? null : returnCode.toString());
            return this;
        }

        public DeleteSnapshotReturnCode build() {
            return new DeleteSnapshotReturnCode(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeleteSnapshotReturnCode> {
        public Builder snapshotId(String var1);

        public Builder returnCode(String var1);

        public Builder returnCode(SnapshotReturnCodes var1);
    }
}

