/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an IPv6 CIDR block association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ipv6CidrAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<Ipv6CidrAssociation.Builder, Ipv6CidrAssociation> {
    private static final SdkField<String> IPV6_CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Ipv6Cidr")
            .getter(getter(Ipv6CidrAssociation::ipv6Cidr))
            .setter(setter(Builder::ipv6Cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Cidr")
                    .unmarshallLocationName("ipv6Cidr").build()).build();

    private static final SdkField<String> ASSOCIATED_RESOURCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AssociatedResource")
            .getter(getter(Ipv6CidrAssociation::associatedResource))
            .setter(setter(Builder::associatedResource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResource")
                    .unmarshallLocationName("associatedResource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV6_CIDR_FIELD,
            ASSOCIATED_RESOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ipv6Cidr;

    private final String associatedResource;

    private Ipv6CidrAssociation(BuilderImpl builder) {
        this.ipv6Cidr = builder.ipv6Cidr;
        this.associatedResource = builder.associatedResource;
    }

    /**
     * <p>
     * The IPv6 CIDR block.
     * </p>
     * 
     * @return The IPv6 CIDR block.
     */
    public final String ipv6Cidr() {
        return ipv6Cidr;
    }

    /**
     * <p>
     * The resource that's associated with the IPv6 CIDR block.
     * </p>
     * 
     * @return The resource that's associated with the IPv6 CIDR block.
     */
    public final String associatedResource() {
        return associatedResource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipv6Cidr());
        hashCode = 31 * hashCode + Objects.hashCode(associatedResource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ipv6CidrAssociation)) {
            return false;
        }
        Ipv6CidrAssociation other = (Ipv6CidrAssociation) obj;
        return Objects.equals(ipv6Cidr(), other.ipv6Cidr()) && Objects.equals(associatedResource(), other.associatedResource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Ipv6CidrAssociation").add("Ipv6Cidr", ipv6Cidr())
                .add("AssociatedResource", associatedResource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ipv6Cidr":
            return Optional.ofNullable(clazz.cast(ipv6Cidr()));
        case "AssociatedResource":
            return Optional.ofNullable(clazz.cast(associatedResource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Ipv6Cidr", IPV6_CIDR_FIELD);
        map.put("AssociatedResource", ASSOCIATED_RESOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Ipv6CidrAssociation, T> g) {
        return obj -> g.apply((Ipv6CidrAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ipv6CidrAssociation> {
        /**
         * <p>
         * The IPv6 CIDR block.
         * </p>
         * 
         * @param ipv6Cidr
         *        The IPv6 CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Cidr(String ipv6Cidr);

        /**
         * <p>
         * The resource that's associated with the IPv6 CIDR block.
         * </p>
         * 
         * @param associatedResource
         *        The resource that's associated with the IPv6 CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResource(String associatedResource);
    }

    static final class BuilderImpl implements Builder {
        private String ipv6Cidr;

        private String associatedResource;

        private BuilderImpl() {
        }

        private BuilderImpl(Ipv6CidrAssociation model) {
            ipv6Cidr(model.ipv6Cidr);
            associatedResource(model.associatedResource);
        }

        public final String getIpv6Cidr() {
            return ipv6Cidr;
        }

        public final void setIpv6Cidr(String ipv6Cidr) {
            this.ipv6Cidr = ipv6Cidr;
        }

        @Override
        public final Builder ipv6Cidr(String ipv6Cidr) {
            this.ipv6Cidr = ipv6Cidr;
            return this;
        }

        public final String getAssociatedResource() {
            return associatedResource;
        }

        public final void setAssociatedResource(String associatedResource) {
            this.associatedResource = associatedResource;
        }

        @Override
        public final Builder associatedResource(String associatedResource) {
            this.associatedResource = associatedResource;
            return this;
        }

        @Override
        public Ipv6CidrAssociation build() {
            return new Ipv6CidrAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
