/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.GetSecurityGroupsForVpcRequest;
import software.amazon.awssdk.services.ec2.model.GetSecurityGroupsForVpcResponse;
import software.amazon.awssdk.services.ec2.model.SecurityGroupForVpc;

public class GetSecurityGroupsForVpcIterable
implements SdkIterable<GetSecurityGroupsForVpcResponse> {
    private final Ec2Client client;
    private final GetSecurityGroupsForVpcRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetSecurityGroupsForVpcIterable(Ec2Client client, GetSecurityGroupsForVpcRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetSecurityGroupsForVpcResponseFetcher();
    }

    public Iterator<GetSecurityGroupsForVpcResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SecurityGroupForVpc> securityGroupForVpcs() {
        Function<GetSecurityGroupsForVpcResponse, Iterator> getIterator = response -> {
            if (response != null && response.securityGroupForVpcs() != null) {
                return response.securityGroupForVpcs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetSecurityGroupsForVpcResponseFetcher
    implements SyncPageFetcher<GetSecurityGroupsForVpcResponse> {
        private GetSecurityGroupsForVpcResponseFetcher() {
        }

        public boolean hasNextPage(GetSecurityGroupsForVpcResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetSecurityGroupsForVpcResponse nextPage(GetSecurityGroupsForVpcResponse previousPage) {
            if (previousPage == null) {
                return GetSecurityGroupsForVpcIterable.this.client.getSecurityGroupsForVpc(GetSecurityGroupsForVpcIterable.this.firstRequest);
            }
            return GetSecurityGroupsForVpcIterable.this.client.getSecurityGroupsForVpc((GetSecurityGroupsForVpcRequest)((Object)GetSecurityGroupsForVpcIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

