/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.GetSpotPlacementScoresRequest;
import software.amazon.awssdk.services.ec2.model.GetSpotPlacementScoresResponse;
import software.amazon.awssdk.services.ec2.model.SpotPlacementScore;

public class GetSpotPlacementScoresIterable
implements SdkIterable<GetSpotPlacementScoresResponse> {
    private final Ec2Client client;
    private final GetSpotPlacementScoresRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetSpotPlacementScoresIterable(Ec2Client client, GetSpotPlacementScoresRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetSpotPlacementScoresResponseFetcher();
    }

    public Iterator<GetSpotPlacementScoresResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SpotPlacementScore> spotPlacementScores() {
        Function<GetSpotPlacementScoresResponse, Iterator> getIterator = response -> {
            if (response != null && response.spotPlacementScores() != null) {
                return response.spotPlacementScores().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetSpotPlacementScoresResponseFetcher
    implements SyncPageFetcher<GetSpotPlacementScoresResponse> {
        private GetSpotPlacementScoresResponseFetcher() {
        }

        public boolean hasNextPage(GetSpotPlacementScoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetSpotPlacementScoresResponse nextPage(GetSpotPlacementScoresResponse previousPage) {
            if (previousPage == null) {
                return GetSpotPlacementScoresIterable.this.client.getSpotPlacementScores(GetSpotPlacementScoresIterable.this.firstRequest);
            }
            return GetSpotPlacementScoresIterable.this.client.getSpotPlacementScores((GetSpotPlacementScoresRequest)((Object)GetSpotPlacementScoresIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

