/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.RouteServerEndpoint;
import software.amazon.awssdk.services.ec2.model.RouteServerEndpointsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRouteServerEndpointsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeRouteServerEndpointsResponse> {
    private static final SdkField<List<RouteServerEndpoint>> ROUTE_SERVER_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RouteServerEndpoints").getter(DescribeRouteServerEndpointsResponse.getter(DescribeRouteServerEndpointsResponse::routeServerEndpoints)).setter(DescribeRouteServerEndpointsResponse.setter(Builder::routeServerEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteServerEndpointSet").unmarshallLocationName("routeServerEndpointSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteServerEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeRouteServerEndpointsResponse.getter(DescribeRouteServerEndpointsResponse::nextToken)).setter(DescribeRouteServerEndpointsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_SERVER_ENDPOINTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeRouteServerEndpointsResponse.memberNameToFieldInitializer();
    private final List<RouteServerEndpoint> routeServerEndpoints;
    private final String nextToken;

    private DescribeRouteServerEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.routeServerEndpoints = builder.routeServerEndpoints;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRouteServerEndpoints() {
        return this.routeServerEndpoints != null && !(this.routeServerEndpoints instanceof SdkAutoConstructList);
    }

    public final List<RouteServerEndpoint> routeServerEndpoints() {
        return this.routeServerEndpoints;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRouteServerEndpoints() ? this.routeServerEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRouteServerEndpointsResponse)) {
            return false;
        }
        DescribeRouteServerEndpointsResponse other = (DescribeRouteServerEndpointsResponse)((Object)obj);
        return this.hasRouteServerEndpoints() == other.hasRouteServerEndpoints() && Objects.equals(this.routeServerEndpoints(), other.routeServerEndpoints()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRouteServerEndpointsResponse").add("RouteServerEndpoints", this.hasRouteServerEndpoints() ? this.routeServerEndpoints() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RouteServerEndpoints": {
                return Optional.ofNullable(clazz.cast(this.routeServerEndpoints()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RouteServerEndpointSet", ROUTE_SERVER_ENDPOINTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRouteServerEndpointsResponse, T> g) {
        return obj -> g.apply((DescribeRouteServerEndpointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<RouteServerEndpoint> routeServerEndpoints = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRouteServerEndpointsResponse model) {
            super(model);
            this.routeServerEndpoints(model.routeServerEndpoints);
            this.nextToken(model.nextToken);
        }

        public final List<RouteServerEndpoint.Builder> getRouteServerEndpoints() {
            List<RouteServerEndpoint.Builder> result = RouteServerEndpointsListCopier.copyToBuilder(this.routeServerEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouteServerEndpoints(Collection<RouteServerEndpoint.BuilderImpl> routeServerEndpoints) {
            this.routeServerEndpoints = RouteServerEndpointsListCopier.copyFromBuilder(routeServerEndpoints);
        }

        @Override
        public final Builder routeServerEndpoints(Collection<RouteServerEndpoint> routeServerEndpoints) {
            this.routeServerEndpoints = RouteServerEndpointsListCopier.copy(routeServerEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeServerEndpoints(RouteServerEndpoint ... routeServerEndpoints) {
            this.routeServerEndpoints(Arrays.asList(routeServerEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeServerEndpoints(Consumer<RouteServerEndpoint.Builder> ... routeServerEndpoints) {
            this.routeServerEndpoints(Stream.of(routeServerEndpoints).map(c -> (RouteServerEndpoint)((RouteServerEndpoint.Builder)RouteServerEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeRouteServerEndpointsResponse build() {
            return new DescribeRouteServerEndpointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRouteServerEndpointsResponse> {
        public Builder routeServerEndpoints(Collection<RouteServerEndpoint> var1);

        public Builder routeServerEndpoints(RouteServerEndpoint ... var1);

        public Builder routeServerEndpoints(Consumer<RouteServerEndpoint.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

