/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <fullname>Amazon Elastic Compute Cloud</fullname>
 * <p>
 * You can access the features of Amazon Elastic Compute Cloud (Amazon EC2) programmatically. For more information, see
 * the <a href="https://docs.aws.amazon.com/ec2/latest/devguide">Amazon EC2 Developer Guide</a>.
 * </p>
 *
 * <h2>Code Examples</h2>
 * <p>
 * For code examples demonstrating how to use this service with the AWS SDK for Java v2, see:
 * </p>
 * <h3>Getting Started</h3>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/ec2_example_ec2_Hello_section.html"
 * target="_top">Hello Amazon EC2</a></li>
 * </ul>
 * <h3>Basics</h3>
 * <ul>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/ec2_example_ec2_Scenario_GetStartedInstances_section.html"
 * target="_top">Learn the basics of Amazon EC2 with an AWS SDK</a></li>
 * </ul>
 * <h3>API Actions</h3>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/ec2_example_ec2_GetPasswordData_section.html"
 * target="_top">Use GetPasswordData</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/ec2_example_ec2_CreateKeyPair_section.html"
 * target="_top">Use CreateKeyPair</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/ec2_example_ec2_DescribeKeyPairs_section.html"
 * target="_top">Use DescribeKeyPairs</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/ec2_example_ec2_CreateSecurityGroup_section.html"
 * target="_top">Use CreateSecurityGroup</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/ec2_example_ec2_RunInstances_section.html"
 * target="_top">Use RunInstances</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/ec2_example_ec2_StartInstances_section.html"
 * target="_top">Use StartInstances</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/ec2_example_ec2_StopInstances_section.html"
 * target="_top">Use StopInstances</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/ec2_example_ec2_AllocateAddress_section.html"
 * target="_top">Use AllocateAddress</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/ec2_example_ec2_AssociateAddress_section.html"
 * target="_top">Use AssociateAddress</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/ec2_example_ec2_DisassociateAddress_section.html"
 * target="_top">Use DisassociateAddress</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/ec2_example_ec2_ReleaseAddress_section.html"
 * target="_top">Use ReleaseAddress</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/ec2_example_ec2_AuthorizeSecurityGroupIngress_section.html"
 * target="_top">Use AuthorizeSecurityGroupIngress</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/ec2_example_ec2_DeleteKeyPair_section.html"
 * target="_top">Use DeleteKeyPair</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/ec2_example_ec2_DescribeSecurityGroups_section.html"
 * target="_top">Use DescribeSecurityGroups</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/ec2_example_ec2_DeleteSecurityGroup_section.html"
 * target="_top">Use DeleteSecurityGroup</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/ec2_example_ec2_TerminateInstances_section.html"
 * target="_top">Use TerminateInstances</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/ec2_example_ec2_DescribeInstances_section.html"
 * target="_top">Use DescribeInstances</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/ec2_example_ec2_DescribeInstanceTypes_section.html"
 * target="_top">Use DescribeInstanceTypes</a></li>
 * </ul>
 * <h3>Scenarios</h3>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/ec2_example_cross_ResilientService_section.html"
 * target="_top">Build and manage a resilient service using an AWS SDK</a></li>
 * </ul>
 */
package software.amazon.awssdk.services.ec2;