/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.NatGatewayApplianceModifyState;
import software.amazon.awssdk.services.ec2.model.NatGatewayApplianceState;
import software.amazon.awssdk.services.ec2.model.NatGatewayApplianceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NatGatewayAttachedAppliance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NatGatewayAttachedAppliance> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(NatGatewayAttachedAppliance.getter(NatGatewayAttachedAppliance::typeAsString)).setter(NatGatewayAttachedAppliance.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").unmarshallLocationName("type").build()}).build();
    private static final SdkField<String> APPLIANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplianceArn").getter(NatGatewayAttachedAppliance.getter(NatGatewayAttachedAppliance::applianceArn)).setter(NatGatewayAttachedAppliance.setter(Builder::applianceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplianceArn").unmarshallLocationName("applianceArn").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcEndpointId").getter(NatGatewayAttachedAppliance.getter(NatGatewayAttachedAppliance::vpcEndpointId)).setter(NatGatewayAttachedAppliance.setter(Builder::vpcEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").unmarshallLocationName("vpcEndpointId").build()}).build();
    private static final SdkField<String> ATTACHMENT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttachmentState").getter(NatGatewayAttachedAppliance.getter(NatGatewayAttachedAppliance::attachmentStateAsString)).setter(NatGatewayAttachedAppliance.setter(Builder::attachmentState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentState").unmarshallLocationName("attachmentState").build()}).build();
    private static final SdkField<String> MODIFICATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModificationState").getter(NatGatewayAttachedAppliance.getter(NatGatewayAttachedAppliance::modificationStateAsString)).setter(NatGatewayAttachedAppliance.setter(Builder::modificationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationState").unmarshallLocationName("modificationState").build()}).build();
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureCode").getter(NatGatewayAttachedAppliance.getter(NatGatewayAttachedAppliance::failureCode)).setter(NatGatewayAttachedAppliance.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCode").unmarshallLocationName("failureCode").build()}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureMessage").getter(NatGatewayAttachedAppliance.getter(NatGatewayAttachedAppliance::failureMessage)).setter(NatGatewayAttachedAppliance.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").unmarshallLocationName("failureMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, APPLIANCE_ARN_FIELD, VPC_ENDPOINT_ID_FIELD, ATTACHMENT_STATE_FIELD, MODIFICATION_STATE_FIELD, FAILURE_CODE_FIELD, FAILURE_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NatGatewayAttachedAppliance.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String applianceArn;
    private final String vpcEndpointId;
    private final String attachmentState;
    private final String modificationState;
    private final String failureCode;
    private final String failureMessage;

    private NatGatewayAttachedAppliance(BuilderImpl builder) {
        this.type = builder.type;
        this.applianceArn = builder.applianceArn;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.attachmentState = builder.attachmentState;
        this.modificationState = builder.modificationState;
        this.failureCode = builder.failureCode;
        this.failureMessage = builder.failureMessage;
    }

    public final NatGatewayApplianceType type() {
        return NatGatewayApplianceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String applianceArn() {
        return this.applianceArn;
    }

    public final String vpcEndpointId() {
        return this.vpcEndpointId;
    }

    public final NatGatewayApplianceState attachmentState() {
        return NatGatewayApplianceState.fromValue(this.attachmentState);
    }

    public final String attachmentStateAsString() {
        return this.attachmentState;
    }

    public final NatGatewayApplianceModifyState modificationState() {
        return NatGatewayApplianceModifyState.fromValue(this.modificationState);
    }

    public final String modificationStateAsString() {
        return this.modificationState;
    }

    public final String failureCode() {
        return this.failureCode;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.applianceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modificationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NatGatewayAttachedAppliance)) {
            return false;
        }
        NatGatewayAttachedAppliance other = (NatGatewayAttachedAppliance)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.applianceArn(), other.applianceArn()) && Objects.equals(this.vpcEndpointId(), other.vpcEndpointId()) && Objects.equals(this.attachmentStateAsString(), other.attachmentStateAsString()) && Objects.equals(this.modificationStateAsString(), other.modificationStateAsString()) && Objects.equals(this.failureCode(), other.failureCode()) && Objects.equals(this.failureMessage(), other.failureMessage());
    }

    public final String toString() {
        return ToString.builder((String)"NatGatewayAttachedAppliance").add("Type", (Object)this.typeAsString()).add("ApplianceArn", (Object)this.applianceArn()).add("VpcEndpointId", (Object)this.vpcEndpointId()).add("AttachmentState", (Object)this.attachmentStateAsString()).add("ModificationState", (Object)this.modificationStateAsString()).add("FailureCode", (Object)this.failureCode()).add("FailureMessage", (Object)this.failureMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ApplianceArn": {
                return Optional.ofNullable(clazz.cast(this.applianceArn()));
            }
            case "VpcEndpointId": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointId()));
            }
            case "AttachmentState": {
                return Optional.ofNullable(clazz.cast(this.attachmentStateAsString()));
            }
            case "ModificationState": {
                return Optional.ofNullable(clazz.cast(this.modificationStateAsString()));
            }
            case "FailureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCode()));
            }
            case "FailureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Type", TYPE_FIELD);
        map.put("ApplianceArn", APPLIANCE_ARN_FIELD);
        map.put("VpcEndpointId", VPC_ENDPOINT_ID_FIELD);
        map.put("AttachmentState", ATTACHMENT_STATE_FIELD);
        map.put("ModificationState", MODIFICATION_STATE_FIELD);
        map.put("FailureCode", FAILURE_CODE_FIELD);
        map.put("FailureMessage", FAILURE_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NatGatewayAttachedAppliance, T> g) {
        return obj -> g.apply((NatGatewayAttachedAppliance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String applianceArn;
        private String vpcEndpointId;
        private String attachmentState;
        private String modificationState;
        private String failureCode;
        private String failureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(NatGatewayAttachedAppliance model) {
            this.type(model.type);
            this.applianceArn(model.applianceArn);
            this.vpcEndpointId(model.vpcEndpointId);
            this.attachmentState(model.attachmentState);
            this.modificationState(model.modificationState);
            this.failureCode(model.failureCode);
            this.failureMessage(model.failureMessage);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NatGatewayApplianceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getApplianceArn() {
            return this.applianceArn;
        }

        public final void setApplianceArn(String applianceArn) {
            this.applianceArn = applianceArn;
        }

        @Override
        public final Builder applianceArn(String applianceArn) {
            this.applianceArn = applianceArn;
            return this;
        }

        public final String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final String getAttachmentState() {
            return this.attachmentState;
        }

        public final void setAttachmentState(String attachmentState) {
            this.attachmentState = attachmentState;
        }

        @Override
        public final Builder attachmentState(String attachmentState) {
            this.attachmentState = attachmentState;
            return this;
        }

        @Override
        public final Builder attachmentState(NatGatewayApplianceState attachmentState) {
            this.attachmentState(attachmentState == null ? null : attachmentState.toString());
            return this;
        }

        public final String getModificationState() {
            return this.modificationState;
        }

        public final void setModificationState(String modificationState) {
            this.modificationState = modificationState;
        }

        @Override
        public final Builder modificationState(String modificationState) {
            this.modificationState = modificationState;
            return this;
        }

        @Override
        public final Builder modificationState(NatGatewayApplianceModifyState modificationState) {
            this.modificationState(modificationState == null ? null : modificationState.toString());
            return this;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public NatGatewayAttachedAppliance build() {
            return new NatGatewayAttachedAppliance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NatGatewayAttachedAppliance> {
        public Builder type(String var1);

        public Builder type(NatGatewayApplianceType var1);

        public Builder applianceArn(String var1);

        public Builder vpcEndpointId(String var1);

        public Builder attachmentState(String var1);

        public Builder attachmentState(NatGatewayApplianceState var1);

        public Builder modificationState(String var1);

        public Builder modificationState(NatGatewayApplianceModifyState var1);

        public Builder failureCode(String var1);

        public Builder failureMessage(String var1);
    }
}

