/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.HaStatus;
import software.amazon.awssdk.services.ec2.model.SqlServerLicenseUsage;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisteredInstance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RegisteredInstance> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(RegisteredInstance.getter(RegisteredInstance::instanceId)).setter(RegisteredInstance.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<String> SQL_SERVER_LICENSE_USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SqlServerLicenseUsage").getter(RegisteredInstance.getter(RegisteredInstance::sqlServerLicenseUsageAsString)).setter(RegisteredInstance.setter(Builder::sqlServerLicenseUsage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlServerLicenseUsage").unmarshallLocationName("sqlServerLicenseUsage").build()}).build();
    private static final SdkField<String> HA_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HaStatus").getter(RegisteredInstance.getter(RegisteredInstance::haStatusAsString)).setter(RegisteredInstance.setter(Builder::haStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HaStatus").unmarshallLocationName("haStatus").build()}).build();
    private static final SdkField<String> PROCESSING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProcessingStatus").getter(RegisteredInstance.getter(RegisteredInstance::processingStatus)).setter(RegisteredInstance.setter(Builder::processingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingStatus").unmarshallLocationName("processingStatus").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(RegisteredInstance.getter(RegisteredInstance::lastUpdatedTime)).setter(RegisteredInstance.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").unmarshallLocationName("lastUpdatedTime").build()}).build();
    private static final SdkField<String> SQL_SERVER_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SqlServerCredentials").getter(RegisteredInstance.getter(RegisteredInstance::sqlServerCredentials)).setter(RegisteredInstance.setter(Builder::sqlServerCredentials)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlServerCredentials").unmarshallLocationName("sqlServerCredentials").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(RegisteredInstance.getter(RegisteredInstance::tags)).setter(RegisteredInstance.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, SQL_SERVER_LICENSE_USAGE_FIELD, HA_STATUS_FIELD, PROCESSING_STATUS_FIELD, LAST_UPDATED_TIME_FIELD, SQL_SERVER_CREDENTIALS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RegisteredInstance.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String instanceId;
    private final String sqlServerLicenseUsage;
    private final String haStatus;
    private final String processingStatus;
    private final Instant lastUpdatedTime;
    private final String sqlServerCredentials;
    private final List<Tag> tags;

    private RegisteredInstance(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.sqlServerLicenseUsage = builder.sqlServerLicenseUsage;
        this.haStatus = builder.haStatus;
        this.processingStatus = builder.processingStatus;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.sqlServerCredentials = builder.sqlServerCredentials;
        this.tags = builder.tags;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final SqlServerLicenseUsage sqlServerLicenseUsage() {
        return SqlServerLicenseUsage.fromValue(this.sqlServerLicenseUsage);
    }

    public final String sqlServerLicenseUsageAsString() {
        return this.sqlServerLicenseUsage;
    }

    public final HaStatus haStatus() {
        return HaStatus.fromValue(this.haStatus);
    }

    public final String haStatusAsString() {
        return this.haStatus;
    }

    public final String processingStatus() {
        return this.processingStatus;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String sqlServerCredentials() {
        return this.sqlServerCredentials;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqlServerLicenseUsageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.haStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqlServerCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisteredInstance)) {
            return false;
        }
        RegisteredInstance other = (RegisteredInstance)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.sqlServerLicenseUsageAsString(), other.sqlServerLicenseUsageAsString()) && Objects.equals(this.haStatusAsString(), other.haStatusAsString()) && Objects.equals(this.processingStatus(), other.processingStatus()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.sqlServerCredentials(), other.sqlServerCredentials()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"RegisteredInstance").add("InstanceId", (Object)this.instanceId()).add("SqlServerLicenseUsage", (Object)this.sqlServerLicenseUsageAsString()).add("HaStatus", (Object)this.haStatusAsString()).add("ProcessingStatus", (Object)this.processingStatus()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("SqlServerCredentials", (Object)this.sqlServerCredentials()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "SqlServerLicenseUsage": {
                return Optional.ofNullable(clazz.cast(this.sqlServerLicenseUsageAsString()));
            }
            case "HaStatus": {
                return Optional.ofNullable(clazz.cast(this.haStatusAsString()));
            }
            case "ProcessingStatus": {
                return Optional.ofNullable(clazz.cast(this.processingStatus()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "SqlServerCredentials": {
                return Optional.ofNullable(clazz.cast(this.sqlServerCredentials()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("SqlServerLicenseUsage", SQL_SERVER_LICENSE_USAGE_FIELD);
        map.put("HaStatus", HA_STATUS_FIELD);
        map.put("ProcessingStatus", PROCESSING_STATUS_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("SqlServerCredentials", SQL_SERVER_CREDENTIALS_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisteredInstance, T> g) {
        return obj -> g.apply((RegisteredInstance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String sqlServerLicenseUsage;
        private String haStatus;
        private String processingStatus;
        private Instant lastUpdatedTime;
        private String sqlServerCredentials;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisteredInstance model) {
            this.instanceId(model.instanceId);
            this.sqlServerLicenseUsage(model.sqlServerLicenseUsage);
            this.haStatus(model.haStatus);
            this.processingStatus(model.processingStatus);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.sqlServerCredentials(model.sqlServerCredentials);
            this.tags(model.tags);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getSqlServerLicenseUsage() {
            return this.sqlServerLicenseUsage;
        }

        public final void setSqlServerLicenseUsage(String sqlServerLicenseUsage) {
            this.sqlServerLicenseUsage = sqlServerLicenseUsage;
        }

        @Override
        public final Builder sqlServerLicenseUsage(String sqlServerLicenseUsage) {
            this.sqlServerLicenseUsage = sqlServerLicenseUsage;
            return this;
        }

        @Override
        public final Builder sqlServerLicenseUsage(SqlServerLicenseUsage sqlServerLicenseUsage) {
            this.sqlServerLicenseUsage(sqlServerLicenseUsage == null ? null : sqlServerLicenseUsage.toString());
            return this;
        }

        public final String getHaStatus() {
            return this.haStatus;
        }

        public final void setHaStatus(String haStatus) {
            this.haStatus = haStatus;
        }

        @Override
        public final Builder haStatus(String haStatus) {
            this.haStatus = haStatus;
            return this;
        }

        @Override
        public final Builder haStatus(HaStatus haStatus) {
            this.haStatus(haStatus == null ? null : haStatus.toString());
            return this;
        }

        public final String getProcessingStatus() {
            return this.processingStatus;
        }

        public final void setProcessingStatus(String processingStatus) {
            this.processingStatus = processingStatus;
        }

        @Override
        public final Builder processingStatus(String processingStatus) {
            this.processingStatus = processingStatus;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getSqlServerCredentials() {
            return this.sqlServerCredentials;
        }

        public final void setSqlServerCredentials(String sqlServerCredentials) {
            this.sqlServerCredentials = sqlServerCredentials;
        }

        @Override
        public final Builder sqlServerCredentials(String sqlServerCredentials) {
            this.sqlServerCredentials = sqlServerCredentials;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RegisteredInstance build() {
            return new RegisteredInstance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RegisteredInstance> {
        public Builder instanceId(String var1);

        public Builder sqlServerLicenseUsage(String var1);

        public Builder sqlServerLicenseUsage(SqlServerLicenseUsage var1);

        public Builder haStatus(String var1);

        public Builder haStatus(HaStatus var1);

        public Builder processingStatus(String var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder sqlServerCredentials(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

