/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsResponse;
import software.amazon.awssdk.services.ec2.model.Ipv6Pool;

public class DescribeIpv6PoolsPublisher
implements SdkPublisher<DescribeIpv6PoolsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeIpv6PoolsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeIpv6PoolsPublisher(Ec2AsyncClient client, DescribeIpv6PoolsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeIpv6PoolsPublisher(Ec2AsyncClient client, DescribeIpv6PoolsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeIpv6PoolsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeIpv6PoolsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Ipv6Pool> ipv6Pools() {
        return this.flatMapIterable(response -> response.ipv6Pools());
    }

    private class DescribeIpv6PoolsResponseFetcher
    implements AsyncPageFetcher<DescribeIpv6PoolsResponse> {
        private DescribeIpv6PoolsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeIpv6PoolsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeIpv6PoolsResponse> nextPage(DescribeIpv6PoolsResponse previousPage) {
            if (previousPage == null) {
                return DescribeIpv6PoolsPublisher.this.client.describeIpv6Pools(DescribeIpv6PoolsPublisher.this.firstRequest);
            }
            return DescribeIpv6PoolsPublisher.this.client.describeIpv6Pools((DescribeIpv6PoolsRequest)((Object)DescribeIpv6PoolsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

