/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesResponse;
import software.amazon.awssdk.services.ec2.model.LaunchTemplate;

public class DescribeLaunchTemplatesPublisher
implements SdkPublisher<DescribeLaunchTemplatesResponse> {
    private final Ec2AsyncClient client;
    private final DescribeLaunchTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeLaunchTemplatesPublisher(Ec2AsyncClient client, DescribeLaunchTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeLaunchTemplatesPublisher(Ec2AsyncClient client, DescribeLaunchTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeLaunchTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeLaunchTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LaunchTemplate> launchTemplates() {
        return this.flatMapIterable(response -> response.launchTemplates());
    }

    private class DescribeLaunchTemplatesResponseFetcher
    implements AsyncPageFetcher<DescribeLaunchTemplatesResponse> {
        private DescribeLaunchTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLaunchTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeLaunchTemplatesResponse> nextPage(DescribeLaunchTemplatesResponse previousPage) {
            if (previousPage == null) {
                return DescribeLaunchTemplatesPublisher.this.client.describeLaunchTemplates(DescribeLaunchTemplatesPublisher.this.firstRequest);
            }
            return DescribeLaunchTemplatesPublisher.this.client.describeLaunchTemplates((DescribeLaunchTemplatesRequest)((Object)DescribeLaunchTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

