/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesResponse;
import software.amazon.awssdk.services.ec2.model.ScheduledInstance;

public class DescribeScheduledInstancesPublisher
implements SdkPublisher<DescribeScheduledInstancesResponse> {
    private final Ec2AsyncClient client;
    private final DescribeScheduledInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeScheduledInstancesPublisher(Ec2AsyncClient client, DescribeScheduledInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeScheduledInstancesPublisher(Ec2AsyncClient client, DescribeScheduledInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeScheduledInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeScheduledInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ScheduledInstance> scheduledInstanceSet() {
        return this.flatMapIterable(response -> response.scheduledInstanceSet());
    }

    private class DescribeScheduledInstancesResponseFetcher
    implements AsyncPageFetcher<DescribeScheduledInstancesResponse> {
        private DescribeScheduledInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeScheduledInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeScheduledInstancesResponse> nextPage(DescribeScheduledInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeScheduledInstancesPublisher.this.client.describeScheduledInstances(DescribeScheduledInstancesPublisher.this.firstRequest);
            }
            return DescribeScheduledInstancesPublisher.this.client.describeScheduledInstances((DescribeScheduledInstancesRequest)((Object)DescribeScheduledInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

