/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options for Amazon S3 as a logging destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifiedAccessLogS3DestinationOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<VerifiedAccessLogS3DestinationOptions.Builder, VerifiedAccessLogS3DestinationOptions> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled")
            .getter(getter(VerifiedAccessLogS3DestinationOptions::enabled))
            .setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled")
                    .unmarshallLocationName("Enabled").build()).build();

    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BucketName")
            .getter(getter(VerifiedAccessLogS3DestinationOptions::bucketName))
            .setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName")
                    .unmarshallLocationName("BucketName").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Prefix")
            .getter(getter(VerifiedAccessLogS3DestinationOptions::prefix))
            .setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix")
                    .unmarshallLocationName("Prefix").build()).build();

    private static final SdkField<String> BUCKET_OWNER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BucketOwner")
            .getter(getter(VerifiedAccessLogS3DestinationOptions::bucketOwner))
            .setter(setter(Builder::bucketOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketOwner")
                    .unmarshallLocationName("BucketOwner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            BUCKET_NAME_FIELD, PREFIX_FIELD, BUCKET_OWNER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final String bucketName;

    private final String prefix;

    private final String bucketOwner;

    private VerifiedAccessLogS3DestinationOptions(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.bucketName = builder.bucketName;
        this.prefix = builder.prefix;
        this.bucketOwner = builder.bucketOwner;
    }

    /**
     * <p>
     * Indicates whether logging is enabled.
     * </p>
     * 
     * @return Indicates whether logging is enabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The bucket name.
     * </p>
     * 
     * @return The bucket name.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * The bucket prefix.
     * </p>
     * 
     * @return The bucket prefix.
     */
    public final String prefix() {
        return prefix;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the Amazon S3 bucket.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the Amazon S3 bucket.
     */
    public final String bucketOwner() {
        return bucketOwner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(bucketOwner());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifiedAccessLogS3DestinationOptions)) {
            return false;
        }
        VerifiedAccessLogS3DestinationOptions other = (VerifiedAccessLogS3DestinationOptions) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(bucketName(), other.bucketName())
                && Objects.equals(prefix(), other.prefix()) && Objects.equals(bucketOwner(), other.bucketOwner());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifiedAccessLogS3DestinationOptions").add("Enabled", enabled())
                .add("BucketName", bucketName()).add("Prefix", prefix()).add("BucketOwner", bucketOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "BucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "BucketOwner":
            return Optional.ofNullable(clazz.cast(bucketOwner()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Enabled", ENABLED_FIELD);
        map.put("BucketName", BUCKET_NAME_FIELD);
        map.put("Prefix", PREFIX_FIELD);
        map.put("BucketOwner", BUCKET_OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerifiedAccessLogS3DestinationOptions, T> g) {
        return obj -> g.apply((VerifiedAccessLogS3DestinationOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VerifiedAccessLogS3DestinationOptions> {
        /**
         * <p>
         * Indicates whether logging is enabled.
         * </p>
         * 
         * @param enabled
         *        Indicates whether logging is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The bucket name.
         * </p>
         * 
         * @param bucketName
         *        The bucket name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * The bucket prefix.
         * </p>
         * 
         * @param prefix
         *        The bucket prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the Amazon S3 bucket.
         * </p>
         * 
         * @param bucketOwner
         *        The ID of the Amazon Web Services account that owns the Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketOwner(String bucketOwner);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String bucketName;

        private String prefix;

        private String bucketOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifiedAccessLogS3DestinationOptions model) {
            enabled(model.enabled);
            bucketName(model.bucketName);
            prefix(model.prefix);
            bucketOwner(model.bucketOwner);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getBucketName() {
            return bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final String getBucketOwner() {
            return bucketOwner;
        }

        public final void setBucketOwner(String bucketOwner) {
            this.bucketOwner = bucketOwner;
        }

        @Override
        public final Builder bucketOwner(String bucketOwner) {
            this.bucketOwner = bucketOwner;
            return this;
        }

        @Override
        public VerifiedAccessLogS3DestinationOptions build() {
            return new VerifiedAccessLogS3DestinationOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
