/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ExcessCapacityTerminationPolicy;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateConfig;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateConfigListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifySpotFleetRequestRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifySpotFleetRequestRequest> {
    private static final SdkField<List<LaunchTemplateConfig>> LAUNCH_TEMPLATE_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LaunchTemplateConfigs").getter(ModifySpotFleetRequestRequest.getter(ModifySpotFleetRequestRequest::launchTemplateConfigs)).setter(ModifySpotFleetRequestRequest.setter(Builder::launchTemplateConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateConfig").unmarshallLocationName("LaunchTemplateConfig").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchTemplateConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> ON_DEMAND_TARGET_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("OnDemandTargetCapacity").getter(ModifySpotFleetRequestRequest.getter(ModifySpotFleetRequestRequest::onDemandTargetCapacity)).setter(ModifySpotFleetRequestRequest.setter(Builder::onDemandTargetCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandTargetCapacity").unmarshallLocationName("OnDemandTargetCapacity").build()}).build();
    private static final SdkField<String> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Context").getter(ModifySpotFleetRequestRequest.getter(ModifySpotFleetRequestRequest::context)).setter(ModifySpotFleetRequestRequest.setter(Builder::context)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").unmarshallLocationName("Context").build()}).build();
    private static final SdkField<String> SPOT_FLEET_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpotFleetRequestId").getter(ModifySpotFleetRequestRequest.getter(ModifySpotFleetRequestRequest::spotFleetRequestId)).setter(ModifySpotFleetRequestRequest.setter(Builder::spotFleetRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotFleetRequestId").unmarshallLocationName("spotFleetRequestId").build()}).build();
    private static final SdkField<Integer> TARGET_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TargetCapacity").getter(ModifySpotFleetRequestRequest.getter(ModifySpotFleetRequestRequest::targetCapacity)).setter(ModifySpotFleetRequestRequest.setter(Builder::targetCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCapacity").unmarshallLocationName("targetCapacity").build()}).build();
    private static final SdkField<String> EXCESS_CAPACITY_TERMINATION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExcessCapacityTerminationPolicy").getter(ModifySpotFleetRequestRequest.getter(ModifySpotFleetRequestRequest::excessCapacityTerminationPolicyAsString)).setter(ModifySpotFleetRequestRequest.setter(Builder::excessCapacityTerminationPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcessCapacityTerminationPolicy").unmarshallLocationName("excessCapacityTerminationPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_CONFIGS_FIELD, ON_DEMAND_TARGET_CAPACITY_FIELD, CONTEXT_FIELD, SPOT_FLEET_REQUEST_ID_FIELD, TARGET_CAPACITY_FIELD, EXCESS_CAPACITY_TERMINATION_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifySpotFleetRequestRequest.memberNameToFieldInitializer();
    private final List<LaunchTemplateConfig> launchTemplateConfigs;
    private final Integer onDemandTargetCapacity;
    private final String context;
    private final String spotFleetRequestId;
    private final Integer targetCapacity;
    private final String excessCapacityTerminationPolicy;

    private ModifySpotFleetRequestRequest(BuilderImpl builder) {
        super(builder);
        this.launchTemplateConfigs = builder.launchTemplateConfigs;
        this.onDemandTargetCapacity = builder.onDemandTargetCapacity;
        this.context = builder.context;
        this.spotFleetRequestId = builder.spotFleetRequestId;
        this.targetCapacity = builder.targetCapacity;
        this.excessCapacityTerminationPolicy = builder.excessCapacityTerminationPolicy;
    }

    public final boolean hasLaunchTemplateConfigs() {
        return this.launchTemplateConfigs != null && !(this.launchTemplateConfigs instanceof SdkAutoConstructList);
    }

    public final List<LaunchTemplateConfig> launchTemplateConfigs() {
        return this.launchTemplateConfigs;
    }

    public final Integer onDemandTargetCapacity() {
        return this.onDemandTargetCapacity;
    }

    public final String context() {
        return this.context;
    }

    public final String spotFleetRequestId() {
        return this.spotFleetRequestId;
    }

    public final Integer targetCapacity() {
        return this.targetCapacity;
    }

    public final ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy() {
        return ExcessCapacityTerminationPolicy.fromValue(this.excessCapacityTerminationPolicy);
    }

    public final String excessCapacityTerminationPolicyAsString() {
        return this.excessCapacityTerminationPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLaunchTemplateConfigs() ? this.launchTemplateConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandTargetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.context());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotFleetRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.excessCapacityTerminationPolicyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifySpotFleetRequestRequest)) {
            return false;
        }
        ModifySpotFleetRequestRequest other = (ModifySpotFleetRequestRequest)((Object)obj);
        return this.hasLaunchTemplateConfigs() == other.hasLaunchTemplateConfigs() && Objects.equals(this.launchTemplateConfigs(), other.launchTemplateConfigs()) && Objects.equals(this.onDemandTargetCapacity(), other.onDemandTargetCapacity()) && Objects.equals(this.context(), other.context()) && Objects.equals(this.spotFleetRequestId(), other.spotFleetRequestId()) && Objects.equals(this.targetCapacity(), other.targetCapacity()) && Objects.equals(this.excessCapacityTerminationPolicyAsString(), other.excessCapacityTerminationPolicyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ModifySpotFleetRequestRequest").add("LaunchTemplateConfigs", this.hasLaunchTemplateConfigs() ? this.launchTemplateConfigs() : null).add("OnDemandTargetCapacity", (Object)this.onDemandTargetCapacity()).add("Context", (Object)this.context()).add("SpotFleetRequestId", (Object)this.spotFleetRequestId()).add("TargetCapacity", (Object)this.targetCapacity()).add("ExcessCapacityTerminationPolicy", (Object)this.excessCapacityTerminationPolicyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchTemplateConfigs": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateConfigs()));
            }
            case "OnDemandTargetCapacity": {
                return Optional.ofNullable(clazz.cast(this.onDemandTargetCapacity()));
            }
            case "Context": {
                return Optional.ofNullable(clazz.cast(this.context()));
            }
            case "SpotFleetRequestId": {
                return Optional.ofNullable(clazz.cast(this.spotFleetRequestId()));
            }
            case "TargetCapacity": {
                return Optional.ofNullable(clazz.cast(this.targetCapacity()));
            }
            case "ExcessCapacityTerminationPolicy": {
                return Optional.ofNullable(clazz.cast(this.excessCapacityTerminationPolicyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LaunchTemplateConfig", LAUNCH_TEMPLATE_CONFIGS_FIELD);
        map.put("OnDemandTargetCapacity", ON_DEMAND_TARGET_CAPACITY_FIELD);
        map.put("Context", CONTEXT_FIELD);
        map.put("SpotFleetRequestId", SPOT_FLEET_REQUEST_ID_FIELD);
        map.put("TargetCapacity", TARGET_CAPACITY_FIELD);
        map.put("ExcessCapacityTerminationPolicy", EXCESS_CAPACITY_TERMINATION_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifySpotFleetRequestRequest, T> g) {
        return obj -> g.apply((ModifySpotFleetRequestRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<LaunchTemplateConfig> launchTemplateConfigs = DefaultSdkAutoConstructList.getInstance();
        private Integer onDemandTargetCapacity;
        private String context;
        private String spotFleetRequestId;
        private Integer targetCapacity;
        private String excessCapacityTerminationPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifySpotFleetRequestRequest model) {
            super(model);
            this.launchTemplateConfigs(model.launchTemplateConfigs);
            this.onDemandTargetCapacity(model.onDemandTargetCapacity);
            this.context(model.context);
            this.spotFleetRequestId(model.spotFleetRequestId);
            this.targetCapacity(model.targetCapacity);
            this.excessCapacityTerminationPolicy(model.excessCapacityTerminationPolicy);
        }

        public final List<LaunchTemplateConfig.Builder> getLaunchTemplateConfigs() {
            List<LaunchTemplateConfig.Builder> result = LaunchTemplateConfigListCopier.copyToBuilder(this.launchTemplateConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLaunchTemplateConfigs(Collection<LaunchTemplateConfig.BuilderImpl> launchTemplateConfigs) {
            this.launchTemplateConfigs = LaunchTemplateConfigListCopier.copyFromBuilder(launchTemplateConfigs);
        }

        @Override
        public final Builder launchTemplateConfigs(Collection<LaunchTemplateConfig> launchTemplateConfigs) {
            this.launchTemplateConfigs = LaunchTemplateConfigListCopier.copy(launchTemplateConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigs(LaunchTemplateConfig ... launchTemplateConfigs) {
            this.launchTemplateConfigs(Arrays.asList(launchTemplateConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigs(Consumer<LaunchTemplateConfig.Builder> ... launchTemplateConfigs) {
            this.launchTemplateConfigs(Stream.of(launchTemplateConfigs).map(c -> (LaunchTemplateConfig)((LaunchTemplateConfig.Builder)LaunchTemplateConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getOnDemandTargetCapacity() {
            return this.onDemandTargetCapacity;
        }

        public final void setOnDemandTargetCapacity(Integer onDemandTargetCapacity) {
            this.onDemandTargetCapacity = onDemandTargetCapacity;
        }

        @Override
        public final Builder onDemandTargetCapacity(Integer onDemandTargetCapacity) {
            this.onDemandTargetCapacity = onDemandTargetCapacity;
            return this;
        }

        public final String getContext() {
            return this.context;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        public final String getSpotFleetRequestId() {
            return this.spotFleetRequestId;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        @Override
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        public final Integer getTargetCapacity() {
            return this.targetCapacity;
        }

        public final void setTargetCapacity(Integer targetCapacity) {
            this.targetCapacity = targetCapacity;
        }

        @Override
        public final Builder targetCapacity(Integer targetCapacity) {
            this.targetCapacity = targetCapacity;
            return this;
        }

        public final String getExcessCapacityTerminationPolicy() {
            return this.excessCapacityTerminationPolicy;
        }

        public final void setExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
            return this;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy(excessCapacityTerminationPolicy == null ? null : excessCapacityTerminationPolicy.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifySpotFleetRequestRequest build() {
            return new ModifySpotFleetRequestRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifySpotFleetRequestRequest> {
        public Builder launchTemplateConfigs(Collection<LaunchTemplateConfig> var1);

        public Builder launchTemplateConfigs(LaunchTemplateConfig ... var1);

        public Builder launchTemplateConfigs(Consumer<LaunchTemplateConfig.Builder> ... var1);

        public Builder onDemandTargetCapacity(Integer var1);

        public Builder context(String var1);

        public Builder spotFleetRequestId(String var1);

        public Builder targetCapacity(Integer var1);

        public Builder excessCapacityTerminationPolicy(String var1);

        public Builder excessCapacityTerminationPolicy(ExcessCapacityTerminationPolicy var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

