/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class CapacityBlockSetCopier {
    static List<CapacityBlock> copy(Collection<? extends CapacityBlock> capacityBlockSetParam) {
        List<CapacityBlock> list;
        if (capacityBlockSetParam == null || capacityBlockSetParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<CapacityBlock> modifiableList = new ArrayList<>(capacityBlockSetParam.size());
            capacityBlockSetParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<CapacityBlock> copyFromBuilder(Collection<? extends CapacityBlock.Builder> capacityBlockSetParam) {
        List<CapacityBlock> list;
        if (capacityBlockSetParam == null || capacityBlockSetParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<CapacityBlock> modifiableList = new ArrayList<>(capacityBlockSetParam.size());
            capacityBlockSetParam.forEach(entry -> {
                CapacityBlock member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<CapacityBlock.Builder> copyToBuilder(Collection<? extends CapacityBlock> capacityBlockSetParam) {
        List<CapacityBlock.Builder> list;
        if (capacityBlockSetParam == null || capacityBlockSetParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<CapacityBlock.Builder> modifiableList = new ArrayList<>(capacityBlockSetParam.size());
            capacityBlockSetParam.forEach(entry -> {
                CapacityBlock.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
