/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCapacityManagerDataExportRequest extends Ec2Request implements
        ToCopyableBuilder<CreateCapacityManagerDataExportRequest.Builder, CreateCapacityManagerDataExportRequest> {
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("S3BucketName")
            .getter(getter(CreateCapacityManagerDataExportRequest::s3BucketName))
            .setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName")
                    .unmarshallLocationName("S3BucketName").build()).build();

    private static final SdkField<String> S3_BUCKET_PREFIX_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("S3BucketPrefix")
            .getter(getter(CreateCapacityManagerDataExportRequest::s3BucketPrefix))
            .setter(setter(Builder::s3BucketPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketPrefix")
                    .unmarshallLocationName("S3BucketPrefix").build()).build();

    private static final SdkField<String> SCHEDULE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Schedule")
            .getter(getter(CreateCapacityManagerDataExportRequest::scheduleAsString))
            .setter(setter(Builder::schedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule")
                    .unmarshallLocationName("Schedule").build()).build();

    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutputFormat")
            .getter(getter(CreateCapacityManagerDataExportRequest::outputFormatAsString))
            .setter(setter(Builder::outputFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputFormat")
                    .unmarshallLocationName("OutputFormat").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateCapacityManagerDataExportRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(CreateCapacityManagerDataExportRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateCapacityManagerDataExportRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_NAME_FIELD,
            S3_BUCKET_PREFIX_FIELD, SCHEDULE_FIELD, OUTPUT_FORMAT_FIELD, CLIENT_TOKEN_FIELD, DRY_RUN_FIELD,
            TAG_SPECIFICATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String s3BucketName;

    private final String s3BucketPrefix;

    private final String schedule;

    private final String outputFormat;

    private final String clientToken;

    private final Boolean dryRun;

    private final List<TagSpecification> tagSpecifications;

    private CreateCapacityManagerDataExportRequest(BuilderImpl builder) {
        super(builder);
        this.s3BucketName = builder.s3BucketName;
        this.s3BucketPrefix = builder.s3BucketPrefix;
        this.schedule = builder.schedule;
        this.outputFormat = builder.outputFormat;
        this.clientToken = builder.clientToken;
        this.dryRun = builder.dryRun;
        this.tagSpecifications = builder.tagSpecifications;
    }

    /**
     * <p>
     * The name of the S3 bucket where the capacity data export files will be delivered. The bucket must exist and you
     * must have write permissions to it.
     * </p>
     * 
     * @return The name of the S3 bucket where the capacity data export files will be delivered. The bucket must exist
     *         and you must have write permissions to it.
     */
    public final String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * The S3 key prefix for the exported data files. This allows you to organize exports in a specific folder structure
     * within your bucket. If not specified, files are placed at the bucket root.
     * </p>
     * 
     * @return The S3 key prefix for the exported data files. This allows you to organize exports in a specific folder
     *         structure within your bucket. If not specified, files are placed at the bucket root.
     */
    public final String s3BucketPrefix() {
        return s3BucketPrefix;
    }

    /**
     * <p>
     * The frequency at which data exports are generated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #schedule} will
     * return {@link Schedule#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scheduleAsString}.
     * </p>
     * 
     * @return The frequency at which data exports are generated.
     * @see Schedule
     */
    public final Schedule schedule() {
        return Schedule.fromValue(schedule);
    }

    /**
     * <p>
     * The frequency at which data exports are generated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #schedule} will
     * return {@link Schedule#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scheduleAsString}.
     * </p>
     * 
     * @return The frequency at which data exports are generated.
     * @see Schedule
     */
    public final String scheduleAsString() {
        return schedule;
    }

    /**
     * <p>
     * The file format for the exported data. Parquet format is recommended for large datasets and better compression.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputFormat} will
     * return {@link OutputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputFormatAsString}.
     * </p>
     * 
     * @return The file format for the exported data. Parquet format is recommended for large datasets and better
     *         compression.
     * @see OutputFormat
     */
    public final OutputFormat outputFormat() {
        return OutputFormat.fromValue(outputFormat);
    }

    /**
     * <p>
     * The file format for the exported data. Parquet format is recommended for large datasets and better compression.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputFormat} will
     * return {@link OutputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputFormatAsString}.
     * </p>
     * 
     * @return The file format for the exported data. Parquet format is recommended for large datasets and better
     *         compression.
     * @see OutputFormat
     */
    public final String outputFormatAsString() {
        return outputFormat;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see Ensure Idempotency.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see Ensure Idempotency.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the data export configuration. You can tag the export for organization and cost tracking
     * purposes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to apply to the data export configuration. You can tag the export for organization and cost
     *         tracking purposes.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCapacityManagerDataExportRequest)) {
            return false;
        }
        CreateCapacityManagerDataExportRequest other = (CreateCapacityManagerDataExportRequest) obj;
        return Objects.equals(s3BucketName(), other.s3BucketName()) && Objects.equals(s3BucketPrefix(), other.s3BucketPrefix())
                && Objects.equals(scheduleAsString(), other.scheduleAsString())
                && Objects.equals(outputFormatAsString(), other.outputFormatAsString())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(dryRun(), other.dryRun())
                && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCapacityManagerDataExportRequest").add("S3BucketName", s3BucketName())
                .add("S3BucketPrefix", s3BucketPrefix()).add("Schedule", scheduleAsString())
                .add("OutputFormat", outputFormatAsString()).add("ClientToken", clientToken()).add("DryRun", dryRun())
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "S3BucketPrefix":
            return Optional.ofNullable(clazz.cast(s3BucketPrefix()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(scheduleAsString()));
        case "OutputFormat":
            return Optional.ofNullable(clazz.cast(outputFormatAsString()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3BucketName", S3_BUCKET_NAME_FIELD);
        map.put("S3BucketPrefix", S3_BUCKET_PREFIX_FIELD);
        map.put("Schedule", SCHEDULE_FIELD);
        map.put("OutputFormat", OUTPUT_FORMAT_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCapacityManagerDataExportRequest, T> g) {
        return obj -> g.apply((CreateCapacityManagerDataExportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCapacityManagerDataExportRequest> {
        /**
         * <p>
         * The name of the S3 bucket where the capacity data export files will be delivered. The bucket must exist and
         * you must have write permissions to it.
         * </p>
         * 
         * @param s3BucketName
         *        The name of the S3 bucket where the capacity data export files will be delivered. The bucket must
         *        exist and you must have write permissions to it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * The S3 key prefix for the exported data files. This allows you to organize exports in a specific folder
         * structure within your bucket. If not specified, files are placed at the bucket root.
         * </p>
         * 
         * @param s3BucketPrefix
         *        The S3 key prefix for the exported data files. This allows you to organize exports in a specific
         *        folder structure within your bucket. If not specified, files are placed at the bucket root.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketPrefix(String s3BucketPrefix);

        /**
         * <p>
         * The frequency at which data exports are generated.
         * </p>
         * 
         * @param schedule
         *        The frequency at which data exports are generated.
         * @see Schedule
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Schedule
         */
        Builder schedule(String schedule);

        /**
         * <p>
         * The frequency at which data exports are generated.
         * </p>
         * 
         * @param schedule
         *        The frequency at which data exports are generated.
         * @see Schedule
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Schedule
         */
        Builder schedule(Schedule schedule);

        /**
         * <p>
         * The file format for the exported data. Parquet format is recommended for large datasets and better
         * compression.
         * </p>
         * 
         * @param outputFormat
         *        The file format for the exported data. Parquet format is recommended for large datasets and better
         *        compression.
         * @see OutputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputFormat
         */
        Builder outputFormat(String outputFormat);

        /**
         * <p>
         * The file format for the exported data. Parquet format is recommended for large datasets and better
         * compression.
         * </p>
         * 
         * @param outputFormat
         *        The file format for the exported data. Parquet format is recommended for large datasets and better
         *        compression.
         * @see OutputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputFormat
         */
        Builder outputFormat(OutputFormat outputFormat);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see Ensure Idempotency.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see Ensure Idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The tags to apply to the data export configuration. You can tag the export for organization and cost tracking
         * purposes.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the data export configuration. You can tag the export for organization and cost
         *        tracking purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the data export configuration. You can tag the export for organization and cost tracking
         * purposes.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the data export configuration. You can tag the export for organization and cost
         *        tracking purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply to the data export configuration. You can tag the export for organization and cost tracking
         * purposes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String s3BucketName;

        private String s3BucketPrefix;

        private String schedule;

        private String outputFormat;

        private String clientToken;

        private Boolean dryRun;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCapacityManagerDataExportRequest model) {
            super(model);
            s3BucketName(model.s3BucketName);
            s3BucketPrefix(model.s3BucketPrefix);
            schedule(model.schedule);
            outputFormat(model.outputFormat);
            clientToken(model.clientToken);
            dryRun(model.dryRun);
            tagSpecifications(model.tagSpecifications);
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getS3BucketPrefix() {
            return s3BucketPrefix;
        }

        public final void setS3BucketPrefix(String s3BucketPrefix) {
            this.s3BucketPrefix = s3BucketPrefix;
        }

        @Override
        public final Builder s3BucketPrefix(String s3BucketPrefix) {
            this.s3BucketPrefix = s3BucketPrefix;
            return this;
        }

        public final String getSchedule() {
            return schedule;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule(schedule == null ? null : schedule.toString());
            return this;
        }

        public final String getOutputFormat() {
            return outputFormat;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(OutputFormat outputFormat) {
            this.outputFormat(outputFormat == null ? null : outputFormat.toString());
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCapacityManagerDataExportRequest build() {
            return new CreateCapacityManagerDataExportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
