/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetActiveVpnTunnelStatusResponse extends Ec2Response implements
        ToCopyableBuilder<GetActiveVpnTunnelStatusResponse.Builder, GetActiveVpnTunnelStatusResponse> {
    private static final SdkField<ActiveVpnTunnelStatus> ACTIVE_VPN_TUNNEL_STATUS_FIELD = SdkField
            .<ActiveVpnTunnelStatus> builder(MarshallingType.SDK_POJO)
            .memberName("ActiveVpnTunnelStatus")
            .getter(getter(GetActiveVpnTunnelStatusResponse::activeVpnTunnelStatus))
            .setter(setter(Builder::activeVpnTunnelStatus))
            .constructor(ActiveVpnTunnelStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveVpnTunnelStatus")
                    .unmarshallLocationName("activeVpnTunnelStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ACTIVE_VPN_TUNNEL_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ActiveVpnTunnelStatus activeVpnTunnelStatus;

    private GetActiveVpnTunnelStatusResponse(BuilderImpl builder) {
        super(builder);
        this.activeVpnTunnelStatus = builder.activeVpnTunnelStatus;
    }

    /**
     * <p>
     * Information about the current security configuration of the VPN tunnel.
     * </p>
     * 
     * @return Information about the current security configuration of the VPN tunnel.
     */
    public final ActiveVpnTunnelStatus activeVpnTunnelStatus() {
        return activeVpnTunnelStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(activeVpnTunnelStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetActiveVpnTunnelStatusResponse)) {
            return false;
        }
        GetActiveVpnTunnelStatusResponse other = (GetActiveVpnTunnelStatusResponse) obj;
        return Objects.equals(activeVpnTunnelStatus(), other.activeVpnTunnelStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetActiveVpnTunnelStatusResponse").add("ActiveVpnTunnelStatus", activeVpnTunnelStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActiveVpnTunnelStatus":
            return Optional.ofNullable(clazz.cast(activeVpnTunnelStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ActiveVpnTunnelStatus", ACTIVE_VPN_TUNNEL_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetActiveVpnTunnelStatusResponse, T> g) {
        return obj -> g.apply((GetActiveVpnTunnelStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetActiveVpnTunnelStatusResponse> {
        /**
         * <p>
         * Information about the current security configuration of the VPN tunnel.
         * </p>
         * 
         * @param activeVpnTunnelStatus
         *        Information about the current security configuration of the VPN tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeVpnTunnelStatus(ActiveVpnTunnelStatus activeVpnTunnelStatus);

        /**
         * <p>
         * Information about the current security configuration of the VPN tunnel.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActiveVpnTunnelStatus.Builder} avoiding
         * the need to create one manually via {@link ActiveVpnTunnelStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActiveVpnTunnelStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #activeVpnTunnelStatus(ActiveVpnTunnelStatus)}.
         * 
         * @param activeVpnTunnelStatus
         *        a consumer that will call methods on {@link ActiveVpnTunnelStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activeVpnTunnelStatus(ActiveVpnTunnelStatus)
         */
        default Builder activeVpnTunnelStatus(Consumer<ActiveVpnTunnelStatus.Builder> activeVpnTunnelStatus) {
            return activeVpnTunnelStatus(ActiveVpnTunnelStatus.builder().applyMutation(activeVpnTunnelStatus).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private ActiveVpnTunnelStatus activeVpnTunnelStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetActiveVpnTunnelStatusResponse model) {
            super(model);
            activeVpnTunnelStatus(model.activeVpnTunnelStatus);
        }

        public final ActiveVpnTunnelStatus.Builder getActiveVpnTunnelStatus() {
            return activeVpnTunnelStatus != null ? activeVpnTunnelStatus.toBuilder() : null;
        }

        public final void setActiveVpnTunnelStatus(ActiveVpnTunnelStatus.BuilderImpl activeVpnTunnelStatus) {
            this.activeVpnTunnelStatus = activeVpnTunnelStatus != null ? activeVpnTunnelStatus.build() : null;
        }

        @Override
        public final Builder activeVpnTunnelStatus(ActiveVpnTunnelStatus activeVpnTunnelStatus) {
            this.activeVpnTunnelStatus = activeVpnTunnelStatus;
            return this;
        }

        @Override
        public GetActiveVpnTunnelStatusResponse build() {
            return new GetActiveVpnTunnelStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
