/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.GetCapacityManagerMetricDataRequest;
import software.amazon.awssdk.services.ec2.model.GetCapacityManagerMetricDataResponse;
import software.amazon.awssdk.services.ec2.model.MetricDataResult;

public class GetCapacityManagerMetricDataPublisher
implements SdkPublisher<GetCapacityManagerMetricDataResponse> {
    private final Ec2AsyncClient client;
    private final GetCapacityManagerMetricDataRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetCapacityManagerMetricDataPublisher(Ec2AsyncClient client, GetCapacityManagerMetricDataRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetCapacityManagerMetricDataPublisher(Ec2AsyncClient client, GetCapacityManagerMetricDataRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetCapacityManagerMetricDataResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetCapacityManagerMetricDataResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MetricDataResult> metricDataResults() {
        return this.flatMapIterable(response -> response.metricDataResults());
    }

    private class GetCapacityManagerMetricDataResponseFetcher
    implements AsyncPageFetcher<GetCapacityManagerMetricDataResponse> {
        private GetCapacityManagerMetricDataResponseFetcher() {
        }

        public boolean hasNextPage(GetCapacityManagerMetricDataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetCapacityManagerMetricDataResponse> nextPage(GetCapacityManagerMetricDataResponse previousPage) {
            if (previousPage == null) {
                return GetCapacityManagerMetricDataPublisher.this.client.getCapacityManagerMetricData(GetCapacityManagerMetricDataPublisher.this.firstRequest);
            }
            return GetCapacityManagerMetricDataPublisher.this.client.getCapacityManagerMetricData((GetCapacityManagerMetricDataRequest)((Object)GetCapacityManagerMetricDataPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

