/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecr.model.ScanFrequency;
import software.amazon.awssdk.services.ecr.model.ScanningRepositoryFilter;
import software.amazon.awssdk.services.ecr.model.ScanningRepositoryFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RepositoryScanningConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RepositoryScanningConfiguration> {
    private static final SdkField<String> REPOSITORY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryArn").getter(RepositoryScanningConfiguration.getter(RepositoryScanningConfiguration::repositoryArn)).setter(RepositoryScanningConfiguration.setter(Builder::repositoryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryArn").build()}).build();
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(RepositoryScanningConfiguration.getter(RepositoryScanningConfiguration::repositoryName)).setter(RepositoryScanningConfiguration.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<Boolean> SCAN_ON_PUSH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("scanOnPush").getter(RepositoryScanningConfiguration.getter(RepositoryScanningConfiguration::scanOnPush)).setter(RepositoryScanningConfiguration.setter(Builder::scanOnPush)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanOnPush").build()}).build();
    private static final SdkField<String> SCAN_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scanFrequency").getter(RepositoryScanningConfiguration.getter(RepositoryScanningConfiguration::scanFrequencyAsString)).setter(RepositoryScanningConfiguration.setter(Builder::scanFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanFrequency").build()}).build();
    private static final SdkField<List<ScanningRepositoryFilter>> APPLIED_SCAN_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("appliedScanFilters").getter(RepositoryScanningConfiguration.getter(RepositoryScanningConfiguration::appliedScanFilters)).setter(RepositoryScanningConfiguration.setter(Builder::appliedScanFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appliedScanFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScanningRepositoryFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_ARN_FIELD, REPOSITORY_NAME_FIELD, SCAN_ON_PUSH_FIELD, SCAN_FREQUENCY_FIELD, APPLIED_SCAN_FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RepositoryScanningConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String repositoryArn;
    private final String repositoryName;
    private final Boolean scanOnPush;
    private final String scanFrequency;
    private final List<ScanningRepositoryFilter> appliedScanFilters;

    private RepositoryScanningConfiguration(BuilderImpl builder) {
        this.repositoryArn = builder.repositoryArn;
        this.repositoryName = builder.repositoryName;
        this.scanOnPush = builder.scanOnPush;
        this.scanFrequency = builder.scanFrequency;
        this.appliedScanFilters = builder.appliedScanFilters;
    }

    public final String repositoryArn() {
        return this.repositoryArn;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final Boolean scanOnPush() {
        return this.scanOnPush;
    }

    public final ScanFrequency scanFrequency() {
        return ScanFrequency.fromValue(this.scanFrequency);
    }

    public final String scanFrequencyAsString() {
        return this.scanFrequency;
    }

    public final boolean hasAppliedScanFilters() {
        return this.appliedScanFilters != null && !(this.appliedScanFilters instanceof SdkAutoConstructList);
    }

    public final List<ScanningRepositoryFilter> appliedScanFilters() {
        return this.appliedScanFilters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanOnPush());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppliedScanFilters() ? this.appliedScanFilters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryScanningConfiguration)) {
            return false;
        }
        RepositoryScanningConfiguration other = (RepositoryScanningConfiguration)obj;
        return Objects.equals(this.repositoryArn(), other.repositoryArn()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.scanOnPush(), other.scanOnPush()) && Objects.equals(this.scanFrequencyAsString(), other.scanFrequencyAsString()) && this.hasAppliedScanFilters() == other.hasAppliedScanFilters() && Objects.equals(this.appliedScanFilters(), other.appliedScanFilters());
    }

    public final String toString() {
        return ToString.builder((String)"RepositoryScanningConfiguration").add("RepositoryArn", (Object)this.repositoryArn()).add("RepositoryName", (Object)this.repositoryName()).add("ScanOnPush", (Object)this.scanOnPush()).add("ScanFrequency", (Object)this.scanFrequencyAsString()).add("AppliedScanFilters", this.hasAppliedScanFilters() ? this.appliedScanFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryArn": {
                return Optional.ofNullable(clazz.cast(this.repositoryArn()));
            }
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "scanOnPush": {
                return Optional.ofNullable(clazz.cast(this.scanOnPush()));
            }
            case "scanFrequency": {
                return Optional.ofNullable(clazz.cast(this.scanFrequencyAsString()));
            }
            case "appliedScanFilters": {
                return Optional.ofNullable(clazz.cast(this.appliedScanFilters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("repositoryArn", REPOSITORY_ARN_FIELD);
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("scanOnPush", SCAN_ON_PUSH_FIELD);
        map.put("scanFrequency", SCAN_FREQUENCY_FIELD);
        map.put("appliedScanFilters", APPLIED_SCAN_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RepositoryScanningConfiguration, T> g) {
        return obj -> g.apply((RepositoryScanningConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String repositoryArn;
        private String repositoryName;
        private Boolean scanOnPush;
        private String scanFrequency;
        private List<ScanningRepositoryFilter> appliedScanFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryScanningConfiguration model) {
            this.repositoryArn(model.repositoryArn);
            this.repositoryName(model.repositoryName);
            this.scanOnPush(model.scanOnPush);
            this.scanFrequency(model.scanFrequency);
            this.appliedScanFilters(model.appliedScanFilters);
        }

        public final String getRepositoryArn() {
            return this.repositoryArn;
        }

        public final void setRepositoryArn(String repositoryArn) {
            this.repositoryArn = repositoryArn;
        }

        @Override
        public final Builder repositoryArn(String repositoryArn) {
            this.repositoryArn = repositoryArn;
            return this;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final Boolean getScanOnPush() {
            return this.scanOnPush;
        }

        public final void setScanOnPush(Boolean scanOnPush) {
            this.scanOnPush = scanOnPush;
        }

        @Override
        public final Builder scanOnPush(Boolean scanOnPush) {
            this.scanOnPush = scanOnPush;
            return this;
        }

        public final String getScanFrequency() {
            return this.scanFrequency;
        }

        public final void setScanFrequency(String scanFrequency) {
            this.scanFrequency = scanFrequency;
        }

        @Override
        public final Builder scanFrequency(String scanFrequency) {
            this.scanFrequency = scanFrequency;
            return this;
        }

        @Override
        public final Builder scanFrequency(ScanFrequency scanFrequency) {
            this.scanFrequency(scanFrequency == null ? null : scanFrequency.toString());
            return this;
        }

        public final List<ScanningRepositoryFilter.Builder> getAppliedScanFilters() {
            List<ScanningRepositoryFilter.Builder> result = ScanningRepositoryFilterListCopier.copyToBuilder(this.appliedScanFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppliedScanFilters(Collection<ScanningRepositoryFilter.BuilderImpl> appliedScanFilters) {
            this.appliedScanFilters = ScanningRepositoryFilterListCopier.copyFromBuilder(appliedScanFilters);
        }

        @Override
        public final Builder appliedScanFilters(Collection<ScanningRepositoryFilter> appliedScanFilters) {
            this.appliedScanFilters = ScanningRepositoryFilterListCopier.copy(appliedScanFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appliedScanFilters(ScanningRepositoryFilter ... appliedScanFilters) {
            this.appliedScanFilters(Arrays.asList(appliedScanFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appliedScanFilters(Consumer<ScanningRepositoryFilter.Builder> ... appliedScanFilters) {
            this.appliedScanFilters(Stream.of(appliedScanFilters).map(c -> (ScanningRepositoryFilter)((ScanningRepositoryFilter.Builder)ScanningRepositoryFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RepositoryScanningConfiguration build() {
            return new RepositoryScanningConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RepositoryScanningConfiguration> {
        public Builder repositoryArn(String var1);

        public Builder repositoryName(String var1);

        public Builder scanOnPush(Boolean var1);

        public Builder scanFrequency(String var1);

        public Builder scanFrequency(ScanFrequency var1);

        public Builder appliedScanFilters(Collection<ScanningRepositoryFilter> var1);

        public Builder appliedScanFilters(ScanningRepositoryFilter ... var1);

        public Builder appliedScanFilters(Consumer<ScanningRepositoryFilter.Builder> ... var1);
    }
}

