/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecrpublic;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.ecrpublic.EcrPublicClient;
import software.amazon.awssdk.services.ecrpublic.EcrPublicServiceClientConfiguration;
import software.amazon.awssdk.services.ecrpublic.internal.EcrPublicServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.ecrpublic.model.BatchCheckLayerAvailabilityRequest;
import software.amazon.awssdk.services.ecrpublic.model.BatchCheckLayerAvailabilityResponse;
import software.amazon.awssdk.services.ecrpublic.model.BatchDeleteImageRequest;
import software.amazon.awssdk.services.ecrpublic.model.BatchDeleteImageResponse;
import software.amazon.awssdk.services.ecrpublic.model.CompleteLayerUploadRequest;
import software.amazon.awssdk.services.ecrpublic.model.CompleteLayerUploadResponse;
import software.amazon.awssdk.services.ecrpublic.model.CreateRepositoryRequest;
import software.amazon.awssdk.services.ecrpublic.model.CreateRepositoryResponse;
import software.amazon.awssdk.services.ecrpublic.model.DeleteRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecrpublic.model.DeleteRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecrpublic.model.DeleteRepositoryRequest;
import software.amazon.awssdk.services.ecrpublic.model.DeleteRepositoryResponse;
import software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsRequest;
import software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsResponse;
import software.amazon.awssdk.services.ecrpublic.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ecrpublic.model.DescribeImagesResponse;
import software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesRequest;
import software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesResponse;
import software.amazon.awssdk.services.ecrpublic.model.DescribeRepositoriesRequest;
import software.amazon.awssdk.services.ecrpublic.model.DescribeRepositoriesResponse;
import software.amazon.awssdk.services.ecrpublic.model.EcrPublicException;
import software.amazon.awssdk.services.ecrpublic.model.EmptyUploadException;
import software.amazon.awssdk.services.ecrpublic.model.GetAuthorizationTokenRequest;
import software.amazon.awssdk.services.ecrpublic.model.GetAuthorizationTokenResponse;
import software.amazon.awssdk.services.ecrpublic.model.GetRegistryCatalogDataRequest;
import software.amazon.awssdk.services.ecrpublic.model.GetRegistryCatalogDataResponse;
import software.amazon.awssdk.services.ecrpublic.model.GetRepositoryCatalogDataRequest;
import software.amazon.awssdk.services.ecrpublic.model.GetRepositoryCatalogDataResponse;
import software.amazon.awssdk.services.ecrpublic.model.GetRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecrpublic.model.GetRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecrpublic.model.ImageAlreadyExistsException;
import software.amazon.awssdk.services.ecrpublic.model.ImageDigestDoesNotMatchException;
import software.amazon.awssdk.services.ecrpublic.model.ImageNotFoundException;
import software.amazon.awssdk.services.ecrpublic.model.ImageTagAlreadyExistsException;
import software.amazon.awssdk.services.ecrpublic.model.InitiateLayerUploadRequest;
import software.amazon.awssdk.services.ecrpublic.model.InitiateLayerUploadResponse;
import software.amazon.awssdk.services.ecrpublic.model.InvalidLayerException;
import software.amazon.awssdk.services.ecrpublic.model.InvalidLayerPartException;
import software.amazon.awssdk.services.ecrpublic.model.InvalidParameterException;
import software.amazon.awssdk.services.ecrpublic.model.InvalidTagParameterException;
import software.amazon.awssdk.services.ecrpublic.model.LayerAlreadyExistsException;
import software.amazon.awssdk.services.ecrpublic.model.LayerPartTooSmallException;
import software.amazon.awssdk.services.ecrpublic.model.LayersNotFoundException;
import software.amazon.awssdk.services.ecrpublic.model.LimitExceededException;
import software.amazon.awssdk.services.ecrpublic.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ecrpublic.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ecrpublic.model.PutImageRequest;
import software.amazon.awssdk.services.ecrpublic.model.PutImageResponse;
import software.amazon.awssdk.services.ecrpublic.model.PutRegistryCatalogDataRequest;
import software.amazon.awssdk.services.ecrpublic.model.PutRegistryCatalogDataResponse;
import software.amazon.awssdk.services.ecrpublic.model.PutRepositoryCatalogDataRequest;
import software.amazon.awssdk.services.ecrpublic.model.PutRepositoryCatalogDataResponse;
import software.amazon.awssdk.services.ecrpublic.model.ReferencedImagesNotFoundException;
import software.amazon.awssdk.services.ecrpublic.model.RegistryNotFoundException;
import software.amazon.awssdk.services.ecrpublic.model.RepositoryAlreadyExistsException;
import software.amazon.awssdk.services.ecrpublic.model.RepositoryCatalogDataNotFoundException;
import software.amazon.awssdk.services.ecrpublic.model.RepositoryNotEmptyException;
import software.amazon.awssdk.services.ecrpublic.model.RepositoryNotFoundException;
import software.amazon.awssdk.services.ecrpublic.model.RepositoryPolicyNotFoundException;
import software.amazon.awssdk.services.ecrpublic.model.ServerException;
import software.amazon.awssdk.services.ecrpublic.model.SetRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecrpublic.model.SetRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecrpublic.model.TagResourceRequest;
import software.amazon.awssdk.services.ecrpublic.model.TagResourceResponse;
import software.amazon.awssdk.services.ecrpublic.model.TooManyTagsException;
import software.amazon.awssdk.services.ecrpublic.model.UnsupportedCommandException;
import software.amazon.awssdk.services.ecrpublic.model.UntagResourceRequest;
import software.amazon.awssdk.services.ecrpublic.model.UntagResourceResponse;
import software.amazon.awssdk.services.ecrpublic.model.UploadLayerPartRequest;
import software.amazon.awssdk.services.ecrpublic.model.UploadLayerPartResponse;
import software.amazon.awssdk.services.ecrpublic.model.UploadNotFoundException;
import software.amazon.awssdk.services.ecrpublic.transform.BatchCheckLayerAvailabilityRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.BatchDeleteImageRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.CompleteLayerUploadRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.CreateRepositoryRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.DeleteRepositoryPolicyRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.DeleteRepositoryRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.DescribeImageTagsRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.DescribeImagesRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.DescribeRegistriesRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.DescribeRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.GetAuthorizationTokenRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.GetRegistryCatalogDataRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.GetRepositoryCatalogDataRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.GetRepositoryPolicyRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.InitiateLayerUploadRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.PutImageRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.PutRegistryCatalogDataRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.PutRepositoryCatalogDataRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.SetRepositoryPolicyRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.UploadLayerPartRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultEcrPublicClient
implements EcrPublicClient {
    private static final Logger log = Logger.loggerFor(DefaultEcrPublicClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultEcrPublicClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"ECR_PUBLIC#2.35.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchCheckLayerAvailabilityResponse batchCheckLayerAvailability(BatchCheckLayerAvailabilityRequest batchCheckLayerAvailabilityRequest) throws RepositoryNotFoundException, InvalidParameterException, ServerException, RegistryNotFoundException, UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchCheckLayerAvailabilityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnsupportedCommandException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "LayerPartTooSmallException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                }
                case "InvalidLayerPartException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                }
                case "ImageTagAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "RepositoryNotEmptyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                }
                case "LayerAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                }
                case "ImageDigestDoesNotMatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                }
                case "RegistryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                }
                case "EmptyUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "ImageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                }
                case "RepositoryCatalogDataNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                }
                case "LayersNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                }
                case "ReferencedImagesNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                }
                case "InvalidLayerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                }
                case "RepositoryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                }
                case "RepositoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                }
                case "RepositoryPolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                }
                case "ImageAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "UploadNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchCheckLayerAvailabilityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicClient.resolveMetricPublishers(clientConfiguration, batchCheckLayerAvailabilityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchCheckLayerAvailability");
            BatchCheckLayerAvailabilityResponse batchCheckLayerAvailabilityResponse = (BatchCheckLayerAvailabilityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchCheckLayerAvailability").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchCheckLayerAvailabilityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchCheckLayerAvailabilityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchCheckLayerAvailabilityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicClient.lambda$batchCheckLayerAvailability$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDeleteImageResponse batchDeleteImage(BatchDeleteImageRequest batchDeleteImageRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDeleteImageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnsupportedCommandException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "LayerPartTooSmallException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                }
                case "InvalidLayerPartException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                }
                case "ImageTagAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "RepositoryNotEmptyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                }
                case "LayerAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                }
                case "ImageDigestDoesNotMatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                }
                case "RegistryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                }
                case "EmptyUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "ImageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                }
                case "RepositoryCatalogDataNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                }
                case "LayersNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                }
                case "ReferencedImagesNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                }
                case "InvalidLayerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                }
                case "RepositoryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                }
                case "RepositoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                }
                case "RepositoryPolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                }
                case "ImageAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "UploadNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchDeleteImageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicClient.resolveMetricPublishers(clientConfiguration, batchDeleteImageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDeleteImage");
            BatchDeleteImageResponse batchDeleteImageResponse = (BatchDeleteImageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeleteImage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchDeleteImageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDeleteImageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDeleteImageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicClient.lambda$batchDeleteImage$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompleteLayerUploadResponse completeLayerUpload(CompleteLayerUploadRequest completeLayerUploadRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, UploadNotFoundException, InvalidLayerException, LayerPartTooSmallException, LayerAlreadyExistsException, EmptyUploadException, RegistryNotFoundException, UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CompleteLayerUploadResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnsupportedCommandException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "LayerPartTooSmallException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                }
                case "InvalidLayerPartException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                }
                case "ImageTagAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "RepositoryNotEmptyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                }
                case "LayerAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                }
                case "ImageDigestDoesNotMatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                }
                case "RegistryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                }
                case "EmptyUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "ImageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                }
                case "RepositoryCatalogDataNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                }
                case "LayersNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                }
                case "ReferencedImagesNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                }
                case "InvalidLayerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                }
                case "RepositoryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                }
                case "RepositoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                }
                case "RepositoryPolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                }
                case "ImageAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "UploadNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)completeLayerUploadRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicClient.resolveMetricPublishers(clientConfiguration, completeLayerUploadRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CompleteLayerUpload");
            CompleteLayerUploadResponse completeLayerUploadResponse = (CompleteLayerUploadResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CompleteLayerUpload").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)completeLayerUploadRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CompleteLayerUploadRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return completeLayerUploadResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicClient.lambda$completeLayerUpload$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRepositoryResponse createRepository(CreateRepositoryRequest createRepositoryRequest) throws ServerException, InvalidParameterException, InvalidTagParameterException, TooManyTagsException, RepositoryAlreadyExistsException, LimitExceededException, UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRepositoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnsupportedCommandException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "LayerPartTooSmallException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                }
                case "InvalidLayerPartException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                }
                case "ImageTagAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "RepositoryNotEmptyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                }
                case "LayerAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                }
                case "ImageDigestDoesNotMatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                }
                case "RegistryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                }
                case "EmptyUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "ImageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                }
                case "RepositoryCatalogDataNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                }
                case "LayersNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                }
                case "ReferencedImagesNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                }
                case "InvalidLayerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                }
                case "RepositoryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                }
                case "RepositoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                }
                case "RepositoryPolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                }
                case "ImageAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "UploadNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createRepositoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicClient.resolveMetricPublishers(clientConfiguration, createRepositoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRepository");
            CreateRepositoryResponse createRepositoryResponse = (CreateRepositoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRepository").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createRepositoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateRepositoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createRepositoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicClient.lambda$createRepository$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRepositoryResponse deleteRepository(DeleteRepositoryRequest deleteRepositoryRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, RepositoryNotEmptyException, UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRepositoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnsupportedCommandException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "LayerPartTooSmallException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                }
                case "InvalidLayerPartException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                }
                case "ImageTagAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "RepositoryNotEmptyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                }
                case "LayerAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                }
                case "ImageDigestDoesNotMatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                }
                case "RegistryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                }
                case "EmptyUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "ImageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                }
                case "RepositoryCatalogDataNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                }
                case "LayersNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                }
                case "ReferencedImagesNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                }
                case "InvalidLayerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                }
                case "RepositoryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                }
                case "RepositoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                }
                case "RepositoryPolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                }
                case "ImageAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "UploadNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRepositoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicClient.resolveMetricPublishers(clientConfiguration, deleteRepositoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRepository");
            DeleteRepositoryResponse deleteRepositoryResponse = (DeleteRepositoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRepository").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteRepositoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRepositoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRepositoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicClient.lambda$deleteRepository$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRepositoryPolicyResponse deleteRepositoryPolicy(DeleteRepositoryPolicyRequest deleteRepositoryPolicyRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, RepositoryPolicyNotFoundException, UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRepositoryPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnsupportedCommandException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "LayerPartTooSmallException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                }
                case "InvalidLayerPartException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                }
                case "ImageTagAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "RepositoryNotEmptyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                }
                case "LayerAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                }
                case "ImageDigestDoesNotMatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                }
                case "RegistryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                }
                case "EmptyUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "ImageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                }
                case "RepositoryCatalogDataNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                }
                case "LayersNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                }
                case "ReferencedImagesNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                }
                case "InvalidLayerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                }
                case "RepositoryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                }
                case "RepositoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                }
                case "RepositoryPolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                }
                case "ImageAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "UploadNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRepositoryPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicClient.resolveMetricPublishers(clientConfiguration, deleteRepositoryPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRepositoryPolicy");
            DeleteRepositoryPolicyResponse deleteRepositoryPolicyResponse = (DeleteRepositoryPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRepositoryPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteRepositoryPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRepositoryPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRepositoryPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicClient.lambda$deleteRepositoryPolicy$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeImageTagsResponse describeImageTags(DescribeImageTagsRequest describeImageTagsRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeImageTagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnsupportedCommandException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "LayerPartTooSmallException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                }
                case "InvalidLayerPartException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                }
                case "ImageTagAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "RepositoryNotEmptyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                }
                case "LayerAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                }
                case "ImageDigestDoesNotMatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                }
                case "RegistryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                }
                case "EmptyUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "ImageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                }
                case "RepositoryCatalogDataNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                }
                case "LayersNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                }
                case "ReferencedImagesNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                }
                case "InvalidLayerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                }
                case "RepositoryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                }
                case "RepositoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                }
                case "RepositoryPolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                }
                case "ImageAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "UploadNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeImageTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicClient.resolveMetricPublishers(clientConfiguration, describeImageTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeImageTags");
            DescribeImageTagsResponse describeImageTagsResponse = (DescribeImageTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeImageTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeImageTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeImageTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeImageTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicClient.lambda$describeImageTags$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeImagesResponse describeImages(DescribeImagesRequest describeImagesRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, ImageNotFoundException, UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeImagesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnsupportedCommandException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "LayerPartTooSmallException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                }
                case "InvalidLayerPartException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                }
                case "ImageTagAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "RepositoryNotEmptyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                }
                case "LayerAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                }
                case "ImageDigestDoesNotMatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                }
                case "RegistryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                }
                case "EmptyUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "ImageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                }
                case "RepositoryCatalogDataNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                }
                case "LayersNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                }
                case "ReferencedImagesNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                }
                case "InvalidLayerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                }
                case "RepositoryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                }
                case "RepositoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                }
                case "RepositoryPolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                }
                case "ImageAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "UploadNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeImagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicClient.resolveMetricPublishers(clientConfiguration, describeImagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeImages");
            DescribeImagesResponse describeImagesResponse = (DescribeImagesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeImages").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeImagesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeImagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeImagesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicClient.lambda$describeImages$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRegistriesResponse describeRegistries(DescribeRegistriesRequest describeRegistriesRequest) throws InvalidParameterException, UnsupportedCommandException, ServerException, AwsServiceException, SdkClientException, EcrPublicException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRegistriesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnsupportedCommandException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "LayerPartTooSmallException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                }
                case "InvalidLayerPartException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                }
                case "ImageTagAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "RepositoryNotEmptyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                }
                case "LayerAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                }
                case "ImageDigestDoesNotMatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                }
                case "RegistryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                }
                case "EmptyUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "ImageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                }
                case "RepositoryCatalogDataNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                }
                case "LayersNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                }
                case "ReferencedImagesNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                }
                case "InvalidLayerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                }
                case "RepositoryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                }
                case "RepositoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                }
                case "RepositoryPolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                }
                case "ImageAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "UploadNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeRegistriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicClient.resolveMetricPublishers(clientConfiguration, describeRegistriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRegistries");
            DescribeRegistriesResponse describeRegistriesResponse = (DescribeRegistriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRegistries").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeRegistriesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRegistriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRegistriesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicClient.lambda$describeRegistries$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRepositoriesResponse describeRepositories(DescribeRepositoriesRequest describeRepositoriesRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRepositoriesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnsupportedCommandException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "LayerPartTooSmallException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                }
                case "InvalidLayerPartException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                }
                case "ImageTagAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "RepositoryNotEmptyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                }
                case "LayerAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                }
                case "ImageDigestDoesNotMatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                }
                case "RegistryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                }
                case "EmptyUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "ImageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                }
                case "RepositoryCatalogDataNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                }
                case "LayersNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                }
                case "ReferencedImagesNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                }
                case "InvalidLayerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                }
                case "RepositoryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                }
                case "RepositoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                }
                case "RepositoryPolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                }
                case "ImageAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "UploadNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeRepositoriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicClient.resolveMetricPublishers(clientConfiguration, describeRepositoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRepositories");
            DescribeRepositoriesResponse describeRepositoriesResponse = (DescribeRepositoriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRepositories").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeRepositoriesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRepositoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRepositoriesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicClient.lambda$describeRepositories$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAuthorizationTokenResponse getAuthorizationToken(GetAuthorizationTokenRequest getAuthorizationTokenRequest) throws ServerException, InvalidParameterException, UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAuthorizationTokenResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnsupportedCommandException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "LayerPartTooSmallException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                }
                case "InvalidLayerPartException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                }
                case "ImageTagAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "RepositoryNotEmptyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                }
                case "LayerAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                }
                case "ImageDigestDoesNotMatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                }
                case "RegistryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                }
                case "EmptyUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "ImageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                }
                case "RepositoryCatalogDataNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                }
                case "LayersNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                }
                case "ReferencedImagesNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                }
                case "InvalidLayerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                }
                case "RepositoryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                }
                case "RepositoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                }
                case "RepositoryPolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                }
                case "ImageAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "UploadNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAuthorizationTokenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicClient.resolveMetricPublishers(clientConfiguration, getAuthorizationTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAuthorizationToken");
            GetAuthorizationTokenResponse getAuthorizationTokenResponse = (GetAuthorizationTokenResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAuthorizationToken").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAuthorizationTokenRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAuthorizationTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAuthorizationTokenResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicClient.lambda$getAuthorizationToken$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRegistryCatalogDataResponse getRegistryCatalogData(GetRegistryCatalogDataRequest getRegistryCatalogDataRequest) throws ServerException, UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRegistryCatalogDataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnsupportedCommandException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "LayerPartTooSmallException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                }
                case "InvalidLayerPartException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                }
                case "ImageTagAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "RepositoryNotEmptyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                }
                case "LayerAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                }
                case "ImageDigestDoesNotMatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                }
                case "RegistryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                }
                case "EmptyUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "ImageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                }
                case "RepositoryCatalogDataNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                }
                case "LayersNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                }
                case "ReferencedImagesNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                }
                case "InvalidLayerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                }
                case "RepositoryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                }
                case "RepositoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                }
                case "RepositoryPolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                }
                case "ImageAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "UploadNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRegistryCatalogDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicClient.resolveMetricPublishers(clientConfiguration, getRegistryCatalogDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRegistryCatalogData");
            GetRegistryCatalogDataResponse getRegistryCatalogDataResponse = (GetRegistryCatalogDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRegistryCatalogData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getRegistryCatalogDataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRegistryCatalogDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRegistryCatalogDataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicClient.lambda$getRegistryCatalogData$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRepositoryCatalogDataResponse getRepositoryCatalogData(GetRepositoryCatalogDataRequest getRepositoryCatalogDataRequest) throws ServerException, InvalidParameterException, RepositoryCatalogDataNotFoundException, RepositoryNotFoundException, UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRepositoryCatalogDataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnsupportedCommandException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "LayerPartTooSmallException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                }
                case "InvalidLayerPartException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                }
                case "ImageTagAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "RepositoryNotEmptyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                }
                case "LayerAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                }
                case "ImageDigestDoesNotMatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                }
                case "RegistryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                }
                case "EmptyUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "ImageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                }
                case "RepositoryCatalogDataNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                }
                case "LayersNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                }
                case "ReferencedImagesNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                }
                case "InvalidLayerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                }
                case "RepositoryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                }
                case "RepositoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                }
                case "RepositoryPolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                }
                case "ImageAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "UploadNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRepositoryCatalogDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicClient.resolveMetricPublishers(clientConfiguration, getRepositoryCatalogDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRepositoryCatalogData");
            GetRepositoryCatalogDataResponse getRepositoryCatalogDataResponse = (GetRepositoryCatalogDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRepositoryCatalogData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getRepositoryCatalogDataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRepositoryCatalogDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRepositoryCatalogDataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicClient.lambda$getRepositoryCatalogData$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRepositoryPolicyResponse getRepositoryPolicy(GetRepositoryPolicyRequest getRepositoryPolicyRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, RepositoryPolicyNotFoundException, UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRepositoryPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnsupportedCommandException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "LayerPartTooSmallException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                }
                case "InvalidLayerPartException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                }
                case "ImageTagAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "RepositoryNotEmptyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                }
                case "LayerAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                }
                case "ImageDigestDoesNotMatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                }
                case "RegistryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                }
                case "EmptyUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "ImageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                }
                case "RepositoryCatalogDataNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                }
                case "LayersNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                }
                case "ReferencedImagesNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                }
                case "InvalidLayerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                }
                case "RepositoryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                }
                case "RepositoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                }
                case "RepositoryPolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                }
                case "ImageAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "UploadNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRepositoryPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicClient.resolveMetricPublishers(clientConfiguration, getRepositoryPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRepositoryPolicy");
            GetRepositoryPolicyResponse getRepositoryPolicyResponse = (GetRepositoryPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRepositoryPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getRepositoryPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRepositoryPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRepositoryPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicClient.lambda$getRepositoryPolicy$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InitiateLayerUploadResponse initiateLayerUpload(InitiateLayerUploadRequest initiateLayerUploadRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, RegistryNotFoundException, UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InitiateLayerUploadResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnsupportedCommandException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "LayerPartTooSmallException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                }
                case "InvalidLayerPartException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                }
                case "ImageTagAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "RepositoryNotEmptyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                }
                case "LayerAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                }
                case "ImageDigestDoesNotMatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                }
                case "RegistryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                }
                case "EmptyUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "ImageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                }
                case "RepositoryCatalogDataNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                }
                case "LayersNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                }
                case "ReferencedImagesNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                }
                case "InvalidLayerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                }
                case "RepositoryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                }
                case "RepositoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                }
                case "RepositoryPolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                }
                case "ImageAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "UploadNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)initiateLayerUploadRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicClient.resolveMetricPublishers(clientConfiguration, initiateLayerUploadRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"InitiateLayerUpload");
            InitiateLayerUploadResponse initiateLayerUploadResponse = (InitiateLayerUploadResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("InitiateLayerUpload").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)initiateLayerUploadRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new InitiateLayerUploadRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return initiateLayerUploadResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicClient.lambda$initiateLayerUpload$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InvalidParameterException, RepositoryNotFoundException, UnsupportedCommandException, ServerException, AwsServiceException, SdkClientException, EcrPublicException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnsupportedCommandException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "LayerPartTooSmallException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                }
                case "InvalidLayerPartException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                }
                case "ImageTagAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "RepositoryNotEmptyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                }
                case "LayerAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                }
                case "ImageDigestDoesNotMatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                }
                case "RegistryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                }
                case "EmptyUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "ImageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                }
                case "RepositoryCatalogDataNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                }
                case "LayersNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                }
                case "ReferencedImagesNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                }
                case "InvalidLayerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                }
                case "RepositoryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                }
                case "RepositoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                }
                case "RepositoryPolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                }
                case "ImageAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "UploadNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicClient.lambda$listTagsForResource$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutImageResponse putImage(PutImageRequest putImageRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, ImageAlreadyExistsException, LayersNotFoundException, ReferencedImagesNotFoundException, LimitExceededException, ImageTagAlreadyExistsException, ImageDigestDoesNotMatchException, RegistryNotFoundException, UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutImageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnsupportedCommandException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "LayerPartTooSmallException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                }
                case "InvalidLayerPartException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                }
                case "ImageTagAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "RepositoryNotEmptyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                }
                case "LayerAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                }
                case "ImageDigestDoesNotMatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                }
                case "RegistryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                }
                case "EmptyUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "ImageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                }
                case "RepositoryCatalogDataNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                }
                case "LayersNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                }
                case "ReferencedImagesNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                }
                case "InvalidLayerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                }
                case "RepositoryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                }
                case "RepositoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                }
                case "RepositoryPolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                }
                case "ImageAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "UploadNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putImageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicClient.resolveMetricPublishers(clientConfiguration, putImageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutImage");
            PutImageResponse putImageResponse = (PutImageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutImage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putImageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutImageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putImageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicClient.lambda$putImage$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutRegistryCatalogDataResponse putRegistryCatalogData(PutRegistryCatalogDataRequest putRegistryCatalogDataRequest) throws ServerException, InvalidParameterException, UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutRegistryCatalogDataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnsupportedCommandException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "LayerPartTooSmallException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                }
                case "InvalidLayerPartException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                }
                case "ImageTagAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "RepositoryNotEmptyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                }
                case "LayerAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                }
                case "ImageDigestDoesNotMatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                }
                case "RegistryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                }
                case "EmptyUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "ImageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                }
                case "RepositoryCatalogDataNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                }
                case "LayersNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                }
                case "ReferencedImagesNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                }
                case "InvalidLayerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                }
                case "RepositoryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                }
                case "RepositoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                }
                case "RepositoryPolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                }
                case "ImageAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "UploadNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putRegistryCatalogDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicClient.resolveMetricPublishers(clientConfiguration, putRegistryCatalogDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutRegistryCatalogData");
            PutRegistryCatalogDataResponse putRegistryCatalogDataResponse = (PutRegistryCatalogDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutRegistryCatalogData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putRegistryCatalogDataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutRegistryCatalogDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putRegistryCatalogDataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicClient.lambda$putRegistryCatalogData$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutRepositoryCatalogDataResponse putRepositoryCatalogData(PutRepositoryCatalogDataRequest putRepositoryCatalogDataRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutRepositoryCatalogDataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnsupportedCommandException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "LayerPartTooSmallException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                }
                case "InvalidLayerPartException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                }
                case "ImageTagAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "RepositoryNotEmptyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                }
                case "LayerAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                }
                case "ImageDigestDoesNotMatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                }
                case "RegistryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                }
                case "EmptyUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "ImageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                }
                case "RepositoryCatalogDataNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                }
                case "LayersNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                }
                case "ReferencedImagesNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                }
                case "InvalidLayerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                }
                case "RepositoryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                }
                case "RepositoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                }
                case "RepositoryPolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                }
                case "ImageAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "UploadNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putRepositoryCatalogDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicClient.resolveMetricPublishers(clientConfiguration, putRepositoryCatalogDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutRepositoryCatalogData");
            PutRepositoryCatalogDataResponse putRepositoryCatalogDataResponse = (PutRepositoryCatalogDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutRepositoryCatalogData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putRepositoryCatalogDataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutRepositoryCatalogDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putRepositoryCatalogDataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicClient.lambda$putRepositoryCatalogData$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetRepositoryPolicyResponse setRepositoryPolicy(SetRepositoryPolicyRequest setRepositoryPolicyRequest) throws ServerException, InvalidParameterException, RepositoryNotFoundException, UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetRepositoryPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnsupportedCommandException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "LayerPartTooSmallException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                }
                case "InvalidLayerPartException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                }
                case "ImageTagAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "RepositoryNotEmptyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                }
                case "LayerAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                }
                case "ImageDigestDoesNotMatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                }
                case "RegistryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                }
                case "EmptyUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "ImageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                }
                case "RepositoryCatalogDataNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                }
                case "LayersNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                }
                case "ReferencedImagesNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                }
                case "InvalidLayerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                }
                case "RepositoryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                }
                case "RepositoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                }
                case "RepositoryPolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                }
                case "ImageAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "UploadNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setRepositoryPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicClient.resolveMetricPublishers(clientConfiguration, setRepositoryPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetRepositoryPolicy");
            SetRepositoryPolicyResponse setRepositoryPolicyResponse = (SetRepositoryPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetRepositoryPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)setRepositoryPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetRepositoryPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return setRepositoryPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicClient.lambda$setRepositoryPolicy$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidParameterException, InvalidTagParameterException, TooManyTagsException, RepositoryNotFoundException, UnsupportedCommandException, ServerException, AwsServiceException, SdkClientException, EcrPublicException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnsupportedCommandException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "LayerPartTooSmallException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                }
                case "InvalidLayerPartException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                }
                case "ImageTagAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "RepositoryNotEmptyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                }
                case "LayerAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                }
                case "ImageDigestDoesNotMatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                }
                case "RegistryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                }
                case "EmptyUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "ImageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                }
                case "RepositoryCatalogDataNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                }
                case "LayersNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                }
                case "ReferencedImagesNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                }
                case "InvalidLayerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                }
                case "RepositoryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                }
                case "RepositoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                }
                case "RepositoryPolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                }
                case "ImageAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "UploadNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicClient.lambda$tagResource$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidParameterException, InvalidTagParameterException, TooManyTagsException, RepositoryNotFoundException, UnsupportedCommandException, ServerException, AwsServiceException, SdkClientException, EcrPublicException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnsupportedCommandException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "LayerPartTooSmallException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                }
                case "InvalidLayerPartException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                }
                case "ImageTagAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "RepositoryNotEmptyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                }
                case "LayerAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                }
                case "ImageDigestDoesNotMatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                }
                case "RegistryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                }
                case "EmptyUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "ImageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                }
                case "RepositoryCatalogDataNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                }
                case "LayersNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                }
                case "ReferencedImagesNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                }
                case "InvalidLayerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                }
                case "RepositoryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                }
                case "RepositoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                }
                case "RepositoryPolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                }
                case "ImageAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "UploadNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicClient.lambda$untagResource$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadLayerPartResponse uploadLayerPart(UploadLayerPartRequest uploadLayerPartRequest) throws ServerException, InvalidParameterException, InvalidLayerPartException, RepositoryNotFoundException, UploadNotFoundException, LimitExceededException, RegistryNotFoundException, UnsupportedCommandException, AwsServiceException, SdkClientException, EcrPublicException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UploadLayerPartResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "UnsupportedCommandException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedCommandException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "LayerPartTooSmallException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerPartTooSmallException::builder).build());
                }
                case "InvalidLayerPartException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerPartException::builder).build());
                }
                case "ImageTagAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerException::builder).build());
                }
                case "RepositoryNotEmptyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotEmptyException::builder).build());
                }
                case "LayerAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayerAlreadyExistsException::builder).build());
                }
                case "ImageDigestDoesNotMatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).build());
                }
                case "RegistryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RegistryNotFoundException::builder).build());
                }
                case "EmptyUploadException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmptyUploadException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EmptyUploadException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "ImageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageNotFoundException::builder).build());
                }
                case "RepositoryCatalogDataNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).build());
                }
                case "LayersNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LayersNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LayersNotFoundException::builder).build());
                }
                case "ReferencedImagesNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).build());
                }
                case "InvalidLayerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLayerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLayerException::builder).build());
                }
                case "RepositoryNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryNotFoundException::builder).build());
                }
                case "RepositoryAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).build());
                }
                case "RepositoryPolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).build());
                }
                case "ImageAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImageAlreadyExistsException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "UploadNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UploadNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UploadNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)uploadLayerPartRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEcrPublicClient.resolveMetricPublishers(clientConfiguration, uploadLayerPartRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UploadLayerPart");
            UploadLayerPartResponse uploadLayerPartResponse = (UploadLayerPartResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UploadLayerPart").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)uploadLayerPartRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UploadLayerPartRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return uploadLayerPartResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicClient.lambda$uploadLayerPart$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "ecr-public";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        EcrPublicServiceClientConfigurationBuilder serviceConfigBuilder = new EcrPublicServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(EcrPublicException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final EcrPublicServiceClientConfiguration serviceClientConfiguration() {
        return new EcrPublicServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$uploadLayerPart$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setRepositoryPolicy$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putRepositoryCatalogData$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putRegistryCatalogData$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putImage$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$initiateLayerUpload$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRepositoryPolicy$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRepositoryCatalogData$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRegistryCatalogData$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAuthorizationToken$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRepositories$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRegistries$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeImages$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeImageTags$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRepositoryPolicy$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRepository$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRepository$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$completeLayerUpload$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDeleteImage$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchCheckLayerAvailability$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

