/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DiscoverPollEndpointResponse extends EcsResponse implements
        ToCopyableBuilder<DiscoverPollEndpointResponse.Builder, DiscoverPollEndpointResponse> {
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpoint").getter(getter(DiscoverPollEndpointResponse::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()).build();

    private static final SdkField<String> TELEMETRY_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("telemetryEndpoint").getter(getter(DiscoverPollEndpointResponse::telemetryEndpoint))
            .setter(setter(Builder::telemetryEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("telemetryEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_FIELD,
            TELEMETRY_ENDPOINT_FIELD));

    private final String endpoint;

    private final String telemetryEndpoint;

    private DiscoverPollEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.endpoint = builder.endpoint;
        this.telemetryEndpoint = builder.telemetryEndpoint;
    }

    /**
     * <p>
     * The endpoint for the Amazon ECS agent to poll.
     * </p>
     * 
     * @return The endpoint for the Amazon ECS agent to poll.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The telemetry endpoint for the Amazon ECS agent.
     * </p>
     * 
     * @return The telemetry endpoint for the Amazon ECS agent.
     */
    public final String telemetryEndpoint() {
        return telemetryEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(telemetryEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoverPollEndpointResponse)) {
            return false;
        }
        DiscoverPollEndpointResponse other = (DiscoverPollEndpointResponse) obj;
        return Objects.equals(endpoint(), other.endpoint()) && Objects.equals(telemetryEndpoint(), other.telemetryEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DiscoverPollEndpointResponse").add("Endpoint", endpoint())
                .add("TelemetryEndpoint", telemetryEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "telemetryEndpoint":
            return Optional.ofNullable(clazz.cast(telemetryEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DiscoverPollEndpointResponse, T> g) {
        return obj -> g.apply((DiscoverPollEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DiscoverPollEndpointResponse> {
        /**
         * <p>
         * The endpoint for the Amazon ECS agent to poll.
         * </p>
         * 
         * @param endpoint
         *        The endpoint for the Amazon ECS agent to poll.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * The telemetry endpoint for the Amazon ECS agent.
         * </p>
         * 
         * @param telemetryEndpoint
         *        The telemetry endpoint for the Amazon ECS agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder telemetryEndpoint(String telemetryEndpoint);
    }

    static final class BuilderImpl extends EcsResponse.BuilderImpl implements Builder {
        private String endpoint;

        private String telemetryEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoverPollEndpointResponse model) {
            super(model);
            endpoint(model.endpoint);
            telemetryEndpoint(model.telemetryEndpoint);
        }

        public final String getEndpoint() {
            return endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getTelemetryEndpoint() {
            return telemetryEndpoint;
        }

        @Override
        public final Builder telemetryEndpoint(String telemetryEndpoint) {
            this.telemetryEndpoint = telemetryEndpoint;
            return this;
        }

        public final void setTelemetryEndpoint(String telemetryEndpoint) {
            this.telemetryEndpoint = telemetryEndpoint;
        }

        @Override
        public DiscoverPollEndpointResponse build() {
            return new DiscoverPollEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
