/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.ContainerOverride;
import software.amazon.awssdk.services.ecs.model.ContainerOverridesCopier;
import software.amazon.awssdk.services.ecs.model.EphemeralStorage;
import software.amazon.awssdk.services.ecs.model.InferenceAcceleratorOverride;
import software.amazon.awssdk.services.ecs.model.InferenceAcceleratorOverridesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskOverride
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskOverride> {
    private static final SdkField<List<ContainerOverride>> CONTAINER_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("containerOverrides").getter(TaskOverride.getter(TaskOverride::containerOverrides)).setter(TaskOverride.setter(Builder::containerOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerOverrides").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CPU_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cpu").getter(TaskOverride.getter(TaskOverride::cpu)).setter(TaskOverride.setter(Builder::cpu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpu").build()}).build();
    private static final SdkField<List<InferenceAcceleratorOverride>> INFERENCE_ACCELERATOR_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inferenceAcceleratorOverrides").getter(TaskOverride.getter(TaskOverride::inferenceAcceleratorOverrides)).setter(TaskOverride.setter(Builder::inferenceAcceleratorOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceAcceleratorOverrides").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InferenceAcceleratorOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRoleArn").getter(TaskOverride.getter(TaskOverride::executionRoleArn)).setter(TaskOverride.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()}).build();
    private static final SdkField<String> MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memory").getter(TaskOverride.getter(TaskOverride::memory)).setter(TaskOverride.setter(Builder::memory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()}).build();
    private static final SdkField<String> TASK_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskRoleArn").getter(TaskOverride.getter(TaskOverride::taskRoleArn)).setter(TaskOverride.setter(Builder::taskRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRoleArn").build()}).build();
    private static final SdkField<EphemeralStorage> EPHEMERAL_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ephemeralStorage").getter(TaskOverride.getter(TaskOverride::ephemeralStorage)).setter(TaskOverride.setter(Builder::ephemeralStorage)).constructor(EphemeralStorage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ephemeralStorage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_OVERRIDES_FIELD, CPU_FIELD, INFERENCE_ACCELERATOR_OVERRIDES_FIELD, EXECUTION_ROLE_ARN_FIELD, MEMORY_FIELD, TASK_ROLE_ARN_FIELD, EPHEMERAL_STORAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ContainerOverride> containerOverrides;
    private final String cpu;
    private final List<InferenceAcceleratorOverride> inferenceAcceleratorOverrides;
    private final String executionRoleArn;
    private final String memory;
    private final String taskRoleArn;
    private final EphemeralStorage ephemeralStorage;

    private TaskOverride(BuilderImpl builder) {
        this.containerOverrides = builder.containerOverrides;
        this.cpu = builder.cpu;
        this.inferenceAcceleratorOverrides = builder.inferenceAcceleratorOverrides;
        this.executionRoleArn = builder.executionRoleArn;
        this.memory = builder.memory;
        this.taskRoleArn = builder.taskRoleArn;
        this.ephemeralStorage = builder.ephemeralStorage;
    }

    public final boolean hasContainerOverrides() {
        return this.containerOverrides != null && !(this.containerOverrides instanceof SdkAutoConstructList);
    }

    public final List<ContainerOverride> containerOverrides() {
        return this.containerOverrides;
    }

    public final String cpu() {
        return this.cpu;
    }

    public final boolean hasInferenceAcceleratorOverrides() {
        return this.inferenceAcceleratorOverrides != null && !(this.inferenceAcceleratorOverrides instanceof SdkAutoConstructList);
    }

    public final List<InferenceAcceleratorOverride> inferenceAcceleratorOverrides() {
        return this.inferenceAcceleratorOverrides;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final String memory() {
        return this.memory;
    }

    public final String taskRoleArn() {
        return this.taskRoleArn;
    }

    public final EphemeralStorage ephemeralStorage() {
        return this.ephemeralStorage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerOverrides() ? this.containerOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cpu());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInferenceAcceleratorOverrides() ? this.inferenceAcceleratorOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.memory());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ephemeralStorage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskOverride)) {
            return false;
        }
        TaskOverride other = (TaskOverride)obj;
        return this.hasContainerOverrides() == other.hasContainerOverrides() && Objects.equals(this.containerOverrides(), other.containerOverrides()) && Objects.equals(this.cpu(), other.cpu()) && this.hasInferenceAcceleratorOverrides() == other.hasInferenceAcceleratorOverrides() && Objects.equals(this.inferenceAcceleratorOverrides(), other.inferenceAcceleratorOverrides()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.memory(), other.memory()) && Objects.equals(this.taskRoleArn(), other.taskRoleArn()) && Objects.equals(this.ephemeralStorage(), other.ephemeralStorage());
    }

    public final String toString() {
        return ToString.builder((String)"TaskOverride").add("ContainerOverrides", this.hasContainerOverrides() ? this.containerOverrides() : null).add("Cpu", (Object)this.cpu()).add("InferenceAcceleratorOverrides", this.hasInferenceAcceleratorOverrides() ? this.inferenceAcceleratorOverrides() : null).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("Memory", (Object)this.memory()).add("TaskRoleArn", (Object)this.taskRoleArn()).add("EphemeralStorage", (Object)this.ephemeralStorage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containerOverrides": {
                return Optional.ofNullable(clazz.cast(this.containerOverrides()));
            }
            case "cpu": {
                return Optional.ofNullable(clazz.cast(this.cpu()));
            }
            case "inferenceAcceleratorOverrides": {
                return Optional.ofNullable(clazz.cast(this.inferenceAcceleratorOverrides()));
            }
            case "executionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "memory": {
                return Optional.ofNullable(clazz.cast(this.memory()));
            }
            case "taskRoleArn": {
                return Optional.ofNullable(clazz.cast(this.taskRoleArn()));
            }
            case "ephemeralStorage": {
                return Optional.ofNullable(clazz.cast(this.ephemeralStorage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskOverride, T> g) {
        return obj -> g.apply((TaskOverride)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ContainerOverride> containerOverrides = DefaultSdkAutoConstructList.getInstance();
        private String cpu;
        private List<InferenceAcceleratorOverride> inferenceAcceleratorOverrides = DefaultSdkAutoConstructList.getInstance();
        private String executionRoleArn;
        private String memory;
        private String taskRoleArn;
        private EphemeralStorage ephemeralStorage;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskOverride model) {
            this.containerOverrides(model.containerOverrides);
            this.cpu(model.cpu);
            this.inferenceAcceleratorOverrides(model.inferenceAcceleratorOverrides);
            this.executionRoleArn(model.executionRoleArn);
            this.memory(model.memory);
            this.taskRoleArn(model.taskRoleArn);
            this.ephemeralStorage(model.ephemeralStorage);
        }

        public final List<ContainerOverride.Builder> getContainerOverrides() {
            List<ContainerOverride.Builder> result = ContainerOverridesCopier.copyToBuilder(this.containerOverrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder containerOverrides(Collection<ContainerOverride> containerOverrides) {
            this.containerOverrides = ContainerOverridesCopier.copy(containerOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerOverrides(ContainerOverride ... containerOverrides) {
            this.containerOverrides(Arrays.asList(containerOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerOverrides(Consumer<ContainerOverride.Builder> ... containerOverrides) {
            this.containerOverrides(Stream.of(containerOverrides).map(c -> (ContainerOverride)((ContainerOverride.Builder)ContainerOverride.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setContainerOverrides(Collection<ContainerOverride.BuilderImpl> containerOverrides) {
            this.containerOverrides = ContainerOverridesCopier.copyFromBuilder(containerOverrides);
        }

        public final String getCpu() {
            return this.cpu;
        }

        @Override
        public final Builder cpu(String cpu) {
            this.cpu = cpu;
            return this;
        }

        public final void setCpu(String cpu) {
            this.cpu = cpu;
        }

        public final List<InferenceAcceleratorOverride.Builder> getInferenceAcceleratorOverrides() {
            List<InferenceAcceleratorOverride.Builder> result = InferenceAcceleratorOverridesCopier.copyToBuilder(this.inferenceAcceleratorOverrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder inferenceAcceleratorOverrides(Collection<InferenceAcceleratorOverride> inferenceAcceleratorOverrides) {
            this.inferenceAcceleratorOverrides = InferenceAcceleratorOverridesCopier.copy(inferenceAcceleratorOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceAcceleratorOverrides(InferenceAcceleratorOverride ... inferenceAcceleratorOverrides) {
            this.inferenceAcceleratorOverrides(Arrays.asList(inferenceAcceleratorOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceAcceleratorOverrides(Consumer<InferenceAcceleratorOverride.Builder> ... inferenceAcceleratorOverrides) {
            this.inferenceAcceleratorOverrides(Stream.of(inferenceAcceleratorOverrides).map(c -> (InferenceAcceleratorOverride)((InferenceAcceleratorOverride.Builder)InferenceAcceleratorOverride.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInferenceAcceleratorOverrides(Collection<InferenceAcceleratorOverride.BuilderImpl> inferenceAcceleratorOverrides) {
            this.inferenceAcceleratorOverrides = InferenceAcceleratorOverridesCopier.copyFromBuilder(inferenceAcceleratorOverrides);
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        public final String getMemory() {
            return this.memory;
        }

        @Override
        public final Builder memory(String memory) {
            this.memory = memory;
            return this;
        }

        public final void setMemory(String memory) {
            this.memory = memory;
        }

        public final String getTaskRoleArn() {
            return this.taskRoleArn;
        }

        @Override
        public final Builder taskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
            return this;
        }

        public final void setTaskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
        }

        public final EphemeralStorage.Builder getEphemeralStorage() {
            return this.ephemeralStorage != null ? this.ephemeralStorage.toBuilder() : null;
        }

        @Override
        public final Builder ephemeralStorage(EphemeralStorage ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
            return this;
        }

        public final void setEphemeralStorage(EphemeralStorage.BuilderImpl ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage != null ? ephemeralStorage.build() : null;
        }

        public TaskOverride build() {
            return new TaskOverride(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskOverride> {
        public Builder containerOverrides(Collection<ContainerOverride> var1);

        public Builder containerOverrides(ContainerOverride ... var1);

        public Builder containerOverrides(Consumer<ContainerOverride.Builder> ... var1);

        public Builder cpu(String var1);

        public Builder inferenceAcceleratorOverrides(Collection<InferenceAcceleratorOverride> var1);

        public Builder inferenceAcceleratorOverrides(InferenceAcceleratorOverride ... var1);

        public Builder inferenceAcceleratorOverrides(Consumer<InferenceAcceleratorOverride.Builder> ... var1);

        public Builder executionRoleArn(String var1);

        public Builder memory(String var1);

        public Builder taskRoleArn(String var1);

        public Builder ephemeralStorage(EphemeralStorage var1);

        default public Builder ephemeralStorage(Consumer<EphemeralStorage.Builder> ephemeralStorage) {
            return this.ephemeralStorage((EphemeralStorage)((EphemeralStorage.Builder)EphemeralStorage.builder().applyMutation(ephemeralStorage)).build());
        }
    }
}

