/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTasksRequest extends EcsRequest implements ToCopyableBuilder<ListTasksRequest.Builder, ListTasksRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cluster")
            .getter(getter(ListTasksRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<String> CONTAINER_INSTANCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("containerInstance").getter(getter(ListTasksRequest::containerInstance))
            .setter(setter(Builder::containerInstance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerInstance").build()).build();

    private static final SdkField<String> FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("family")
            .getter(getter(ListTasksRequest::family)).setter(setter(Builder::family))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("family").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTasksRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListTasksRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> STARTED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startedBy").getter(getter(ListTasksRequest::startedBy)).setter(setter(Builder::startedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedBy").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceName").getter(getter(ListTasksRequest::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final SdkField<String> DESIRED_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("desiredStatus").getter(getter(ListTasksRequest::desiredStatusAsString))
            .setter(setter(Builder::desiredStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredStatus").build()).build();

    private static final SdkField<String> LAUNCH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchType").getter(getter(ListTasksRequest::launchTypeAsString)).setter(setter(Builder::launchType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD,
            CONTAINER_INSTANCE_FIELD, FAMILY_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, STARTED_BY_FIELD, SERVICE_NAME_FIELD,
            DESIRED_STATUS_FIELD, LAUNCH_TYPE_FIELD));

    private final String cluster;

    private final String containerInstance;

    private final String family;

    private final String nextToken;

    private final Integer maxResults;

    private final String startedBy;

    private final String serviceName;

    private final String desiredStatus;

    private final String launchType;

    private ListTasksRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.containerInstance = builder.containerInstance;
        this.family = builder.family;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.startedBy = builder.startedBy;
        this.serviceName = builder.serviceName;
        this.desiredStatus = builder.desiredStatus;
        this.launchType = builder.launchType;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the cluster to use when filtering the <code>ListTasks</code>
     * results. If you do not specify a cluster, the default cluster is assumed.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the cluster to use when filtering the
     *         <code>ListTasks</code> results. If you do not specify a cluster, the default cluster is assumed.
     */
    public final String cluster() {
        return cluster;
    }

    /**
     * <p>
     * The container instance ID or full ARN of the container instance to use when filtering the <code>ListTasks</code>
     * results. Specifying a <code>containerInstance</code> limits the results to tasks that belong to that container
     * instance.
     * </p>
     * 
     * @return The container instance ID or full ARN of the container instance to use when filtering the
     *         <code>ListTasks</code> results. Specifying a <code>containerInstance</code> limits the results to tasks
     *         that belong to that container instance.
     */
    public final String containerInstance() {
        return containerInstance;
    }

    /**
     * <p>
     * The name of the task definition family to use when filtering the <code>ListTasks</code> results. Specifying a
     * <code>family</code> limits the results to tasks that belong to that family.
     * </p>
     * 
     * @return The name of the task definition family to use when filtering the <code>ListTasks</code> results.
     *         Specifying a <code>family</code> limits the results to tasks that belong to that family.
     */
    public final String family() {
        return family;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a <code>ListTasks</code> request indicating that more results are
     * available to fulfill the request and further calls will be needed. If <code>maxResults</code> was provided, it's
     * possible the number of results to be fewer than <code>maxResults</code>.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a <code>ListTasks</code> request indicating that more
     *         results are available to fulfill the request and further calls will be needed. If <code>maxResults</code>
     *         was provided, it's possible the number of results to be fewer than <code>maxResults</code>.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is only used to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of task results that <code>ListTasks</code> returned in paginated output. When this parameter
     * is used, <code>ListTasks</code> only returns <code>maxResults</code> results in a single page along with a
     * <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending
     * another <code>ListTasks</code> request with the returned <code>nextToken</code> value. This value can be between
     * 1 and 100. If this parameter isn't used, then <code>ListTasks</code> returns up to 100 results and a
     * <code>nextToken</code> value if applicable.
     * </p>
     * 
     * @return The maximum number of task results that <code>ListTasks</code> returned in paginated output. When this
     *         parameter is used, <code>ListTasks</code> only returns <code>maxResults</code> results in a single page
     *         along with a <code>nextToken</code> response element. The remaining results of the initial request can be
     *         seen by sending another <code>ListTasks</code> request with the returned <code>nextToken</code> value.
     *         This value can be between 1 and 100. If this parameter isn't used, then <code>ListTasks</code> returns up
     *         to 100 results and a <code>nextToken</code> value if applicable.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The <code>startedBy</code> value to filter the task results with. Specifying a <code>startedBy</code> value
     * limits the results to tasks that were started with that value.
     * </p>
     * 
     * @return The <code>startedBy</code> value to filter the task results with. Specifying a <code>startedBy</code>
     *         value limits the results to tasks that were started with that value.
     */
    public final String startedBy() {
        return startedBy;
    }

    /**
     * <p>
     * The name of the service to use when filtering the <code>ListTasks</code> results. Specifying a
     * <code>serviceName</code> limits the results to tasks that belong to that service.
     * </p>
     * 
     * @return The name of the service to use when filtering the <code>ListTasks</code> results. Specifying a
     *         <code>serviceName</code> limits the results to tasks that belong to that service.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The task desired status to use when filtering the <code>ListTasks</code> results. Specifying a
     * <code>desiredStatus</code> of <code>STOPPED</code> limits the results to tasks that Amazon ECS has set the
     * desired status to <code>STOPPED</code>. This can be useful for debugging tasks that aren't starting properly or
     * have died or finished. The default status filter is <code>RUNNING</code>, which shows tasks that Amazon ECS has
     * set the desired status to <code>RUNNING</code>.
     * </p>
     * <note>
     * <p>
     * Although you can filter results based on a desired status of <code>PENDING</code>, this doesn't return any
     * results. Amazon ECS never sets the desired status of a task to that value (only a task's <code>lastStatus</code>
     * may have a value of <code>PENDING</code>).
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desiredStatus}
     * will return {@link DesiredStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #desiredStatusAsString}.
     * </p>
     * 
     * @return The task desired status to use when filtering the <code>ListTasks</code> results. Specifying a
     *         <code>desiredStatus</code> of <code>STOPPED</code> limits the results to tasks that Amazon ECS has set
     *         the desired status to <code>STOPPED</code>. This can be useful for debugging tasks that aren't starting
     *         properly or have died or finished. The default status filter is <code>RUNNING</code>, which shows tasks
     *         that Amazon ECS has set the desired status to <code>RUNNING</code>.</p> <note>
     *         <p>
     *         Although you can filter results based on a desired status of <code>PENDING</code>, this doesn't return
     *         any results. Amazon ECS never sets the desired status of a task to that value (only a task's
     *         <code>lastStatus</code> may have a value of <code>PENDING</code>).
     *         </p>
     * @see DesiredStatus
     */
    public final DesiredStatus desiredStatus() {
        return DesiredStatus.fromValue(desiredStatus);
    }

    /**
     * <p>
     * The task desired status to use when filtering the <code>ListTasks</code> results. Specifying a
     * <code>desiredStatus</code> of <code>STOPPED</code> limits the results to tasks that Amazon ECS has set the
     * desired status to <code>STOPPED</code>. This can be useful for debugging tasks that aren't starting properly or
     * have died or finished. The default status filter is <code>RUNNING</code>, which shows tasks that Amazon ECS has
     * set the desired status to <code>RUNNING</code>.
     * </p>
     * <note>
     * <p>
     * Although you can filter results based on a desired status of <code>PENDING</code>, this doesn't return any
     * results. Amazon ECS never sets the desired status of a task to that value (only a task's <code>lastStatus</code>
     * may have a value of <code>PENDING</code>).
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desiredStatus}
     * will return {@link DesiredStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #desiredStatusAsString}.
     * </p>
     * 
     * @return The task desired status to use when filtering the <code>ListTasks</code> results. Specifying a
     *         <code>desiredStatus</code> of <code>STOPPED</code> limits the results to tasks that Amazon ECS has set
     *         the desired status to <code>STOPPED</code>. This can be useful for debugging tasks that aren't starting
     *         properly or have died or finished. The default status filter is <code>RUNNING</code>, which shows tasks
     *         that Amazon ECS has set the desired status to <code>RUNNING</code>.</p> <note>
     *         <p>
     *         Although you can filter results based on a desired status of <code>PENDING</code>, this doesn't return
     *         any results. Amazon ECS never sets the desired status of a task to that value (only a task's
     *         <code>lastStatus</code> may have a value of <code>PENDING</code>).
     *         </p>
     * @see DesiredStatus
     */
    public final String desiredStatusAsString() {
        return desiredStatus;
    }

    /**
     * <p>
     * The launch type to use when filtering the <code>ListTasks</code> results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchType} will
     * return {@link LaunchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #launchTypeAsString}.
     * </p>
     * 
     * @return The launch type to use when filtering the <code>ListTasks</code> results.
     * @see LaunchType
     */
    public final LaunchType launchType() {
        return LaunchType.fromValue(launchType);
    }

    /**
     * <p>
     * The launch type to use when filtering the <code>ListTasks</code> results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchType} will
     * return {@link LaunchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #launchTypeAsString}.
     * </p>
     * 
     * @return The launch type to use when filtering the <code>ListTasks</code> results.
     * @see LaunchType
     */
    public final String launchTypeAsString() {
        return launchType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(containerInstance());
        hashCode = 31 * hashCode + Objects.hashCode(family());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(startedBy());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(desiredStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(launchTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTasksRequest)) {
            return false;
        }
        ListTasksRequest other = (ListTasksRequest) obj;
        return Objects.equals(cluster(), other.cluster()) && Objects.equals(containerInstance(), other.containerInstance())
                && Objects.equals(family(), other.family()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(startedBy(), other.startedBy())
                && Objects.equals(serviceName(), other.serviceName())
                && Objects.equals(desiredStatusAsString(), other.desiredStatusAsString())
                && Objects.equals(launchTypeAsString(), other.launchTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTasksRequest").add("Cluster", cluster()).add("ContainerInstance", containerInstance())
                .add("Family", family()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("StartedBy", startedBy()).add("ServiceName", serviceName()).add("DesiredStatus", desiredStatusAsString())
                .add("LaunchType", launchTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "containerInstance":
            return Optional.ofNullable(clazz.cast(containerInstance()));
        case "family":
            return Optional.ofNullable(clazz.cast(family()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "startedBy":
            return Optional.ofNullable(clazz.cast(startedBy()));
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "desiredStatus":
            return Optional.ofNullable(clazz.cast(desiredStatusAsString()));
        case "launchType":
            return Optional.ofNullable(clazz.cast(launchTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTasksRequest, T> g) {
        return obj -> g.apply((ListTasksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTasksRequest> {
        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the cluster to use when filtering the
         * <code>ListTasks</code> results. If you do not specify a cluster, the default cluster is assumed.
         * </p>
         * 
         * @param cluster
         *        The short name or full Amazon Resource Name (ARN) of the cluster to use when filtering the
         *        <code>ListTasks</code> results. If you do not specify a cluster, the default cluster is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * The container instance ID or full ARN of the container instance to use when filtering the
         * <code>ListTasks</code> results. Specifying a <code>containerInstance</code> limits the results to tasks that
         * belong to that container instance.
         * </p>
         * 
         * @param containerInstance
         *        The container instance ID or full ARN of the container instance to use when filtering the
         *        <code>ListTasks</code> results. Specifying a <code>containerInstance</code> limits the results to
         *        tasks that belong to that container instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerInstance(String containerInstance);

        /**
         * <p>
         * The name of the task definition family to use when filtering the <code>ListTasks</code> results. Specifying a
         * <code>family</code> limits the results to tasks that belong to that family.
         * </p>
         * 
         * @param family
         *        The name of the task definition family to use when filtering the <code>ListTasks</code> results.
         *        Specifying a <code>family</code> limits the results to tasks that belong to that family.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder family(String family);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a <code>ListTasks</code> request indicating that more results
         * are available to fulfill the request and further calls will be needed. If <code>maxResults</code> was
         * provided, it's possible the number of results to be fewer than <code>maxResults</code>.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a <code>ListTasks</code> request indicating that more
         *        results are available to fulfill the request and further calls will be needed. If
         *        <code>maxResults</code> was provided, it's possible the number of results to be fewer than
         *        <code>maxResults</code>.</p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that is only used to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of task results that <code>ListTasks</code> returned in paginated output. When this
         * parameter is used, <code>ListTasks</code> only returns <code>maxResults</code> results in a single page along
         * with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by
         * sending another <code>ListTasks</code> request with the returned <code>nextToken</code> value. This value can
         * be between 1 and 100. If this parameter isn't used, then <code>ListTasks</code> returns up to 100 results and
         * a <code>nextToken</code> value if applicable.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of task results that <code>ListTasks</code> returned in paginated output. When this
         *        parameter is used, <code>ListTasks</code> only returns <code>maxResults</code> results in a single
         *        page along with a <code>nextToken</code> response element. The remaining results of the initial
         *        request can be seen by sending another <code>ListTasks</code> request with the returned
         *        <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then
         *        <code>ListTasks</code> returns up to 100 results and a <code>nextToken</code> value if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The <code>startedBy</code> value to filter the task results with. Specifying a <code>startedBy</code> value
         * limits the results to tasks that were started with that value.
         * </p>
         * 
         * @param startedBy
         *        The <code>startedBy</code> value to filter the task results with. Specifying a <code>startedBy</code>
         *        value limits the results to tasks that were started with that value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedBy(String startedBy);

        /**
         * <p>
         * The name of the service to use when filtering the <code>ListTasks</code> results. Specifying a
         * <code>serviceName</code> limits the results to tasks that belong to that service.
         * </p>
         * 
         * @param serviceName
         *        The name of the service to use when filtering the <code>ListTasks</code> results. Specifying a
         *        <code>serviceName</code> limits the results to tasks that belong to that service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The task desired status to use when filtering the <code>ListTasks</code> results. Specifying a
         * <code>desiredStatus</code> of <code>STOPPED</code> limits the results to tasks that Amazon ECS has set the
         * desired status to <code>STOPPED</code>. This can be useful for debugging tasks that aren't starting properly
         * or have died or finished. The default status filter is <code>RUNNING</code>, which shows tasks that Amazon
         * ECS has set the desired status to <code>RUNNING</code>.
         * </p>
         * <note>
         * <p>
         * Although you can filter results based on a desired status of <code>PENDING</code>, this doesn't return any
         * results. Amazon ECS never sets the desired status of a task to that value (only a task's
         * <code>lastStatus</code> may have a value of <code>PENDING</code>).
         * </p>
         * </note>
         * 
         * @param desiredStatus
         *        The task desired status to use when filtering the <code>ListTasks</code> results. Specifying a
         *        <code>desiredStatus</code> of <code>STOPPED</code> limits the results to tasks that Amazon ECS has set
         *        the desired status to <code>STOPPED</code>. This can be useful for debugging tasks that aren't
         *        starting properly or have died or finished. The default status filter is <code>RUNNING</code>, which
         *        shows tasks that Amazon ECS has set the desired status to <code>RUNNING</code>.</p> <note>
         *        <p>
         *        Although you can filter results based on a desired status of <code>PENDING</code>, this doesn't return
         *        any results. Amazon ECS never sets the desired status of a task to that value (only a task's
         *        <code>lastStatus</code> may have a value of <code>PENDING</code>).
         *        </p>
         * @see DesiredStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DesiredStatus
         */
        Builder desiredStatus(String desiredStatus);

        /**
         * <p>
         * The task desired status to use when filtering the <code>ListTasks</code> results. Specifying a
         * <code>desiredStatus</code> of <code>STOPPED</code> limits the results to tasks that Amazon ECS has set the
         * desired status to <code>STOPPED</code>. This can be useful for debugging tasks that aren't starting properly
         * or have died or finished. The default status filter is <code>RUNNING</code>, which shows tasks that Amazon
         * ECS has set the desired status to <code>RUNNING</code>.
         * </p>
         * <note>
         * <p>
         * Although you can filter results based on a desired status of <code>PENDING</code>, this doesn't return any
         * results. Amazon ECS never sets the desired status of a task to that value (only a task's
         * <code>lastStatus</code> may have a value of <code>PENDING</code>).
         * </p>
         * </note>
         * 
         * @param desiredStatus
         *        The task desired status to use when filtering the <code>ListTasks</code> results. Specifying a
         *        <code>desiredStatus</code> of <code>STOPPED</code> limits the results to tasks that Amazon ECS has set
         *        the desired status to <code>STOPPED</code>. This can be useful for debugging tasks that aren't
         *        starting properly or have died or finished. The default status filter is <code>RUNNING</code>, which
         *        shows tasks that Amazon ECS has set the desired status to <code>RUNNING</code>.</p> <note>
         *        <p>
         *        Although you can filter results based on a desired status of <code>PENDING</code>, this doesn't return
         *        any results. Amazon ECS never sets the desired status of a task to that value (only a task's
         *        <code>lastStatus</code> may have a value of <code>PENDING</code>).
         *        </p>
         * @see DesiredStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DesiredStatus
         */
        Builder desiredStatus(DesiredStatus desiredStatus);

        /**
         * <p>
         * The launch type to use when filtering the <code>ListTasks</code> results.
         * </p>
         * 
         * @param launchType
         *        The launch type to use when filtering the <code>ListTasks</code> results.
         * @see LaunchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchType
         */
        Builder launchType(String launchType);

        /**
         * <p>
         * The launch type to use when filtering the <code>ListTasks</code> results.
         * </p>
         * 
         * @param launchType
         *        The launch type to use when filtering the <code>ListTasks</code> results.
         * @see LaunchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchType
         */
        Builder launchType(LaunchType launchType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String cluster;

        private String containerInstance;

        private String family;

        private String nextToken;

        private Integer maxResults;

        private String startedBy;

        private String serviceName;

        private String desiredStatus;

        private String launchType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTasksRequest model) {
            super(model);
            cluster(model.cluster);
            containerInstance(model.containerInstance);
            family(model.family);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            startedBy(model.startedBy);
            serviceName(model.serviceName);
            desiredStatus(model.desiredStatus);
            launchType(model.launchType);
        }

        public final String getCluster() {
            return cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        @Transient
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final String getContainerInstance() {
            return containerInstance;
        }

        public final void setContainerInstance(String containerInstance) {
            this.containerInstance = containerInstance;
        }

        @Override
        @Transient
        public final Builder containerInstance(String containerInstance) {
            this.containerInstance = containerInstance;
            return this;
        }

        public final String getFamily() {
            return family;
        }

        public final void setFamily(String family) {
            this.family = family;
        }

        @Override
        @Transient
        public final Builder family(String family) {
            this.family = family;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getStartedBy() {
            return startedBy;
        }

        public final void setStartedBy(String startedBy) {
            this.startedBy = startedBy;
        }

        @Override
        @Transient
        public final Builder startedBy(String startedBy) {
            this.startedBy = startedBy;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        @Transient
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getDesiredStatus() {
            return desiredStatus;
        }

        public final void setDesiredStatus(String desiredStatus) {
            this.desiredStatus = desiredStatus;
        }

        @Override
        @Transient
        public final Builder desiredStatus(String desiredStatus) {
            this.desiredStatus = desiredStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder desiredStatus(DesiredStatus desiredStatus) {
            this.desiredStatus(desiredStatus == null ? null : desiredStatus.toString());
            return this;
        }

        public final String getLaunchType() {
            return launchType;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        @Override
        @Transient
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        @Override
        @Transient
        public final Builder launchType(LaunchType launchType) {
            this.launchType(launchType == null ? null : launchType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTasksRequest build() {
            return new ListTasksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
