/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.CPUArchitecture;
import software.amazon.awssdk.services.ecs.model.OSFamily;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuntimePlatform
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuntimePlatform> {
    private static final SdkField<String> CPU_ARCHITECTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cpuArchitecture").getter(RuntimePlatform.getter(RuntimePlatform::cpuArchitectureAsString)).setter(RuntimePlatform.setter(Builder::cpuArchitecture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuArchitecture").build()}).build();
    private static final SdkField<String> OPERATING_SYSTEM_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operatingSystemFamily").getter(RuntimePlatform.getter(RuntimePlatform::operatingSystemFamilyAsString)).setter(RuntimePlatform.setter(Builder::operatingSystemFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operatingSystemFamily").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CPU_ARCHITECTURE_FIELD, OPERATING_SYSTEM_FAMILY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String cpuArchitecture;
    private final String operatingSystemFamily;

    private RuntimePlatform(BuilderImpl builder) {
        this.cpuArchitecture = builder.cpuArchitecture;
        this.operatingSystemFamily = builder.operatingSystemFamily;
    }

    public final CPUArchitecture cpuArchitecture() {
        return CPUArchitecture.fromValue(this.cpuArchitecture);
    }

    public final String cpuArchitectureAsString() {
        return this.cpuArchitecture;
    }

    public final OSFamily operatingSystemFamily() {
        return OSFamily.fromValue(this.operatingSystemFamily);
    }

    public final String operatingSystemFamilyAsString() {
        return this.operatingSystemFamily;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuArchitectureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemFamilyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuntimePlatform)) {
            return false;
        }
        RuntimePlatform other = (RuntimePlatform)obj;
        return Objects.equals(this.cpuArchitectureAsString(), other.cpuArchitectureAsString()) && Objects.equals(this.operatingSystemFamilyAsString(), other.operatingSystemFamilyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RuntimePlatform").add("CpuArchitecture", (Object)this.cpuArchitectureAsString()).add("OperatingSystemFamily", (Object)this.operatingSystemFamilyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cpuArchitecture": {
                return Optional.ofNullable(clazz.cast(this.cpuArchitectureAsString()));
            }
            case "operatingSystemFamily": {
                return Optional.ofNullable(clazz.cast(this.operatingSystemFamilyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuntimePlatform, T> g) {
        return obj -> g.apply((RuntimePlatform)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cpuArchitecture;
        private String operatingSystemFamily;

        private BuilderImpl() {
        }

        private BuilderImpl(RuntimePlatform model) {
            this.cpuArchitecture(model.cpuArchitecture);
            this.operatingSystemFamily(model.operatingSystemFamily);
        }

        public final String getCpuArchitecture() {
            return this.cpuArchitecture;
        }

        public final void setCpuArchitecture(String cpuArchitecture) {
            this.cpuArchitecture = cpuArchitecture;
        }

        @Override
        @Transient
        public final Builder cpuArchitecture(String cpuArchitecture) {
            this.cpuArchitecture = cpuArchitecture;
            return this;
        }

        @Override
        @Transient
        public final Builder cpuArchitecture(CPUArchitecture cpuArchitecture) {
            this.cpuArchitecture(cpuArchitecture == null ? null : cpuArchitecture.toString());
            return this;
        }

        public final String getOperatingSystemFamily() {
            return this.operatingSystemFamily;
        }

        public final void setOperatingSystemFamily(String operatingSystemFamily) {
            this.operatingSystemFamily = operatingSystemFamily;
        }

        @Override
        @Transient
        public final Builder operatingSystemFamily(String operatingSystemFamily) {
            this.operatingSystemFamily = operatingSystemFamily;
            return this;
        }

        @Override
        @Transient
        public final Builder operatingSystemFamily(OSFamily operatingSystemFamily) {
            this.operatingSystemFamily(operatingSystemFamily == null ? null : operatingSystemFamily.toString());
            return this;
        }

        public RuntimePlatform build() {
            return new RuntimePlatform(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuntimePlatform> {
        public Builder cpuArchitecture(String var1);

        public Builder cpuArchitecture(CPUArchitecture var1);

        public Builder operatingSystemFamily(String var1);

        public Builder operatingSystemFamily(OSFamily var1);
    }
}

