/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ecs.model.LogConfigurationOptionsMapCopier;
import software.amazon.awssdk.services.ecs.model.LogDriver;
import software.amazon.awssdk.services.ecs.model.Secret;
import software.amazon.awssdk.services.ecs.model.SecretListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogConfiguration> {
    private static final SdkField<String> LOG_DRIVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logDriver").getter(LogConfiguration.getter(LogConfiguration::logDriverAsString)).setter(LogConfiguration.setter(Builder::logDriver)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logDriver").build()}).build();
    private static final SdkField<Map<String, String>> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("options").getter(LogConfiguration.getter(LogConfiguration::options)).setter(LogConfiguration.setter(Builder::options)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("options").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<Secret>> SECRET_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("secretOptions").getter(LogConfiguration.getter(LogConfiguration::secretOptions)).setter(LogConfiguration.setter(Builder::secretOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Secret::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_DRIVER_FIELD, OPTIONS_FIELD, SECRET_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String logDriver;
    private final Map<String, String> options;
    private final List<Secret> secretOptions;

    private LogConfiguration(BuilderImpl builder) {
        this.logDriver = builder.logDriver;
        this.options = builder.options;
        this.secretOptions = builder.secretOptions;
    }

    public final LogDriver logDriver() {
        return LogDriver.fromValue(this.logDriver);
    }

    public final String logDriverAsString() {
        return this.logDriver;
    }

    public final boolean hasOptions() {
        return this.options != null && !(this.options instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> options() {
        return this.options;
    }

    public final boolean hasSecretOptions() {
        return this.secretOptions != null && !(this.secretOptions instanceof SdkAutoConstructList);
    }

    public final List<Secret> secretOptions() {
        return this.secretOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logDriverAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptions() ? this.options() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecretOptions() ? this.secretOptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogConfiguration)) {
            return false;
        }
        LogConfiguration other = (LogConfiguration)obj;
        return Objects.equals(this.logDriverAsString(), other.logDriverAsString()) && this.hasOptions() == other.hasOptions() && Objects.equals(this.options(), other.options()) && this.hasSecretOptions() == other.hasSecretOptions() && Objects.equals(this.secretOptions(), other.secretOptions());
    }

    public final String toString() {
        return ToString.builder((String)"LogConfiguration").add("LogDriver", (Object)this.logDriverAsString()).add("Options", this.hasOptions() ? this.options() : null).add("SecretOptions", this.hasSecretOptions() ? this.secretOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logDriver": {
                return Optional.ofNullable(clazz.cast(this.logDriverAsString()));
            }
            case "options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
            case "secretOptions": {
                return Optional.ofNullable(clazz.cast(this.secretOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogConfiguration, T> g) {
        return obj -> g.apply((LogConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logDriver;
        private Map<String, String> options = DefaultSdkAutoConstructMap.getInstance();
        private List<Secret> secretOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LogConfiguration model) {
            this.logDriver(model.logDriver);
            this.options(model.options);
            this.secretOptions(model.secretOptions);
        }

        public final String getLogDriver() {
            return this.logDriver;
        }

        public final void setLogDriver(String logDriver) {
            this.logDriver = logDriver;
        }

        @Override
        public final Builder logDriver(String logDriver) {
            this.logDriver = logDriver;
            return this;
        }

        @Override
        public final Builder logDriver(LogDriver logDriver) {
            this.logDriver(logDriver == null ? null : logDriver.toString());
            return this;
        }

        public final Map<String, String> getOptions() {
            if (this.options instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.options;
        }

        public final void setOptions(Map<String, String> options) {
            this.options = LogConfigurationOptionsMapCopier.copy(options);
        }

        @Override
        public final Builder options(Map<String, String> options) {
            this.options = LogConfigurationOptionsMapCopier.copy(options);
            return this;
        }

        public final List<Secret.Builder> getSecretOptions() {
            List<Secret.Builder> result = SecretListCopier.copyToBuilder(this.secretOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecretOptions(Collection<Secret.BuilderImpl> secretOptions) {
            this.secretOptions = SecretListCopier.copyFromBuilder(secretOptions);
        }

        @Override
        public final Builder secretOptions(Collection<Secret> secretOptions) {
            this.secretOptions = SecretListCopier.copy(secretOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secretOptions(Secret ... secretOptions) {
            this.secretOptions(Arrays.asList(secretOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secretOptions(Consumer<Secret.Builder> ... secretOptions) {
            this.secretOptions(Stream.of(secretOptions).map(c -> (Secret)((Secret.Builder)Secret.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LogConfiguration build() {
            return new LogConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogConfiguration> {
        public Builder logDriver(String var1);

        public Builder logDriver(LogDriver var1);

        public Builder options(Map<String, String> var1);

        public Builder secretOptions(Collection<Secret> var1);

        public Builder secretOptions(Secret ... var1);

        public Builder secretOptions(Consumer<Secret.Builder> ... var1);
    }
}

