/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecs.EcsAsyncClient;
import software.amazon.awssdk.services.ecs.internal.UserAgentUtils;
import software.amazon.awssdk.services.ecs.model.Attribute;
import software.amazon.awssdk.services.ecs.model.ListAttributesRequest;
import software.amazon.awssdk.services.ecs.model.ListAttributesResponse;

public class ListAttributesPublisher
implements SdkPublisher<ListAttributesResponse> {
    private final EcsAsyncClient client;
    private final ListAttributesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAttributesPublisher(EcsAsyncClient client, ListAttributesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAttributesPublisher(EcsAsyncClient client, ListAttributesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAttributesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAttributesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Attribute> attributes() {
        Function<ListAttributesResponse, Iterator> getIterator = response -> {
            if (response != null && response.attributes() != null) {
                return response.attributes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAttributesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAttributesResponseFetcher
    implements AsyncPageFetcher<ListAttributesResponse> {
        private ListAttributesResponseFetcher() {
        }

        public boolean hasNextPage(ListAttributesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAttributesResponse> nextPage(ListAttributesResponse previousPage) {
            if (previousPage == null) {
                return ListAttributesPublisher.this.client.listAttributes(ListAttributesPublisher.this.firstRequest);
            }
            return ListAttributesPublisher.this.client.listAttributes((ListAttributesRequest)((Object)ListAttributesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

