/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.TaskManagedEBSVolumeConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskVolumeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskVolumeConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(TaskVolumeConfiguration.getter(TaskVolumeConfiguration::name)).setter(TaskVolumeConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<TaskManagedEBSVolumeConfiguration> MANAGED_EBS_VOLUME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("managedEBSVolume").getter(TaskVolumeConfiguration.getter(TaskVolumeConfiguration::managedEBSVolume)).setter(TaskVolumeConfiguration.setter(Builder::managedEBSVolume)).constructor(TaskManagedEBSVolumeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedEBSVolume").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MANAGED_EBS_VOLUME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final TaskManagedEBSVolumeConfiguration managedEBSVolume;

    private TaskVolumeConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.managedEBSVolume = builder.managedEBSVolume;
    }

    public final String name() {
        return this.name;
    }

    public final TaskManagedEBSVolumeConfiguration managedEBSVolume() {
        return this.managedEBSVolume;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedEBSVolume());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskVolumeConfiguration)) {
            return false;
        }
        TaskVolumeConfiguration other = (TaskVolumeConfiguration)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.managedEBSVolume(), other.managedEBSVolume());
    }

    public final String toString() {
        return ToString.builder((String)"TaskVolumeConfiguration").add("Name", (Object)this.name()).add("ManagedEBSVolume", (Object)this.managedEBSVolume()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "managedEBSVolume": {
                return Optional.ofNullable(clazz.cast(this.managedEBSVolume()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskVolumeConfiguration, T> g) {
        return obj -> g.apply((TaskVolumeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private TaskManagedEBSVolumeConfiguration managedEBSVolume;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskVolumeConfiguration model) {
            this.name(model.name);
            this.managedEBSVolume(model.managedEBSVolume);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final TaskManagedEBSVolumeConfiguration.Builder getManagedEBSVolume() {
            return this.managedEBSVolume != null ? this.managedEBSVolume.toBuilder() : null;
        }

        public final void setManagedEBSVolume(TaskManagedEBSVolumeConfiguration.BuilderImpl managedEBSVolume) {
            this.managedEBSVolume = managedEBSVolume != null ? managedEBSVolume.build() : null;
        }

        @Override
        public final Builder managedEBSVolume(TaskManagedEBSVolumeConfiguration managedEBSVolume) {
            this.managedEBSVolume = managedEBSVolume;
            return this;
        }

        public TaskVolumeConfiguration build() {
            return new TaskVolumeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskVolumeConfiguration> {
        public Builder name(String var1);

        public Builder managedEBSVolume(TaskManagedEBSVolumeConfiguration var1);

        default public Builder managedEBSVolume(Consumer<TaskManagedEBSVolumeConfiguration.Builder> managedEBSVolume) {
            return this.managedEBSVolume((TaskManagedEBSVolumeConfiguration)((TaskManagedEBSVolumeConfiguration.Builder)TaskManagedEBSVolumeConfiguration.builder().applyMutation(managedEBSVolume)).build());
        }
    }
}

