/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.EcsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DiscoverPollEndpointResponse
extends EcsResponse
implements ToCopyableBuilder<Builder, DiscoverPollEndpointResponse> {
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpoint").getter(DiscoverPollEndpointResponse.getter(DiscoverPollEndpointResponse::endpoint)).setter(DiscoverPollEndpointResponse.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()}).build();
    private static final SdkField<String> TELEMETRY_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("telemetryEndpoint").getter(DiscoverPollEndpointResponse.getter(DiscoverPollEndpointResponse::telemetryEndpoint)).setter(DiscoverPollEndpointResponse.setter(Builder::telemetryEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("telemetryEndpoint").build()}).build();
    private static final SdkField<String> SERVICE_CONNECT_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceConnectEndpoint").getter(DiscoverPollEndpointResponse.getter(DiscoverPollEndpointResponse::serviceConnectEndpoint)).setter(DiscoverPollEndpointResponse.setter(Builder::serviceConnectEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceConnectEndpoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_FIELD, TELEMETRY_ENDPOINT_FIELD, SERVICE_CONNECT_ENDPOINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DiscoverPollEndpointResponse.memberNameToFieldInitializer();
    private final String endpoint;
    private final String telemetryEndpoint;
    private final String serviceConnectEndpoint;

    private DiscoverPollEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.endpoint = builder.endpoint;
        this.telemetryEndpoint = builder.telemetryEndpoint;
        this.serviceConnectEndpoint = builder.serviceConnectEndpoint;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final String telemetryEndpoint() {
        return this.telemetryEndpoint;
    }

    public final String serviceConnectEndpoint() {
        return this.serviceConnectEndpoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.telemetryEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceConnectEndpoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoverPollEndpointResponse)) {
            return false;
        }
        DiscoverPollEndpointResponse other = (DiscoverPollEndpointResponse)((Object)obj);
        return Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.telemetryEndpoint(), other.telemetryEndpoint()) && Objects.equals(this.serviceConnectEndpoint(), other.serviceConnectEndpoint());
    }

    public final String toString() {
        return ToString.builder((String)"DiscoverPollEndpointResponse").add("Endpoint", (Object)this.endpoint()).add("TelemetryEndpoint", (Object)this.telemetryEndpoint()).add("ServiceConnectEndpoint", (Object)this.serviceConnectEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "telemetryEndpoint": {
                return Optional.ofNullable(clazz.cast(this.telemetryEndpoint()));
            }
            case "serviceConnectEndpoint": {
                return Optional.ofNullable(clazz.cast(this.serviceConnectEndpoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("endpoint", ENDPOINT_FIELD);
        map.put("telemetryEndpoint", TELEMETRY_ENDPOINT_FIELD);
        map.put("serviceConnectEndpoint", SERVICE_CONNECT_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DiscoverPollEndpointResponse, T> g) {
        return obj -> g.apply((DiscoverPollEndpointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsResponse.BuilderImpl
    implements Builder {
        private String endpoint;
        private String telemetryEndpoint;
        private String serviceConnectEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoverPollEndpointResponse model) {
            super(model);
            this.endpoint(model.endpoint);
            this.telemetryEndpoint(model.telemetryEndpoint);
            this.serviceConnectEndpoint(model.serviceConnectEndpoint);
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getTelemetryEndpoint() {
            return this.telemetryEndpoint;
        }

        public final void setTelemetryEndpoint(String telemetryEndpoint) {
            this.telemetryEndpoint = telemetryEndpoint;
        }

        @Override
        public final Builder telemetryEndpoint(String telemetryEndpoint) {
            this.telemetryEndpoint = telemetryEndpoint;
            return this;
        }

        public final String getServiceConnectEndpoint() {
            return this.serviceConnectEndpoint;
        }

        public final void setServiceConnectEndpoint(String serviceConnectEndpoint) {
            this.serviceConnectEndpoint = serviceConnectEndpoint;
        }

        @Override
        public final Builder serviceConnectEndpoint(String serviceConnectEndpoint) {
            this.serviceConnectEndpoint = serviceConnectEndpoint;
            return this;
        }

        @Override
        public DiscoverPollEndpointResponse build() {
            return new DiscoverPollEndpointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EcsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DiscoverPollEndpointResponse> {
        public Builder endpoint(String var1);

        public Builder telemetryEndpoint(String var1);

        public Builder serviceConnectEndpoint(String var1);
    }
}

