/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedStorageConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagedStorageConfiguration> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(ManagedStorageConfiguration.getter(ManagedStorageConfiguration::kmsKeyId)).setter(ManagedStorageConfiguration.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<String> FARGATE_EPHEMERAL_STORAGE_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fargateEphemeralStorageKmsKeyId").getter(ManagedStorageConfiguration.getter(ManagedStorageConfiguration::fargateEphemeralStorageKmsKeyId)).setter(ManagedStorageConfiguration.setter(Builder::fargateEphemeralStorageKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fargateEphemeralStorageKmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD, FARGATE_EPHEMERAL_STORAGE_KMS_KEY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ManagedStorageConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String kmsKeyId;
    private final String fargateEphemeralStorageKmsKeyId;

    private ManagedStorageConfiguration(BuilderImpl builder) {
        this.kmsKeyId = builder.kmsKeyId;
        this.fargateEphemeralStorageKmsKeyId = builder.fargateEphemeralStorageKmsKeyId;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String fargateEphemeralStorageKmsKeyId() {
        return this.fargateEphemeralStorageKmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fargateEphemeralStorageKmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedStorageConfiguration)) {
            return false;
        }
        ManagedStorageConfiguration other = (ManagedStorageConfiguration)obj;
        return Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.fargateEphemeralStorageKmsKeyId(), other.fargateEphemeralStorageKmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"ManagedStorageConfiguration").add("KmsKeyId", (Object)this.kmsKeyId()).add("FargateEphemeralStorageKmsKeyId", (Object)this.fargateEphemeralStorageKmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "fargateEphemeralStorageKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.fargateEphemeralStorageKmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("fargateEphemeralStorageKmsKeyId", FARGATE_EPHEMERAL_STORAGE_KMS_KEY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedStorageConfiguration, T> g) {
        return obj -> g.apply((ManagedStorageConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String kmsKeyId;
        private String fargateEphemeralStorageKmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedStorageConfiguration model) {
            this.kmsKeyId(model.kmsKeyId);
            this.fargateEphemeralStorageKmsKeyId(model.fargateEphemeralStorageKmsKeyId);
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getFargateEphemeralStorageKmsKeyId() {
            return this.fargateEphemeralStorageKmsKeyId;
        }

        public final void setFargateEphemeralStorageKmsKeyId(String fargateEphemeralStorageKmsKeyId) {
            this.fargateEphemeralStorageKmsKeyId = fargateEphemeralStorageKmsKeyId;
        }

        @Override
        public final Builder fargateEphemeralStorageKmsKeyId(String fargateEphemeralStorageKmsKeyId) {
            this.fargateEphemeralStorageKmsKeyId = fargateEphemeralStorageKmsKeyId;
            return this;
        }

        public ManagedStorageConfiguration build() {
            return new ManagedStorageConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagedStorageConfiguration> {
        public Builder kmsKeyId(String var1);

        public Builder fargateEphemeralStorageKmsKeyId(String var1);
    }
}

