/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.DeploymentConfiguration;
import software.amazon.awssdk.services.ecs.model.Rollback;
import software.amazon.awssdk.services.ecs.model.ServiceDeploymentAlarms;
import software.amazon.awssdk.services.ecs.model.ServiceDeploymentCircuitBreaker;
import software.amazon.awssdk.services.ecs.model.ServiceDeploymentStatus;
import software.amazon.awssdk.services.ecs.model.ServiceRevisionSummary;
import software.amazon.awssdk.services.ecs.model.ServiceRevisionsSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceDeployment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceDeployment> {
    private static final SdkField<String> SERVICE_DEPLOYMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceDeploymentArn").getter(ServiceDeployment.getter(ServiceDeployment::serviceDeploymentArn)).setter(ServiceDeployment.setter(Builder::serviceDeploymentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceDeploymentArn").build()}).build();
    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceArn").getter(ServiceDeployment.getter(ServiceDeployment::serviceArn)).setter(ServiceDeployment.setter(Builder::serviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceArn").build()}).build();
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterArn").getter(ServiceDeployment.getter(ServiceDeployment::clusterArn)).setter(ServiceDeployment.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ServiceDeployment.getter(ServiceDeployment::createdAt)).setter(ServiceDeployment.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(ServiceDeployment.getter(ServiceDeployment::startedAt)).setter(ServiceDeployment.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()}).build();
    private static final SdkField<Instant> FINISHED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("finishedAt").getter(ServiceDeployment.getter(ServiceDeployment::finishedAt)).setter(ServiceDeployment.setter(Builder::finishedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finishedAt").build()}).build();
    private static final SdkField<Instant> STOPPED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("stoppedAt").getter(ServiceDeployment.getter(ServiceDeployment::stoppedAt)).setter(ServiceDeployment.setter(Builder::stoppedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppedAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(ServiceDeployment.getter(ServiceDeployment::updatedAt)).setter(ServiceDeployment.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<List<ServiceRevisionSummary>> SOURCE_SERVICE_REVISIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceServiceRevisions").getter(ServiceDeployment.getter(ServiceDeployment::sourceServiceRevisions)).setter(ServiceDeployment.setter(Builder::sourceServiceRevisions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServiceRevisions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceRevisionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ServiceRevisionSummary> TARGET_SERVICE_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("targetServiceRevision").getter(ServiceDeployment.getter(ServiceDeployment::targetServiceRevision)).setter(ServiceDeployment.setter(Builder::targetServiceRevision)).constructor(ServiceRevisionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetServiceRevision").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ServiceDeployment.getter(ServiceDeployment::statusAsString)).setter(ServiceDeployment.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(ServiceDeployment.getter(ServiceDeployment::statusReason)).setter(ServiceDeployment.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<DeploymentConfiguration> DEPLOYMENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deploymentConfiguration").getter(ServiceDeployment.getter(ServiceDeployment::deploymentConfiguration)).setter(ServiceDeployment.setter(Builder::deploymentConfiguration)).constructor(DeploymentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfiguration").build()}).build();
    private static final SdkField<Rollback> ROLLBACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rollback").getter(ServiceDeployment.getter(ServiceDeployment::rollback)).setter(ServiceDeployment.setter(Builder::rollback)).constructor(Rollback::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rollback").build()}).build();
    private static final SdkField<ServiceDeploymentCircuitBreaker> DEPLOYMENT_CIRCUIT_BREAKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deploymentCircuitBreaker").getter(ServiceDeployment.getter(ServiceDeployment::deploymentCircuitBreaker)).setter(ServiceDeployment.setter(Builder::deploymentCircuitBreaker)).constructor(ServiceDeploymentCircuitBreaker::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentCircuitBreaker").build()}).build();
    private static final SdkField<ServiceDeploymentAlarms> ALARMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("alarms").getter(ServiceDeployment.getter(ServiceDeployment::alarms)).setter(ServiceDeployment.setter(Builder::alarms)).constructor(ServiceDeploymentAlarms::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarms").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_DEPLOYMENT_ARN_FIELD, SERVICE_ARN_FIELD, CLUSTER_ARN_FIELD, CREATED_AT_FIELD, STARTED_AT_FIELD, FINISHED_AT_FIELD, STOPPED_AT_FIELD, UPDATED_AT_FIELD, SOURCE_SERVICE_REVISIONS_FIELD, TARGET_SERVICE_REVISION_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, DEPLOYMENT_CONFIGURATION_FIELD, ROLLBACK_FIELD, DEPLOYMENT_CIRCUIT_BREAKER_FIELD, ALARMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceDeployment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serviceDeploymentArn;
    private final String serviceArn;
    private final String clusterArn;
    private final Instant createdAt;
    private final Instant startedAt;
    private final Instant finishedAt;
    private final Instant stoppedAt;
    private final Instant updatedAt;
    private final List<ServiceRevisionSummary> sourceServiceRevisions;
    private final ServiceRevisionSummary targetServiceRevision;
    private final String status;
    private final String statusReason;
    private final DeploymentConfiguration deploymentConfiguration;
    private final Rollback rollback;
    private final ServiceDeploymentCircuitBreaker deploymentCircuitBreaker;
    private final ServiceDeploymentAlarms alarms;

    private ServiceDeployment(BuilderImpl builder) {
        this.serviceDeploymentArn = builder.serviceDeploymentArn;
        this.serviceArn = builder.serviceArn;
        this.clusterArn = builder.clusterArn;
        this.createdAt = builder.createdAt;
        this.startedAt = builder.startedAt;
        this.finishedAt = builder.finishedAt;
        this.stoppedAt = builder.stoppedAt;
        this.updatedAt = builder.updatedAt;
        this.sourceServiceRevisions = builder.sourceServiceRevisions;
        this.targetServiceRevision = builder.targetServiceRevision;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.deploymentConfiguration = builder.deploymentConfiguration;
        this.rollback = builder.rollback;
        this.deploymentCircuitBreaker = builder.deploymentCircuitBreaker;
        this.alarms = builder.alarms;
    }

    public final String serviceDeploymentArn() {
        return this.serviceDeploymentArn;
    }

    public final String serviceArn() {
        return this.serviceArn;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Instant finishedAt() {
        return this.finishedAt;
    }

    public final Instant stoppedAt() {
        return this.stoppedAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final boolean hasSourceServiceRevisions() {
        return this.sourceServiceRevisions != null && !(this.sourceServiceRevisions instanceof SdkAutoConstructList);
    }

    public final List<ServiceRevisionSummary> sourceServiceRevisions() {
        return this.sourceServiceRevisions;
    }

    public final ServiceRevisionSummary targetServiceRevision() {
        return this.targetServiceRevision;
    }

    public final ServiceDeploymentStatus status() {
        return ServiceDeploymentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final DeploymentConfiguration deploymentConfiguration() {
        return this.deploymentConfiguration;
    }

    public final Rollback rollback() {
        return this.rollback;
    }

    public final ServiceDeploymentCircuitBreaker deploymentCircuitBreaker() {
        return this.deploymentCircuitBreaker;
    }

    public final ServiceDeploymentAlarms alarms() {
        return this.alarms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceDeploymentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.finishedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceServiceRevisions() ? this.sourceServiceRevisions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetServiceRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.rollback());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentCircuitBreaker());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarms());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceDeployment)) {
            return false;
        }
        ServiceDeployment other = (ServiceDeployment)obj;
        return Objects.equals(this.serviceDeploymentArn(), other.serviceDeploymentArn()) && Objects.equals(this.serviceArn(), other.serviceArn()) && Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.finishedAt(), other.finishedAt()) && Objects.equals(this.stoppedAt(), other.stoppedAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && this.hasSourceServiceRevisions() == other.hasSourceServiceRevisions() && Objects.equals(this.sourceServiceRevisions(), other.sourceServiceRevisions()) && Objects.equals(this.targetServiceRevision(), other.targetServiceRevision()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.deploymentConfiguration(), other.deploymentConfiguration()) && Objects.equals(this.rollback(), other.rollback()) && Objects.equals(this.deploymentCircuitBreaker(), other.deploymentCircuitBreaker()) && Objects.equals(this.alarms(), other.alarms());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceDeployment").add("ServiceDeploymentArn", (Object)this.serviceDeploymentArn()).add("ServiceArn", (Object)this.serviceArn()).add("ClusterArn", (Object)this.clusterArn()).add("CreatedAt", (Object)this.createdAt()).add("StartedAt", (Object)this.startedAt()).add("FinishedAt", (Object)this.finishedAt()).add("StoppedAt", (Object)this.stoppedAt()).add("UpdatedAt", (Object)this.updatedAt()).add("SourceServiceRevisions", this.hasSourceServiceRevisions() ? this.sourceServiceRevisions() : null).add("TargetServiceRevision", (Object)this.targetServiceRevision()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("DeploymentConfiguration", (Object)this.deploymentConfiguration()).add("Rollback", (Object)this.rollback()).add("DeploymentCircuitBreaker", (Object)this.deploymentCircuitBreaker()).add("Alarms", (Object)this.alarms()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceDeploymentArn": {
                return Optional.ofNullable(clazz.cast(this.serviceDeploymentArn()));
            }
            case "serviceArn": {
                return Optional.ofNullable(clazz.cast(this.serviceArn()));
            }
            case "clusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "finishedAt": {
                return Optional.ofNullable(clazz.cast(this.finishedAt()));
            }
            case "stoppedAt": {
                return Optional.ofNullable(clazz.cast(this.stoppedAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "sourceServiceRevisions": {
                return Optional.ofNullable(clazz.cast(this.sourceServiceRevisions()));
            }
            case "targetServiceRevision": {
                return Optional.ofNullable(clazz.cast(this.targetServiceRevision()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "deploymentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfiguration()));
            }
            case "rollback": {
                return Optional.ofNullable(clazz.cast(this.rollback()));
            }
            case "deploymentCircuitBreaker": {
                return Optional.ofNullable(clazz.cast(this.deploymentCircuitBreaker()));
            }
            case "alarms": {
                return Optional.ofNullable(clazz.cast(this.alarms()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serviceDeploymentArn", SERVICE_DEPLOYMENT_ARN_FIELD);
        map.put("serviceArn", SERVICE_ARN_FIELD);
        map.put("clusterArn", CLUSTER_ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("finishedAt", FINISHED_AT_FIELD);
        map.put("stoppedAt", STOPPED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("sourceServiceRevisions", SOURCE_SERVICE_REVISIONS_FIELD);
        map.put("targetServiceRevision", TARGET_SERVICE_REVISION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("deploymentConfiguration", DEPLOYMENT_CONFIGURATION_FIELD);
        map.put("rollback", ROLLBACK_FIELD);
        map.put("deploymentCircuitBreaker", DEPLOYMENT_CIRCUIT_BREAKER_FIELD);
        map.put("alarms", ALARMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceDeployment, T> g) {
        return obj -> g.apply((ServiceDeployment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceDeploymentArn;
        private String serviceArn;
        private String clusterArn;
        private Instant createdAt;
        private Instant startedAt;
        private Instant finishedAt;
        private Instant stoppedAt;
        private Instant updatedAt;
        private List<ServiceRevisionSummary> sourceServiceRevisions = DefaultSdkAutoConstructList.getInstance();
        private ServiceRevisionSummary targetServiceRevision;
        private String status;
        private String statusReason;
        private DeploymentConfiguration deploymentConfiguration;
        private Rollback rollback;
        private ServiceDeploymentCircuitBreaker deploymentCircuitBreaker;
        private ServiceDeploymentAlarms alarms;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceDeployment model) {
            this.serviceDeploymentArn(model.serviceDeploymentArn);
            this.serviceArn(model.serviceArn);
            this.clusterArn(model.clusterArn);
            this.createdAt(model.createdAt);
            this.startedAt(model.startedAt);
            this.finishedAt(model.finishedAt);
            this.stoppedAt(model.stoppedAt);
            this.updatedAt(model.updatedAt);
            this.sourceServiceRevisions(model.sourceServiceRevisions);
            this.targetServiceRevision(model.targetServiceRevision);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.deploymentConfiguration(model.deploymentConfiguration);
            this.rollback(model.rollback);
            this.deploymentCircuitBreaker(model.deploymentCircuitBreaker);
            this.alarms(model.alarms);
        }

        public final String getServiceDeploymentArn() {
            return this.serviceDeploymentArn;
        }

        public final void setServiceDeploymentArn(String serviceDeploymentArn) {
            this.serviceDeploymentArn = serviceDeploymentArn;
        }

        @Override
        public final Builder serviceDeploymentArn(String serviceDeploymentArn) {
            this.serviceDeploymentArn = serviceDeploymentArn;
            return this;
        }

        public final String getServiceArn() {
            return this.serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getFinishedAt() {
            return this.finishedAt;
        }

        public final void setFinishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
        }

        @Override
        public final Builder finishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
            return this;
        }

        public final Instant getStoppedAt() {
            return this.stoppedAt;
        }

        public final void setStoppedAt(Instant stoppedAt) {
            this.stoppedAt = stoppedAt;
        }

        @Override
        public final Builder stoppedAt(Instant stoppedAt) {
            this.stoppedAt = stoppedAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final List<ServiceRevisionSummary.Builder> getSourceServiceRevisions() {
            List<ServiceRevisionSummary.Builder> result = ServiceRevisionsSummaryListCopier.copyToBuilder(this.sourceServiceRevisions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceServiceRevisions(Collection<ServiceRevisionSummary.BuilderImpl> sourceServiceRevisions) {
            this.sourceServiceRevisions = ServiceRevisionsSummaryListCopier.copyFromBuilder(sourceServiceRevisions);
        }

        @Override
        public final Builder sourceServiceRevisions(Collection<ServiceRevisionSummary> sourceServiceRevisions) {
            this.sourceServiceRevisions = ServiceRevisionsSummaryListCopier.copy(sourceServiceRevisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceServiceRevisions(ServiceRevisionSummary ... sourceServiceRevisions) {
            this.sourceServiceRevisions(Arrays.asList(sourceServiceRevisions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceServiceRevisions(Consumer<ServiceRevisionSummary.Builder> ... sourceServiceRevisions) {
            this.sourceServiceRevisions(Stream.of(sourceServiceRevisions).map(c -> (ServiceRevisionSummary)((ServiceRevisionSummary.Builder)ServiceRevisionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ServiceRevisionSummary.Builder getTargetServiceRevision() {
            return this.targetServiceRevision != null ? this.targetServiceRevision.toBuilder() : null;
        }

        public final void setTargetServiceRevision(ServiceRevisionSummary.BuilderImpl targetServiceRevision) {
            this.targetServiceRevision = targetServiceRevision != null ? targetServiceRevision.build() : null;
        }

        @Override
        public final Builder targetServiceRevision(ServiceRevisionSummary targetServiceRevision) {
            this.targetServiceRevision = targetServiceRevision;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServiceDeploymentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final DeploymentConfiguration.Builder getDeploymentConfiguration() {
            return this.deploymentConfiguration != null ? this.deploymentConfiguration.toBuilder() : null;
        }

        public final void setDeploymentConfiguration(DeploymentConfiguration.BuilderImpl deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration != null ? deploymentConfiguration.build() : null;
        }

        @Override
        public final Builder deploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration;
            return this;
        }

        public final Rollback.Builder getRollback() {
            return this.rollback != null ? this.rollback.toBuilder() : null;
        }

        public final void setRollback(Rollback.BuilderImpl rollback) {
            this.rollback = rollback != null ? rollback.build() : null;
        }

        @Override
        public final Builder rollback(Rollback rollback) {
            this.rollback = rollback;
            return this;
        }

        public final ServiceDeploymentCircuitBreaker.Builder getDeploymentCircuitBreaker() {
            return this.deploymentCircuitBreaker != null ? this.deploymentCircuitBreaker.toBuilder() : null;
        }

        public final void setDeploymentCircuitBreaker(ServiceDeploymentCircuitBreaker.BuilderImpl deploymentCircuitBreaker) {
            this.deploymentCircuitBreaker = deploymentCircuitBreaker != null ? deploymentCircuitBreaker.build() : null;
        }

        @Override
        public final Builder deploymentCircuitBreaker(ServiceDeploymentCircuitBreaker deploymentCircuitBreaker) {
            this.deploymentCircuitBreaker = deploymentCircuitBreaker;
            return this;
        }

        public final ServiceDeploymentAlarms.Builder getAlarms() {
            return this.alarms != null ? this.alarms.toBuilder() : null;
        }

        public final void setAlarms(ServiceDeploymentAlarms.BuilderImpl alarms) {
            this.alarms = alarms != null ? alarms.build() : null;
        }

        @Override
        public final Builder alarms(ServiceDeploymentAlarms alarms) {
            this.alarms = alarms;
            return this;
        }

        public ServiceDeployment build() {
            return new ServiceDeployment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceDeployment> {
        public Builder serviceDeploymentArn(String var1);

        public Builder serviceArn(String var1);

        public Builder clusterArn(String var1);

        public Builder createdAt(Instant var1);

        public Builder startedAt(Instant var1);

        public Builder finishedAt(Instant var1);

        public Builder stoppedAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder sourceServiceRevisions(Collection<ServiceRevisionSummary> var1);

        public Builder sourceServiceRevisions(ServiceRevisionSummary ... var1);

        public Builder sourceServiceRevisions(Consumer<ServiceRevisionSummary.Builder> ... var1);

        public Builder targetServiceRevision(ServiceRevisionSummary var1);

        default public Builder targetServiceRevision(Consumer<ServiceRevisionSummary.Builder> targetServiceRevision) {
            return this.targetServiceRevision((ServiceRevisionSummary)((ServiceRevisionSummary.Builder)ServiceRevisionSummary.builder().applyMutation(targetServiceRevision)).build());
        }

        public Builder status(String var1);

        public Builder status(ServiceDeploymentStatus var1);

        public Builder statusReason(String var1);

        public Builder deploymentConfiguration(DeploymentConfiguration var1);

        default public Builder deploymentConfiguration(Consumer<DeploymentConfiguration.Builder> deploymentConfiguration) {
            return this.deploymentConfiguration((DeploymentConfiguration)((DeploymentConfiguration.Builder)DeploymentConfiguration.builder().applyMutation(deploymentConfiguration)).build());
        }

        public Builder rollback(Rollback var1);

        default public Builder rollback(Consumer<Rollback.Builder> rollback) {
            return this.rollback((Rollback)((Rollback.Builder)Rollback.builder().applyMutation(rollback)).build());
        }

        public Builder deploymentCircuitBreaker(ServiceDeploymentCircuitBreaker var1);

        default public Builder deploymentCircuitBreaker(Consumer<ServiceDeploymentCircuitBreaker.Builder> deploymentCircuitBreaker) {
            return this.deploymentCircuitBreaker((ServiceDeploymentCircuitBreaker)((ServiceDeploymentCircuitBreaker.Builder)ServiceDeploymentCircuitBreaker.builder().applyMutation(deploymentCircuitBreaker)).build());
        }

        public Builder alarms(ServiceDeploymentAlarms var1);

        default public Builder alarms(Consumer<ServiceDeploymentAlarms.Builder> alarms) {
            return this.alarms((ServiceDeploymentAlarms)((ServiceDeploymentAlarms.Builder)ServiceDeploymentAlarms.builder().applyMutation(alarms)).build());
        }
    }
}

