/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HealthCheck
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HealthCheck> {
    private static final SdkField<List<String>> COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("command").getter(HealthCheck.getter(HealthCheck::command)).setter(HealthCheck.setter(Builder::command)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("command").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("interval").getter(HealthCheck.getter(HealthCheck::interval)).setter(HealthCheck.setter(Builder::interval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interval").build()}).build();
    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("timeout").getter(HealthCheck.getter(HealthCheck::timeout)).setter(HealthCheck.setter(Builder::timeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeout").build()}).build();
    private static final SdkField<Integer> RETRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("retries").getter(HealthCheck.getter(HealthCheck::retries)).setter(HealthCheck.setter(Builder::retries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retries").build()}).build();
    private static final SdkField<Integer> START_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("startPeriod").getter(HealthCheck.getter(HealthCheck::startPeriod)).setter(HealthCheck.setter(Builder::startPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startPeriod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_FIELD, INTERVAL_FIELD, TIMEOUT_FIELD, RETRIES_FIELD, START_PERIOD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HealthCheck.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> command;
    private final Integer interval;
    private final Integer timeout;
    private final Integer retries;
    private final Integer startPeriod;

    private HealthCheck(BuilderImpl builder) {
        this.command = builder.command;
        this.interval = builder.interval;
        this.timeout = builder.timeout;
        this.retries = builder.retries;
        this.startPeriod = builder.startPeriod;
    }

    public final boolean hasCommand() {
        return this.command != null && !(this.command instanceof SdkAutoConstructList);
    }

    public final List<String> command() {
        return this.command;
    }

    public final Integer interval() {
        return this.interval;
    }

    public final Integer timeout() {
        return this.timeout;
    }

    public final Integer retries() {
        return this.retries;
    }

    public final Integer startPeriod() {
        return this.startPeriod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommand() ? this.command() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.interval());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.retries());
        hashCode = 31 * hashCode + Objects.hashCode(this.startPeriod());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheck)) {
            return false;
        }
        HealthCheck other = (HealthCheck)obj;
        return this.hasCommand() == other.hasCommand() && Objects.equals(this.command(), other.command()) && Objects.equals(this.interval(), other.interval()) && Objects.equals(this.timeout(), other.timeout()) && Objects.equals(this.retries(), other.retries()) && Objects.equals(this.startPeriod(), other.startPeriod());
    }

    public final String toString() {
        return ToString.builder((String)"HealthCheck").add("Command", this.hasCommand() ? this.command() : null).add("Interval", (Object)this.interval()).add("Timeout", (Object)this.timeout()).add("Retries", (Object)this.retries()).add("StartPeriod", (Object)this.startPeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "command": {
                return Optional.ofNullable(clazz.cast(this.command()));
            }
            case "interval": {
                return Optional.ofNullable(clazz.cast(this.interval()));
            }
            case "timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "retries": {
                return Optional.ofNullable(clazz.cast(this.retries()));
            }
            case "startPeriod": {
                return Optional.ofNullable(clazz.cast(this.startPeriod()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("command", COMMAND_FIELD);
        map.put("interval", INTERVAL_FIELD);
        map.put("timeout", TIMEOUT_FIELD);
        map.put("retries", RETRIES_FIELD);
        map.put("startPeriod", START_PERIOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HealthCheck, T> g) {
        return obj -> g.apply((HealthCheck)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> command = DefaultSdkAutoConstructList.getInstance();
        private Integer interval;
        private Integer timeout;
        private Integer retries;
        private Integer startPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheck model) {
            this.command(model.command);
            this.interval(model.interval);
            this.timeout(model.timeout);
            this.retries(model.retries);
            this.startPeriod(model.startPeriod);
        }

        public final Collection<String> getCommand() {
            if (this.command instanceof SdkAutoConstructList) {
                return null;
            }
            return this.command;
        }

        public final void setCommand(Collection<String> command) {
            this.command = StringListCopier.copy(command);
        }

        @Override
        public final Builder command(Collection<String> command) {
            this.command = StringListCopier.copy(command);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder command(String ... command) {
            this.command(Arrays.asList(command));
            return this;
        }

        public final Integer getInterval() {
            return this.interval;
        }

        public final void setInterval(Integer interval) {
            this.interval = interval;
        }

        @Override
        public final Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final Integer getRetries() {
            return this.retries;
        }

        public final void setRetries(Integer retries) {
            this.retries = retries;
        }

        @Override
        public final Builder retries(Integer retries) {
            this.retries = retries;
            return this;
        }

        public final Integer getStartPeriod() {
            return this.startPeriod;
        }

        public final void setStartPeriod(Integer startPeriod) {
            this.startPeriod = startPeriod;
        }

        @Override
        public final Builder startPeriod(Integer startPeriod) {
            this.startPeriod = startPeriod;
            return this;
        }

        public HealthCheck build() {
            return new HealthCheck(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HealthCheck> {
        public Builder command(Collection<String> var1);

        public Builder command(String ... var1);

        public Builder interval(Integer var1);

        public Builder timeout(Integer var1);

        public Builder retries(Integer var1);

        public Builder startPeriod(Integer var1);
    }
}

