/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.ServiceConnectAccessLoggingFormat;
import software.amazon.awssdk.services.ecs.model.ServiceConnectIncludeQueryParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceConnectAccessLogConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceConnectAccessLogConfiguration> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(ServiceConnectAccessLogConfiguration.getter(ServiceConnectAccessLogConfiguration::formatAsString)).setter(ServiceConnectAccessLogConfiguration.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<String> INCLUDE_QUERY_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("includeQueryParameters").getter(ServiceConnectAccessLogConfiguration.getter(ServiceConnectAccessLogConfiguration::includeQueryParametersAsString)).setter(ServiceConnectAccessLogConfiguration.setter(Builder::includeQueryParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeQueryParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, INCLUDE_QUERY_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceConnectAccessLogConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String format;
    private final String includeQueryParameters;

    private ServiceConnectAccessLogConfiguration(BuilderImpl builder) {
        this.format = builder.format;
        this.includeQueryParameters = builder.includeQueryParameters;
    }

    public final ServiceConnectAccessLoggingFormat format() {
        return ServiceConnectAccessLoggingFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final ServiceConnectIncludeQueryParameters includeQueryParameters() {
        return ServiceConnectIncludeQueryParameters.fromValue(this.includeQueryParameters);
    }

    public final String includeQueryParametersAsString() {
        return this.includeQueryParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeQueryParametersAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceConnectAccessLogConfiguration)) {
            return false;
        }
        ServiceConnectAccessLogConfiguration other = (ServiceConnectAccessLogConfiguration)obj;
        return Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.includeQueryParametersAsString(), other.includeQueryParametersAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceConnectAccessLogConfiguration").add("Format", (Object)this.formatAsString()).add("IncludeQueryParameters", (Object)this.includeQueryParametersAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "includeQueryParameters": {
                return Optional.ofNullable(clazz.cast(this.includeQueryParametersAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("format", FORMAT_FIELD);
        map.put("includeQueryParameters", INCLUDE_QUERY_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceConnectAccessLogConfiguration, T> g) {
        return obj -> g.apply((ServiceConnectAccessLogConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String format;
        private String includeQueryParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceConnectAccessLogConfiguration model) {
            this.format(model.format);
            this.includeQueryParameters(model.includeQueryParameters);
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(ServiceConnectAccessLoggingFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getIncludeQueryParameters() {
            return this.includeQueryParameters;
        }

        public final void setIncludeQueryParameters(String includeQueryParameters) {
            this.includeQueryParameters = includeQueryParameters;
        }

        @Override
        public final Builder includeQueryParameters(String includeQueryParameters) {
            this.includeQueryParameters = includeQueryParameters;
            return this;
        }

        @Override
        public final Builder includeQueryParameters(ServiceConnectIncludeQueryParameters includeQueryParameters) {
            this.includeQueryParameters(includeQueryParameters == null ? null : includeQueryParameters.toString());
            return this;
        }

        public ServiceConnectAccessLogConfiguration build() {
            return new ServiceConnectAccessLogConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceConnectAccessLogConfiguration> {
        public Builder format(String var1);

        public Builder format(ServiceConnectAccessLoggingFormat var1);

        public Builder includeQueryParameters(String var1);

        public Builder includeQueryParameters(ServiceConnectIncludeQueryParameters var1);
    }
}

