/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.ArgoCdRole;
import software.amazon.awssdk.services.eks.model.SsoIdentity;
import software.amazon.awssdk.services.eks.model.SsoIdentityListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ArgoCdRoleMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ArgoCdRoleMapping> {
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("role").getter(ArgoCdRoleMapping.getter(ArgoCdRoleMapping::roleAsString)).setter(ArgoCdRoleMapping.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()}).build();
    private static final SdkField<List<SsoIdentity>> IDENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("identities").getter(ArgoCdRoleMapping.getter(ArgoCdRoleMapping::identities)).setter(ArgoCdRoleMapping.setter(Builder::identities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SsoIdentity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_FIELD, IDENTITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ArgoCdRoleMapping.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String role;
    private final List<SsoIdentity> identities;

    private ArgoCdRoleMapping(BuilderImpl builder) {
        this.role = builder.role;
        this.identities = builder.identities;
    }

    public final ArgoCdRole role() {
        return ArgoCdRole.fromValue(this.role);
    }

    public final String roleAsString() {
        return this.role;
    }

    public final boolean hasIdentities() {
        return this.identities != null && !(this.identities instanceof SdkAutoConstructList);
    }

    public final List<SsoIdentity> identities() {
        return this.identities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentities() ? this.identities() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArgoCdRoleMapping)) {
            return false;
        }
        ArgoCdRoleMapping other = (ArgoCdRoleMapping)obj;
        return Objects.equals(this.roleAsString(), other.roleAsString()) && this.hasIdentities() == other.hasIdentities() && Objects.equals(this.identities(), other.identities());
    }

    public final String toString() {
        return ToString.builder((String)"ArgoCdRoleMapping").add("Role", (Object)this.roleAsString()).add("Identities", this.hasIdentities() ? this.identities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "role": {
                return Optional.ofNullable(clazz.cast(this.roleAsString()));
            }
            case "identities": {
                return Optional.ofNullable(clazz.cast(this.identities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("role", ROLE_FIELD);
        map.put("identities", IDENTITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ArgoCdRoleMapping, T> g) {
        return obj -> g.apply((ArgoCdRoleMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String role;
        private List<SsoIdentity> identities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ArgoCdRoleMapping model) {
            this.role(model.role);
            this.identities(model.identities);
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(ArgoCdRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final List<SsoIdentity.Builder> getIdentities() {
            List<SsoIdentity.Builder> result = SsoIdentityListCopier.copyToBuilder(this.identities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdentities(Collection<SsoIdentity.BuilderImpl> identities) {
            this.identities = SsoIdentityListCopier.copyFromBuilder(identities);
        }

        @Override
        public final Builder identities(Collection<SsoIdentity> identities) {
            this.identities = SsoIdentityListCopier.copy(identities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identities(SsoIdentity ... identities) {
            this.identities(Arrays.asList(identities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identities(Consumer<SsoIdentity.Builder> ... identities) {
            this.identities(Stream.of(identities).map(c -> (SsoIdentity)((SsoIdentity.Builder)SsoIdentity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ArgoCdRoleMapping build() {
            return new ArgoCdRoleMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ArgoCdRoleMapping> {
        public Builder role(String var1);

        public Builder role(ArgoCdRole var1);

        public Builder identities(Collection<SsoIdentity> var1);

        public Builder identities(SsoIdentity ... var1);

        public Builder identities(Consumer<SsoIdentity.Builder> ... var1);
    }
}

