/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CapabilityType {
    ACK("ACK"),
    KRO("KRO"),
    ARGOCD("ARGOCD"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CapabilityType> VALUE_MAP;
    private final String value;

    private CapabilityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CapabilityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CapabilityType> knownValues() {
        EnumSet<CapabilityType> knownValues = EnumSet.allOf(CapabilityType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CapabilityType.class, CapabilityType::toString);
    }
}

