/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.eks.EksAsyncClient;
import software.amazon.awssdk.services.eks.internal.UserAgentUtils;
import software.amazon.awssdk.services.eks.model.AddonInfo;
import software.amazon.awssdk.services.eks.model.DescribeAddonVersionsRequest;
import software.amazon.awssdk.services.eks.model.DescribeAddonVersionsResponse;

public class DescribeAddonVersionsPublisher
implements SdkPublisher<DescribeAddonVersionsResponse> {
    private final EksAsyncClient client;
    private final DescribeAddonVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeAddonVersionsPublisher(EksAsyncClient client, DescribeAddonVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeAddonVersionsPublisher(EksAsyncClient client, DescribeAddonVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeAddonVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeAddonVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AddonInfo> addons() {
        return this.flatMapIterable(response -> response.addons());
    }

    private class DescribeAddonVersionsResponseFetcher
    implements AsyncPageFetcher<DescribeAddonVersionsResponse> {
        private DescribeAddonVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAddonVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeAddonVersionsResponse> nextPage(DescribeAddonVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAddonVersionsPublisher.this.client.describeAddonVersions(DescribeAddonVersionsPublisher.this.firstRequest);
            }
            return DescribeAddonVersionsPublisher.this.client.describeAddonVersions((DescribeAddonVersionsRequest)((Object)DescribeAddonVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

