/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.eks.EksAsyncClient;
import software.amazon.awssdk.services.eks.internal.UserAgentUtils;
import software.amazon.awssdk.services.eks.model.AssociatedAccessPolicy;
import software.amazon.awssdk.services.eks.model.ListAssociatedAccessPoliciesRequest;
import software.amazon.awssdk.services.eks.model.ListAssociatedAccessPoliciesResponse;

public class ListAssociatedAccessPoliciesPublisher
implements SdkPublisher<ListAssociatedAccessPoliciesResponse> {
    private final EksAsyncClient client;
    private final ListAssociatedAccessPoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssociatedAccessPoliciesPublisher(EksAsyncClient client, ListAssociatedAccessPoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssociatedAccessPoliciesPublisher(EksAsyncClient client, ListAssociatedAccessPoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssociatedAccessPoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssociatedAccessPoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AssociatedAccessPolicy> associatedAccessPolicies() {
        return this.flatMapIterable(response -> response.associatedAccessPolicies());
    }

    private class ListAssociatedAccessPoliciesResponseFetcher
    implements AsyncPageFetcher<ListAssociatedAccessPoliciesResponse> {
        private ListAssociatedAccessPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListAssociatedAccessPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssociatedAccessPoliciesResponse> nextPage(ListAssociatedAccessPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListAssociatedAccessPoliciesPublisher.this.client.listAssociatedAccessPolicies(ListAssociatedAccessPoliciesPublisher.this.firstRequest);
            }
            return ListAssociatedAccessPoliciesPublisher.this.client.listAssociatedAccessPolicies((ListAssociatedAccessPoliciesRequest)((Object)ListAssociatedAccessPoliciesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

