/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.eks.EksAsyncClient;
import software.amazon.awssdk.services.eks.internal.UserAgentUtils;
import software.amazon.awssdk.services.eks.model.EksAnywhereSubscription;
import software.amazon.awssdk.services.eks.model.ListEksAnywhereSubscriptionsRequest;
import software.amazon.awssdk.services.eks.model.ListEksAnywhereSubscriptionsResponse;

public class ListEksAnywhereSubscriptionsPublisher
implements SdkPublisher<ListEksAnywhereSubscriptionsResponse> {
    private final EksAsyncClient client;
    private final ListEksAnywhereSubscriptionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEksAnywhereSubscriptionsPublisher(EksAsyncClient client, ListEksAnywhereSubscriptionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEksAnywhereSubscriptionsPublisher(EksAsyncClient client, ListEksAnywhereSubscriptionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEksAnywhereSubscriptionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEksAnywhereSubscriptionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EksAnywhereSubscription> subscriptions() {
        return this.flatMapIterable(response -> response.subscriptions());
    }

    private class ListEksAnywhereSubscriptionsResponseFetcher
    implements AsyncPageFetcher<ListEksAnywhereSubscriptionsResponse> {
        private ListEksAnywhereSubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(ListEksAnywhereSubscriptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEksAnywhereSubscriptionsResponse> nextPage(ListEksAnywhereSubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return ListEksAnywhereSubscriptionsPublisher.this.client.listEksAnywhereSubscriptions(ListEksAnywhereSubscriptionsPublisher.this.firstRequest);
            }
            return ListEksAnywhereSubscriptionsPublisher.this.client.listEksAnywhereSubscriptions((ListEksAnywhereSubscriptionsRequest)((Object)ListEksAnywhereSubscriptionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

