/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.eks.EksAsyncClient;
import software.amazon.awssdk.services.eks.internal.UserAgentUtils;
import software.amazon.awssdk.services.eks.model.IdentityProviderConfig;
import software.amazon.awssdk.services.eks.model.ListIdentityProviderConfigsRequest;
import software.amazon.awssdk.services.eks.model.ListIdentityProviderConfigsResponse;

public class ListIdentityProviderConfigsPublisher
implements SdkPublisher<ListIdentityProviderConfigsResponse> {
    private final EksAsyncClient client;
    private final ListIdentityProviderConfigsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIdentityProviderConfigsPublisher(EksAsyncClient client, ListIdentityProviderConfigsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIdentityProviderConfigsPublisher(EksAsyncClient client, ListIdentityProviderConfigsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIdentityProviderConfigsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIdentityProviderConfigsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IdentityProviderConfig> identityProviderConfigs() {
        return this.flatMapIterable(response -> response.identityProviderConfigs());
    }

    private class ListIdentityProviderConfigsResponseFetcher
    implements AsyncPageFetcher<ListIdentityProviderConfigsResponse> {
        private ListIdentityProviderConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListIdentityProviderConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIdentityProviderConfigsResponse> nextPage(ListIdentityProviderConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListIdentityProviderConfigsPublisher.this.client.listIdentityProviderConfigs(ListIdentityProviderConfigsPublisher.this.firstRequest);
            }
            return ListIdentityProviderConfigsPublisher.this.client.listIdentityProviderConfigs((ListIdentityProviderConfigsRequest)((Object)ListIdentityProviderConfigsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

