/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eksauth;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.eksauth.DefaultEksAuthClientBuilder;
import software.amazon.awssdk.services.eksauth.EksAuthClientBuilder;
import software.amazon.awssdk.services.eksauth.EksAuthServiceClientConfiguration;
import software.amazon.awssdk.services.eksauth.model.AccessDeniedException;
import software.amazon.awssdk.services.eksauth.model.AssumeRoleForPodIdentityRequest;
import software.amazon.awssdk.services.eksauth.model.AssumeRoleForPodIdentityResponse;
import software.amazon.awssdk.services.eksauth.model.EksAuthException;
import software.amazon.awssdk.services.eksauth.model.ExpiredTokenException;
import software.amazon.awssdk.services.eksauth.model.InternalServerException;
import software.amazon.awssdk.services.eksauth.model.InvalidParameterException;
import software.amazon.awssdk.services.eksauth.model.InvalidRequestException;
import software.amazon.awssdk.services.eksauth.model.InvalidTokenException;
import software.amazon.awssdk.services.eksauth.model.ResourceNotFoundException;
import software.amazon.awssdk.services.eksauth.model.ServiceUnavailableException;
import software.amazon.awssdk.services.eksauth.model.ThrottlingException;

@SdkPublicApi
@ThreadSafe
public interface EksAuthClient
extends AwsClient {
    public static final String SERVICE_NAME = "eks-auth";
    public static final String SERVICE_METADATA_ID = "eks-auth";

    default public AssumeRoleForPodIdentityResponse assumeRoleForPodIdentity(AssumeRoleForPodIdentityRequest assumeRoleForPodIdentityRequest) throws ThrottlingException, InvalidRequestException, AccessDeniedException, InternalServerException, InvalidTokenException, InvalidParameterException, ExpiredTokenException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksAuthException {
        throw new UnsupportedOperationException();
    }

    default public AssumeRoleForPodIdentityResponse assumeRoleForPodIdentity(Consumer<AssumeRoleForPodIdentityRequest.Builder> assumeRoleForPodIdentityRequest) throws ThrottlingException, InvalidRequestException, AccessDeniedException, InternalServerException, InvalidTokenException, InvalidParameterException, ExpiredTokenException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksAuthException {
        return this.assumeRoleForPodIdentity((AssumeRoleForPodIdentityRequest)((Object)((AssumeRoleForPodIdentityRequest.Builder)AssumeRoleForPodIdentityRequest.builder().applyMutation(assumeRoleForPodIdentityRequest)).build()));
    }

    public static EksAuthClient create() {
        return (EksAuthClient)EksAuthClient.builder().build();
    }

    public static EksAuthClientBuilder builder() {
        return new DefaultEksAuthClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"eks-auth");
    }

    default public EksAuthServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

