/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eksauth.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eksauth.model.AssumedRoleUser;
import software.amazon.awssdk.services.eksauth.model.Credentials;
import software.amazon.awssdk.services.eksauth.model.EksAuthResponse;
import software.amazon.awssdk.services.eksauth.model.PodIdentityAssociation;
import software.amazon.awssdk.services.eksauth.model.Subject;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssumeRoleForPodIdentityResponse
extends EksAuthResponse
implements ToCopyableBuilder<Builder, AssumeRoleForPodIdentityResponse> {
    private static final SdkField<Subject> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("subject").getter(AssumeRoleForPodIdentityResponse.getter(AssumeRoleForPodIdentityResponse::subject)).setter(AssumeRoleForPodIdentityResponse.setter(Builder::subject)).constructor(Subject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subject").build()}).build();
    private static final SdkField<String> AUDIENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("audience").getter(AssumeRoleForPodIdentityResponse.getter(AssumeRoleForPodIdentityResponse::audience)).setter(AssumeRoleForPodIdentityResponse.setter(Builder::audience)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audience").build()}).build();
    private static final SdkField<PodIdentityAssociation> POD_IDENTITY_ASSOCIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("podIdentityAssociation").getter(AssumeRoleForPodIdentityResponse.getter(AssumeRoleForPodIdentityResponse::podIdentityAssociation)).setter(AssumeRoleForPodIdentityResponse.setter(Builder::podIdentityAssociation)).constructor(PodIdentityAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("podIdentityAssociation").build()}).build();
    private static final SdkField<AssumedRoleUser> ASSUMED_ROLE_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("assumedRoleUser").getter(AssumeRoleForPodIdentityResponse.getter(AssumeRoleForPodIdentityResponse::assumedRoleUser)).setter(AssumeRoleForPodIdentityResponse.setter(Builder::assumedRoleUser)).constructor(AssumedRoleUser::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assumedRoleUser").build()}).build();
    private static final SdkField<Credentials> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("credentials").getter(AssumeRoleForPodIdentityResponse.getter(AssumeRoleForPodIdentityResponse::credentials)).setter(AssumeRoleForPodIdentityResponse.setter(Builder::credentials)).constructor(Credentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentials").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBJECT_FIELD, AUDIENCE_FIELD, POD_IDENTITY_ASSOCIATION_FIELD, ASSUMED_ROLE_USER_FIELD, CREDENTIALS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssumeRoleForPodIdentityResponse.memberNameToFieldInitializer();
    private final Subject subject;
    private final String audience;
    private final PodIdentityAssociation podIdentityAssociation;
    private final AssumedRoleUser assumedRoleUser;
    private final Credentials credentials;

    private AssumeRoleForPodIdentityResponse(BuilderImpl builder) {
        super(builder);
        this.subject = builder.subject;
        this.audience = builder.audience;
        this.podIdentityAssociation = builder.podIdentityAssociation;
        this.assumedRoleUser = builder.assumedRoleUser;
        this.credentials = builder.credentials;
    }

    public final Subject subject() {
        return this.subject;
    }

    public final String audience() {
        return this.audience;
    }

    public final PodIdentityAssociation podIdentityAssociation() {
        return this.podIdentityAssociation;
    }

    public final AssumedRoleUser assumedRoleUser() {
        return this.assumedRoleUser;
    }

    public final Credentials credentials() {
        return this.credentials;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.audience());
        hashCode = 31 * hashCode + Objects.hashCode(this.podIdentityAssociation());
        hashCode = 31 * hashCode + Objects.hashCode(this.assumedRoleUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssumeRoleForPodIdentityResponse)) {
            return false;
        }
        AssumeRoleForPodIdentityResponse other = (AssumeRoleForPodIdentityResponse)((Object)obj);
        return Objects.equals(this.subject(), other.subject()) && Objects.equals(this.audience(), other.audience()) && Objects.equals(this.podIdentityAssociation(), other.podIdentityAssociation()) && Objects.equals(this.assumedRoleUser(), other.assumedRoleUser()) && Objects.equals(this.credentials(), other.credentials());
    }

    public final String toString() {
        return ToString.builder((String)"AssumeRoleForPodIdentityResponse").add("Subject", (Object)this.subject()).add("Audience", (Object)this.audience()).add("PodIdentityAssociation", (Object)this.podIdentityAssociation()).add("AssumedRoleUser", (Object)this.assumedRoleUser()).add("Credentials", (Object)(this.credentials() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
            case "audience": {
                return Optional.ofNullable(clazz.cast(this.audience()));
            }
            case "podIdentityAssociation": {
                return Optional.ofNullable(clazz.cast(this.podIdentityAssociation()));
            }
            case "assumedRoleUser": {
                return Optional.ofNullable(clazz.cast(this.assumedRoleUser()));
            }
            case "credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("subject", SUBJECT_FIELD);
        map.put("audience", AUDIENCE_FIELD);
        map.put("podIdentityAssociation", POD_IDENTITY_ASSOCIATION_FIELD);
        map.put("assumedRoleUser", ASSUMED_ROLE_USER_FIELD);
        map.put("credentials", CREDENTIALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssumeRoleForPodIdentityResponse, T> g) {
        return obj -> g.apply((AssumeRoleForPodIdentityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksAuthResponse.BuilderImpl
    implements Builder {
        private Subject subject;
        private String audience;
        private PodIdentityAssociation podIdentityAssociation;
        private AssumedRoleUser assumedRoleUser;
        private Credentials credentials;

        private BuilderImpl() {
        }

        private BuilderImpl(AssumeRoleForPodIdentityResponse model) {
            super(model);
            this.subject(model.subject);
            this.audience(model.audience);
            this.podIdentityAssociation(model.podIdentityAssociation);
            this.assumedRoleUser(model.assumedRoleUser);
            this.credentials(model.credentials);
        }

        public final Subject.Builder getSubject() {
            return this.subject != null ? this.subject.toBuilder() : null;
        }

        public final void setSubject(Subject.BuilderImpl subject) {
            this.subject = subject != null ? subject.build() : null;
        }

        @Override
        public final Builder subject(Subject subject) {
            this.subject = subject;
            return this;
        }

        public final String getAudience() {
            return this.audience;
        }

        public final void setAudience(String audience) {
            this.audience = audience;
        }

        @Override
        public final Builder audience(String audience) {
            this.audience = audience;
            return this;
        }

        public final PodIdentityAssociation.Builder getPodIdentityAssociation() {
            return this.podIdentityAssociation != null ? this.podIdentityAssociation.toBuilder() : null;
        }

        public final void setPodIdentityAssociation(PodIdentityAssociation.BuilderImpl podIdentityAssociation) {
            this.podIdentityAssociation = podIdentityAssociation != null ? podIdentityAssociation.build() : null;
        }

        @Override
        public final Builder podIdentityAssociation(PodIdentityAssociation podIdentityAssociation) {
            this.podIdentityAssociation = podIdentityAssociation;
            return this;
        }

        public final AssumedRoleUser.Builder getAssumedRoleUser() {
            return this.assumedRoleUser != null ? this.assumedRoleUser.toBuilder() : null;
        }

        public final void setAssumedRoleUser(AssumedRoleUser.BuilderImpl assumedRoleUser) {
            this.assumedRoleUser = assumedRoleUser != null ? assumedRoleUser.build() : null;
        }

        @Override
        public final Builder assumedRoleUser(AssumedRoleUser assumedRoleUser) {
            this.assumedRoleUser = assumedRoleUser;
            return this;
        }

        public final Credentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        @Override
        public AssumeRoleForPodIdentityResponse build() {
            return new AssumeRoleForPodIdentityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EksAuthResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssumeRoleForPodIdentityResponse> {
        public Builder subject(Subject var1);

        default public Builder subject(Consumer<Subject.Builder> subject) {
            return this.subject((Subject)((Subject.Builder)Subject.builder().applyMutation(subject)).build());
        }

        public Builder audience(String var1);

        public Builder podIdentityAssociation(PodIdentityAssociation var1);

        default public Builder podIdentityAssociation(Consumer<PodIdentityAssociation.Builder> podIdentityAssociation) {
            return this.podIdentityAssociation((PodIdentityAssociation)((PodIdentityAssociation.Builder)PodIdentityAssociation.builder().applyMutation(podIdentityAssociation)).build());
        }

        public Builder assumedRoleUser(AssumedRoleUser var1);

        default public Builder assumedRoleUser(Consumer<AssumedRoleUser.Builder> assumedRoleUser) {
            return this.assumedRoleUser((AssumedRoleUser)((AssumedRoleUser.Builder)AssumedRoleUser.builder().applyMutation(assumedRoleUser)).build());
        }

        public Builder credentials(Credentials var1);

        default public Builder credentials(Consumer<Credentials.Builder> credentials) {
            return this.credentials((Credentials)((Credentials.Builder)Credentials.builder().applyMutation(credentials)).build());
        }
    }
}

