/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticache.model.Endpoint;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CacheNode
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CacheNode> {
    private static final SdkField<String> CACHE_NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheNodeId").getter(CacheNode.getter(CacheNode::cacheNodeId)).setter(CacheNode.setter(Builder::cacheNodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeId").build()}).build();
    private static final SdkField<String> CACHE_NODE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheNodeStatus").getter(CacheNode.getter(CacheNode::cacheNodeStatus)).setter(CacheNode.setter(Builder::cacheNodeStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeStatus").build()}).build();
    private static final SdkField<Instant> CACHE_NODE_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CacheNodeCreateTime").getter(CacheNode.getter(CacheNode::cacheNodeCreateTime)).setter(CacheNode.setter(Builder::cacheNodeCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeCreateTime").build()}).build();
    private static final SdkField<Endpoint> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Endpoint").getter(CacheNode.getter(CacheNode::endpoint)).setter(CacheNode.setter(Builder::endpoint)).constructor(Endpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<String> PARAMETER_GROUP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterGroupStatus").getter(CacheNode.getter(CacheNode::parameterGroupStatus)).setter(CacheNode.setter(Builder::parameterGroupStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupStatus").build()}).build();
    private static final SdkField<String> SOURCE_CACHE_NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceCacheNodeId").getter(CacheNode.getter(CacheNode::sourceCacheNodeId)).setter(CacheNode.setter(Builder::sourceCacheNodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCacheNodeId").build()}).build();
    private static final SdkField<String> CUSTOMER_AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerAvailabilityZone").getter(CacheNode.getter(CacheNode::customerAvailabilityZone)).setter(CacheNode.setter(Builder::customerAvailabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerAvailabilityZone").build()}).build();
    private static final SdkField<String> CUSTOMER_OUTPOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerOutpostArn").getter(CacheNode.getter(CacheNode::customerOutpostArn)).setter(CacheNode.setter(Builder::customerOutpostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerOutpostArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_NODE_ID_FIELD, CACHE_NODE_STATUS_FIELD, CACHE_NODE_CREATE_TIME_FIELD, ENDPOINT_FIELD, PARAMETER_GROUP_STATUS_FIELD, SOURCE_CACHE_NODE_ID_FIELD, CUSTOMER_AVAILABILITY_ZONE_FIELD, CUSTOMER_OUTPOST_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CacheNode.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String cacheNodeId;
    private final String cacheNodeStatus;
    private final Instant cacheNodeCreateTime;
    private final Endpoint endpoint;
    private final String parameterGroupStatus;
    private final String sourceCacheNodeId;
    private final String customerAvailabilityZone;
    private final String customerOutpostArn;

    private CacheNode(BuilderImpl builder) {
        this.cacheNodeId = builder.cacheNodeId;
        this.cacheNodeStatus = builder.cacheNodeStatus;
        this.cacheNodeCreateTime = builder.cacheNodeCreateTime;
        this.endpoint = builder.endpoint;
        this.parameterGroupStatus = builder.parameterGroupStatus;
        this.sourceCacheNodeId = builder.sourceCacheNodeId;
        this.customerAvailabilityZone = builder.customerAvailabilityZone;
        this.customerOutpostArn = builder.customerOutpostArn;
    }

    public final String cacheNodeId() {
        return this.cacheNodeId;
    }

    public final String cacheNodeStatus() {
        return this.cacheNodeStatus;
    }

    public final Instant cacheNodeCreateTime() {
        return this.cacheNodeCreateTime;
    }

    public final Endpoint endpoint() {
        return this.endpoint;
    }

    public final String parameterGroupStatus() {
        return this.parameterGroupStatus;
    }

    public final String sourceCacheNodeId() {
        return this.sourceCacheNodeId;
    }

    public final String customerAvailabilityZone() {
        return this.customerAvailabilityZone;
    }

    public final String customerOutpostArn() {
        return this.customerOutpostArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterGroupStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCacheNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerOutpostArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheNode)) {
            return false;
        }
        CacheNode other = (CacheNode)obj;
        return Objects.equals(this.cacheNodeId(), other.cacheNodeId()) && Objects.equals(this.cacheNodeStatus(), other.cacheNodeStatus()) && Objects.equals(this.cacheNodeCreateTime(), other.cacheNodeCreateTime()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.parameterGroupStatus(), other.parameterGroupStatus()) && Objects.equals(this.sourceCacheNodeId(), other.sourceCacheNodeId()) && Objects.equals(this.customerAvailabilityZone(), other.customerAvailabilityZone()) && Objects.equals(this.customerOutpostArn(), other.customerOutpostArn());
    }

    public final String toString() {
        return ToString.builder((String)"CacheNode").add("CacheNodeId", (Object)this.cacheNodeId()).add("CacheNodeStatus", (Object)this.cacheNodeStatus()).add("CacheNodeCreateTime", (Object)this.cacheNodeCreateTime()).add("Endpoint", (Object)this.endpoint()).add("ParameterGroupStatus", (Object)this.parameterGroupStatus()).add("SourceCacheNodeId", (Object)this.sourceCacheNodeId()).add("CustomerAvailabilityZone", (Object)this.customerAvailabilityZone()).add("CustomerOutpostArn", (Object)this.customerOutpostArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheNodeId": {
                return Optional.ofNullable(clazz.cast(this.cacheNodeId()));
            }
            case "CacheNodeStatus": {
                return Optional.ofNullable(clazz.cast(this.cacheNodeStatus()));
            }
            case "CacheNodeCreateTime": {
                return Optional.ofNullable(clazz.cast(this.cacheNodeCreateTime()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "ParameterGroupStatus": {
                return Optional.ofNullable(clazz.cast(this.parameterGroupStatus()));
            }
            case "SourceCacheNodeId": {
                return Optional.ofNullable(clazz.cast(this.sourceCacheNodeId()));
            }
            case "CustomerAvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.customerAvailabilityZone()));
            }
            case "CustomerOutpostArn": {
                return Optional.ofNullable(clazz.cast(this.customerOutpostArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CacheNodeId", CACHE_NODE_ID_FIELD);
        map.put("CacheNodeStatus", CACHE_NODE_STATUS_FIELD);
        map.put("CacheNodeCreateTime", CACHE_NODE_CREATE_TIME_FIELD);
        map.put("Endpoint", ENDPOINT_FIELD);
        map.put("ParameterGroupStatus", PARAMETER_GROUP_STATUS_FIELD);
        map.put("SourceCacheNodeId", SOURCE_CACHE_NODE_ID_FIELD);
        map.put("CustomerAvailabilityZone", CUSTOMER_AVAILABILITY_ZONE_FIELD);
        map.put("CustomerOutpostArn", CUSTOMER_OUTPOST_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CacheNode, T> g) {
        return obj -> g.apply((CacheNode)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cacheNodeId;
        private String cacheNodeStatus;
        private Instant cacheNodeCreateTime;
        private Endpoint endpoint;
        private String parameterGroupStatus;
        private String sourceCacheNodeId;
        private String customerAvailabilityZone;
        private String customerOutpostArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CacheNode model) {
            this.cacheNodeId(model.cacheNodeId);
            this.cacheNodeStatus(model.cacheNodeStatus);
            this.cacheNodeCreateTime(model.cacheNodeCreateTime);
            this.endpoint(model.endpoint);
            this.parameterGroupStatus(model.parameterGroupStatus);
            this.sourceCacheNodeId(model.sourceCacheNodeId);
            this.customerAvailabilityZone(model.customerAvailabilityZone);
            this.customerOutpostArn(model.customerOutpostArn);
        }

        public final String getCacheNodeId() {
            return this.cacheNodeId;
        }

        public final void setCacheNodeId(String cacheNodeId) {
            this.cacheNodeId = cacheNodeId;
        }

        @Override
        public final Builder cacheNodeId(String cacheNodeId) {
            this.cacheNodeId = cacheNodeId;
            return this;
        }

        public final String getCacheNodeStatus() {
            return this.cacheNodeStatus;
        }

        public final void setCacheNodeStatus(String cacheNodeStatus) {
            this.cacheNodeStatus = cacheNodeStatus;
        }

        @Override
        public final Builder cacheNodeStatus(String cacheNodeStatus) {
            this.cacheNodeStatus = cacheNodeStatus;
            return this;
        }

        public final Instant getCacheNodeCreateTime() {
            return this.cacheNodeCreateTime;
        }

        public final void setCacheNodeCreateTime(Instant cacheNodeCreateTime) {
            this.cacheNodeCreateTime = cacheNodeCreateTime;
        }

        @Override
        public final Builder cacheNodeCreateTime(Instant cacheNodeCreateTime) {
            this.cacheNodeCreateTime = cacheNodeCreateTime;
            return this;
        }

        public final Endpoint.Builder getEndpoint() {
            return this.endpoint != null ? this.endpoint.toBuilder() : null;
        }

        public final void setEndpoint(Endpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        @Override
        public final Builder endpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getParameterGroupStatus() {
            return this.parameterGroupStatus;
        }

        public final void setParameterGroupStatus(String parameterGroupStatus) {
            this.parameterGroupStatus = parameterGroupStatus;
        }

        @Override
        public final Builder parameterGroupStatus(String parameterGroupStatus) {
            this.parameterGroupStatus = parameterGroupStatus;
            return this;
        }

        public final String getSourceCacheNodeId() {
            return this.sourceCacheNodeId;
        }

        public final void setSourceCacheNodeId(String sourceCacheNodeId) {
            this.sourceCacheNodeId = sourceCacheNodeId;
        }

        @Override
        public final Builder sourceCacheNodeId(String sourceCacheNodeId) {
            this.sourceCacheNodeId = sourceCacheNodeId;
            return this;
        }

        public final String getCustomerAvailabilityZone() {
            return this.customerAvailabilityZone;
        }

        public final void setCustomerAvailabilityZone(String customerAvailabilityZone) {
            this.customerAvailabilityZone = customerAvailabilityZone;
        }

        @Override
        public final Builder customerAvailabilityZone(String customerAvailabilityZone) {
            this.customerAvailabilityZone = customerAvailabilityZone;
            return this;
        }

        public final String getCustomerOutpostArn() {
            return this.customerOutpostArn;
        }

        public final void setCustomerOutpostArn(String customerOutpostArn) {
            this.customerOutpostArn = customerOutpostArn;
        }

        @Override
        public final Builder customerOutpostArn(String customerOutpostArn) {
            this.customerOutpostArn = customerOutpostArn;
            return this;
        }

        public CacheNode build() {
            return new CacheNode(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CacheNode> {
        public Builder cacheNodeId(String var1);

        public Builder cacheNodeStatus(String var1);

        public Builder cacheNodeCreateTime(Instant var1);

        public Builder endpoint(Endpoint var1);

        default public Builder endpoint(Consumer<Endpoint.Builder> endpoint) {
            return this.endpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().applyMutation(endpoint)).build());
        }

        public Builder parameterGroupStatus(String var1);

        public Builder sourceCacheNodeId(String var1);

        public Builder customerAvailabilityZone(String var1);

        public Builder customerOutpostArn(String var1);
    }
}

