/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetGroup;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetGroupsCopier;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCacheSubnetGroupsResponse
extends ElastiCacheResponse
implements ToCopyableBuilder<Builder, DescribeCacheSubnetGroupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeCacheSubnetGroupsResponse.getter(DescribeCacheSubnetGroupsResponse::marker)).setter(DescribeCacheSubnetGroupsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<CacheSubnetGroup>> CACHE_SUBNET_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CacheSubnetGroups").getter(DescribeCacheSubnetGroupsResponse.getter(DescribeCacheSubnetGroupsResponse::cacheSubnetGroups)).setter(DescribeCacheSubnetGroupsResponse.setter(Builder::cacheSubnetGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSubnetGroups").build(), ListTrait.builder().memberLocationName("CacheSubnetGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CacheSubnetGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSubnetGroup").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, CACHE_SUBNET_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeCacheSubnetGroupsResponse.memberNameToFieldInitializer();
    private final String marker;
    private final List<CacheSubnetGroup> cacheSubnetGroups;

    private DescribeCacheSubnetGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.cacheSubnetGroups = builder.cacheSubnetGroups;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasCacheSubnetGroups() {
        return this.cacheSubnetGroups != null && !(this.cacheSubnetGroups instanceof SdkAutoConstructList);
    }

    public final List<CacheSubnetGroup> cacheSubnetGroups() {
        return this.cacheSubnetGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCacheSubnetGroups() ? this.cacheSubnetGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheSubnetGroupsResponse)) {
            return false;
        }
        DescribeCacheSubnetGroupsResponse other = (DescribeCacheSubnetGroupsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasCacheSubnetGroups() == other.hasCacheSubnetGroups() && Objects.equals(this.cacheSubnetGroups(), other.cacheSubnetGroups());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCacheSubnetGroupsResponse").add("Marker", (Object)this.marker()).add("CacheSubnetGroups", this.hasCacheSubnetGroups() ? this.cacheSubnetGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "CacheSubnetGroups": {
                return Optional.ofNullable(clazz.cast(this.cacheSubnetGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Marker", MARKER_FIELD);
        map.put("CacheSubnetGroups", CACHE_SUBNET_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCacheSubnetGroupsResponse, T> g) {
        return obj -> g.apply((DescribeCacheSubnetGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<CacheSubnetGroup> cacheSubnetGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCacheSubnetGroupsResponse model) {
            super(model);
            this.marker(model.marker);
            this.cacheSubnetGroups(model.cacheSubnetGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<CacheSubnetGroup.Builder> getCacheSubnetGroups() {
            List<CacheSubnetGroup.Builder> result = CacheSubnetGroupsCopier.copyToBuilder(this.cacheSubnetGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCacheSubnetGroups(Collection<CacheSubnetGroup.BuilderImpl> cacheSubnetGroups) {
            this.cacheSubnetGroups = CacheSubnetGroupsCopier.copyFromBuilder(cacheSubnetGroups);
        }

        @Override
        public final Builder cacheSubnetGroups(Collection<CacheSubnetGroup> cacheSubnetGroups) {
            this.cacheSubnetGroups = CacheSubnetGroupsCopier.copy(cacheSubnetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSubnetGroups(CacheSubnetGroup ... cacheSubnetGroups) {
            this.cacheSubnetGroups(Arrays.asList(cacheSubnetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSubnetGroups(Consumer<CacheSubnetGroup.Builder> ... cacheSubnetGroups) {
            this.cacheSubnetGroups(Stream.of(cacheSubnetGroups).map(c -> (CacheSubnetGroup)((CacheSubnetGroup.Builder)CacheSubnetGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeCacheSubnetGroupsResponse build() {
            return new DescribeCacheSubnetGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElastiCacheResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCacheSubnetGroupsResponse> {
        public Builder marker(String var1);

        public Builder cacheSubnetGroups(Collection<CacheSubnetGroup> var1);

        public Builder cacheSubnetGroups(CacheSubnetGroup ... var1);

        public Builder cacheSubnetGroups(Consumer<CacheSubnetGroup.Builder> ... var1);
    }
}

