/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeServerlessCacheSnapshotsRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, DescribeServerlessCacheSnapshotsRequest> {
    private static final SdkField<String> SERVERLESS_CACHE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerlessCacheName").getter(DescribeServerlessCacheSnapshotsRequest.getter(DescribeServerlessCacheSnapshotsRequest::serverlessCacheName)).setter(DescribeServerlessCacheSnapshotsRequest.setter(Builder::serverlessCacheName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessCacheName").build()}).build();
    private static final SdkField<String> SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerlessCacheSnapshotName").getter(DescribeServerlessCacheSnapshotsRequest.getter(DescribeServerlessCacheSnapshotsRequest::serverlessCacheSnapshotName)).setter(DescribeServerlessCacheSnapshotsRequest.setter(Builder::serverlessCacheSnapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessCacheSnapshotName").build()}).build();
    private static final SdkField<String> SNAPSHOT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotType").getter(DescribeServerlessCacheSnapshotsRequest.getter(DescribeServerlessCacheSnapshotsRequest::snapshotType)).setter(DescribeServerlessCacheSnapshotsRequest.setter(Builder::snapshotType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotType").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeServerlessCacheSnapshotsRequest.getter(DescribeServerlessCacheSnapshotsRequest::nextToken)).setter(DescribeServerlessCacheSnapshotsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeServerlessCacheSnapshotsRequest.getter(DescribeServerlessCacheSnapshotsRequest::maxResults)).setter(DescribeServerlessCacheSnapshotsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVERLESS_CACHE_NAME_FIELD, SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD, SNAPSHOT_TYPE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeServerlessCacheSnapshotsRequest.memberNameToFieldInitializer();
    private final String serverlessCacheName;
    private final String serverlessCacheSnapshotName;
    private final String snapshotType;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeServerlessCacheSnapshotsRequest(BuilderImpl builder) {
        super(builder);
        this.serverlessCacheName = builder.serverlessCacheName;
        this.serverlessCacheSnapshotName = builder.serverlessCacheSnapshotName;
        this.snapshotType = builder.snapshotType;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String serverlessCacheName() {
        return this.serverlessCacheName;
    }

    public final String serverlessCacheSnapshotName() {
        return this.serverlessCacheSnapshotName;
    }

    public final String snapshotType() {
        return this.snapshotType;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serverlessCacheName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverlessCacheSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotType());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServerlessCacheSnapshotsRequest)) {
            return false;
        }
        DescribeServerlessCacheSnapshotsRequest other = (DescribeServerlessCacheSnapshotsRequest)((Object)obj);
        return Objects.equals(this.serverlessCacheName(), other.serverlessCacheName()) && Objects.equals(this.serverlessCacheSnapshotName(), other.serverlessCacheSnapshotName()) && Objects.equals(this.snapshotType(), other.snapshotType()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeServerlessCacheSnapshotsRequest").add("ServerlessCacheName", (Object)this.serverlessCacheName()).add("ServerlessCacheSnapshotName", (Object)this.serverlessCacheSnapshotName()).add("SnapshotType", (Object)this.snapshotType()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerlessCacheName": {
                return Optional.ofNullable(clazz.cast(this.serverlessCacheName()));
            }
            case "ServerlessCacheSnapshotName": {
                return Optional.ofNullable(clazz.cast(this.serverlessCacheSnapshotName()));
            }
            case "SnapshotType": {
                return Optional.ofNullable(clazz.cast(this.snapshotType()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ServerlessCacheName", SERVERLESS_CACHE_NAME_FIELD);
        map.put("ServerlessCacheSnapshotName", SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD);
        map.put("SnapshotType", SNAPSHOT_TYPE_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeServerlessCacheSnapshotsRequest, T> g) {
        return obj -> g.apply((DescribeServerlessCacheSnapshotsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String serverlessCacheName;
        private String serverlessCacheSnapshotName;
        private String snapshotType;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServerlessCacheSnapshotsRequest model) {
            super(model);
            this.serverlessCacheName(model.serverlessCacheName);
            this.serverlessCacheSnapshotName(model.serverlessCacheSnapshotName);
            this.snapshotType(model.snapshotType);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getServerlessCacheName() {
            return this.serverlessCacheName;
        }

        public final void setServerlessCacheName(String serverlessCacheName) {
            this.serverlessCacheName = serverlessCacheName;
        }

        @Override
        public final Builder serverlessCacheName(String serverlessCacheName) {
            this.serverlessCacheName = serverlessCacheName;
            return this;
        }

        public final String getServerlessCacheSnapshotName() {
            return this.serverlessCacheSnapshotName;
        }

        public final void setServerlessCacheSnapshotName(String serverlessCacheSnapshotName) {
            this.serverlessCacheSnapshotName = serverlessCacheSnapshotName;
        }

        @Override
        public final Builder serverlessCacheSnapshotName(String serverlessCacheSnapshotName) {
            this.serverlessCacheSnapshotName = serverlessCacheSnapshotName;
            return this;
        }

        public final String getSnapshotType() {
            return this.snapshotType;
        }

        public final void setSnapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
        }

        @Override
        public final Builder snapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeServerlessCacheSnapshotsRequest build() {
            return new DescribeServerlessCacheSnapshotsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ElastiCacheRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeServerlessCacheSnapshotsRequest> {
        public Builder serverlessCacheName(String var1);

        public Builder serverlessCacheSnapshotName(String var1);

        public Builder snapshotType(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

