/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheResponse;
import software.amazon.awssdk.services.elasticache.model.ProcessedUpdateAction;
import software.amazon.awssdk.services.elasticache.model.ProcessedUpdateActionListCopier;
import software.amazon.awssdk.services.elasticache.model.UnprocessedUpdateAction;
import software.amazon.awssdk.services.elasticache.model.UnprocessedUpdateActionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchStopUpdateActionResponse
extends ElastiCacheResponse
implements ToCopyableBuilder<Builder, BatchStopUpdateActionResponse> {
    private static final SdkField<List<ProcessedUpdateAction>> PROCESSED_UPDATE_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProcessedUpdateActions").getter(BatchStopUpdateActionResponse.getter(BatchStopUpdateActionResponse::processedUpdateActions)).setter(BatchStopUpdateActionResponse.setter(Builder::processedUpdateActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessedUpdateActions").build(), ListTrait.builder().memberLocationName("ProcessedUpdateAction").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProcessedUpdateAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessedUpdateAction").build()}).build()).build()}).build();
    private static final SdkField<List<UnprocessedUpdateAction>> UNPROCESSED_UPDATE_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnprocessedUpdateActions").getter(BatchStopUpdateActionResponse.getter(BatchStopUpdateActionResponse::unprocessedUpdateActions)).setter(BatchStopUpdateActionResponse.setter(Builder::unprocessedUpdateActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedUpdateActions").build(), ListTrait.builder().memberLocationName("UnprocessedUpdateAction").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnprocessedUpdateAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedUpdateAction").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROCESSED_UPDATE_ACTIONS_FIELD, UNPROCESSED_UPDATE_ACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchStopUpdateActionResponse.memberNameToFieldInitializer();
    private final List<ProcessedUpdateAction> processedUpdateActions;
    private final List<UnprocessedUpdateAction> unprocessedUpdateActions;

    private BatchStopUpdateActionResponse(BuilderImpl builder) {
        super(builder);
        this.processedUpdateActions = builder.processedUpdateActions;
        this.unprocessedUpdateActions = builder.unprocessedUpdateActions;
    }

    public final boolean hasProcessedUpdateActions() {
        return this.processedUpdateActions != null && !(this.processedUpdateActions instanceof SdkAutoConstructList);
    }

    public final List<ProcessedUpdateAction> processedUpdateActions() {
        return this.processedUpdateActions;
    }

    public final boolean hasUnprocessedUpdateActions() {
        return this.unprocessedUpdateActions != null && !(this.unprocessedUpdateActions instanceof SdkAutoConstructList);
    }

    public final List<UnprocessedUpdateAction> unprocessedUpdateActions() {
        return this.unprocessedUpdateActions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProcessedUpdateActions() ? this.processedUpdateActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedUpdateActions() ? this.unprocessedUpdateActions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchStopUpdateActionResponse)) {
            return false;
        }
        BatchStopUpdateActionResponse other = (BatchStopUpdateActionResponse)((Object)obj);
        return this.hasProcessedUpdateActions() == other.hasProcessedUpdateActions() && Objects.equals(this.processedUpdateActions(), other.processedUpdateActions()) && this.hasUnprocessedUpdateActions() == other.hasUnprocessedUpdateActions() && Objects.equals(this.unprocessedUpdateActions(), other.unprocessedUpdateActions());
    }

    public final String toString() {
        return ToString.builder((String)"BatchStopUpdateActionResponse").add("ProcessedUpdateActions", this.hasProcessedUpdateActions() ? this.processedUpdateActions() : null).add("UnprocessedUpdateActions", this.hasUnprocessedUpdateActions() ? this.unprocessedUpdateActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProcessedUpdateActions": {
                return Optional.ofNullable(clazz.cast(this.processedUpdateActions()));
            }
            case "UnprocessedUpdateActions": {
                return Optional.ofNullable(clazz.cast(this.unprocessedUpdateActions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProcessedUpdateActions", PROCESSED_UPDATE_ACTIONS_FIELD);
        map.put("UnprocessedUpdateActions", UNPROCESSED_UPDATE_ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchStopUpdateActionResponse, T> g) {
        return obj -> g.apply((BatchStopUpdateActionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheResponse.BuilderImpl
    implements Builder {
        private List<ProcessedUpdateAction> processedUpdateActions = DefaultSdkAutoConstructList.getInstance();
        private List<UnprocessedUpdateAction> unprocessedUpdateActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchStopUpdateActionResponse model) {
            super(model);
            this.processedUpdateActions(model.processedUpdateActions);
            this.unprocessedUpdateActions(model.unprocessedUpdateActions);
        }

        public final List<ProcessedUpdateAction.Builder> getProcessedUpdateActions() {
            List<ProcessedUpdateAction.Builder> result = ProcessedUpdateActionListCopier.copyToBuilder(this.processedUpdateActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProcessedUpdateActions(Collection<ProcessedUpdateAction.BuilderImpl> processedUpdateActions) {
            this.processedUpdateActions = ProcessedUpdateActionListCopier.copyFromBuilder(processedUpdateActions);
        }

        @Override
        public final Builder processedUpdateActions(Collection<ProcessedUpdateAction> processedUpdateActions) {
            this.processedUpdateActions = ProcessedUpdateActionListCopier.copy(processedUpdateActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processedUpdateActions(ProcessedUpdateAction ... processedUpdateActions) {
            this.processedUpdateActions(Arrays.asList(processedUpdateActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processedUpdateActions(Consumer<ProcessedUpdateAction.Builder> ... processedUpdateActions) {
            this.processedUpdateActions(Stream.of(processedUpdateActions).map(c -> (ProcessedUpdateAction)((ProcessedUpdateAction.Builder)ProcessedUpdateAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UnprocessedUpdateAction.Builder> getUnprocessedUpdateActions() {
            List<UnprocessedUpdateAction.Builder> result = UnprocessedUpdateActionListCopier.copyToBuilder(this.unprocessedUpdateActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedUpdateActions(Collection<UnprocessedUpdateAction.BuilderImpl> unprocessedUpdateActions) {
            this.unprocessedUpdateActions = UnprocessedUpdateActionListCopier.copyFromBuilder(unprocessedUpdateActions);
        }

        @Override
        public final Builder unprocessedUpdateActions(Collection<UnprocessedUpdateAction> unprocessedUpdateActions) {
            this.unprocessedUpdateActions = UnprocessedUpdateActionListCopier.copy(unprocessedUpdateActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedUpdateActions(UnprocessedUpdateAction ... unprocessedUpdateActions) {
            this.unprocessedUpdateActions(Arrays.asList(unprocessedUpdateActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedUpdateActions(Consumer<UnprocessedUpdateAction.Builder> ... unprocessedUpdateActions) {
            this.unprocessedUpdateActions(Stream.of(unprocessedUpdateActions).map(c -> (UnprocessedUpdateAction)((UnprocessedUpdateAction.Builder)UnprocessedUpdateAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchStopUpdateActionResponse build() {
            return new BatchStopUpdateActionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ElastiCacheResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchStopUpdateActionResponse> {
        public Builder processedUpdateActions(Collection<ProcessedUpdateAction> var1);

        public Builder processedUpdateActions(ProcessedUpdateAction ... var1);

        public Builder processedUpdateActions(Consumer<ProcessedUpdateAction.Builder> ... var1);

        public Builder unprocessedUpdateActions(Collection<UnprocessedUpdateAction> var1);

        public Builder unprocessedUpdateActions(UnprocessedUpdateAction ... var1);

        public Builder unprocessedUpdateActions(Consumer<UnprocessedUpdateAction.Builder> ... var1);
    }
}

