/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TerminateEnvironmentRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, TerminateEnvironmentRequest> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentId").getter(TerminateEnvironmentRequest.getter(TerminateEnvironmentRequest::environmentId)).setter(TerminateEnvironmentRequest.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentId").build()}).build();
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentName").getter(TerminateEnvironmentRequest.getter(TerminateEnvironmentRequest::environmentName)).setter(TerminateEnvironmentRequest.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()}).build();
    private static final SdkField<Boolean> TERMINATE_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TerminateResources").getter(TerminateEnvironmentRequest.getter(TerminateEnvironmentRequest::terminateResources)).setter(TerminateEnvironmentRequest.setter(Builder::terminateResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminateResources").build()}).build();
    private static final SdkField<Boolean> FORCE_TERMINATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ForceTerminate").getter(TerminateEnvironmentRequest.getter(TerminateEnvironmentRequest::forceTerminate)).setter(TerminateEnvironmentRequest.setter(Builder::forceTerminate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceTerminate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD, ENVIRONMENT_NAME_FIELD, TERMINATE_RESOURCES_FIELD, FORCE_TERMINATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TerminateEnvironmentRequest.memberNameToFieldInitializer();
    private final String environmentId;
    private final String environmentName;
    private final Boolean terminateResources;
    private final Boolean forceTerminate;

    private TerminateEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.environmentName = builder.environmentName;
        this.terminateResources = builder.terminateResources;
        this.forceTerminate = builder.forceTerminate;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    public final Boolean terminateResources() {
        return this.terminateResources;
    }

    public final Boolean forceTerminate() {
        return this.forceTerminate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminateResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceTerminate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateEnvironmentRequest)) {
            return false;
        }
        TerminateEnvironmentRequest other = (TerminateEnvironmentRequest)((Object)obj);
        return Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.terminateResources(), other.terminateResources()) && Objects.equals(this.forceTerminate(), other.forceTerminate());
    }

    public final String toString() {
        return ToString.builder((String)"TerminateEnvironmentRequest").add("EnvironmentId", (Object)this.environmentId()).add("EnvironmentName", (Object)this.environmentName()).add("TerminateResources", (Object)this.terminateResources()).add("ForceTerminate", (Object)this.forceTerminate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnvironmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "EnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "TerminateResources": {
                return Optional.ofNullable(clazz.cast(this.terminateResources()));
            }
            case "ForceTerminate": {
                return Optional.ofNullable(clazz.cast(this.forceTerminate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EnvironmentId", ENVIRONMENT_ID_FIELD);
        map.put("EnvironmentName", ENVIRONMENT_NAME_FIELD);
        map.put("TerminateResources", TERMINATE_RESOURCES_FIELD);
        map.put("ForceTerminate", FORCE_TERMINATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TerminateEnvironmentRequest, T> g) {
        return obj -> g.apply((TerminateEnvironmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String environmentId;
        private String environmentName;
        private Boolean terminateResources;
        private Boolean forceTerminate;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateEnvironmentRequest model) {
            super(model);
            this.environmentId(model.environmentId);
            this.environmentName(model.environmentName);
            this.terminateResources(model.terminateResources);
            this.forceTerminate(model.forceTerminate);
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final Boolean getTerminateResources() {
            return this.terminateResources;
        }

        public final void setTerminateResources(Boolean terminateResources) {
            this.terminateResources = terminateResources;
        }

        @Override
        public final Builder terminateResources(Boolean terminateResources) {
            this.terminateResources = terminateResources;
            return this;
        }

        public final Boolean getForceTerminate() {
            return this.forceTerminate;
        }

        public final void setForceTerminate(Boolean forceTerminate) {
            this.forceTerminate = forceTerminate;
        }

        @Override
        public final Builder forceTerminate(Boolean forceTerminate) {
            this.forceTerminate = forceTerminate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TerminateEnvironmentRequest build() {
            return new TerminateEnvironmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TerminateEnvironmentRequest> {
        public Builder environmentId(String var1);

        public Builder environmentName(String var1);

        public Builder terminateResources(Boolean var1);

        public Builder forceTerminate(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

