/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticbeanstalk.model.ValidationSeverity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidationMessage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ValidationMessage> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(ValidationMessage.getter(ValidationMessage::message)).setter(ValidationMessage.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Severity").getter(ValidationMessage.getter(ValidationMessage::severityAsString)).setter(ValidationMessage.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(ValidationMessage.getter(ValidationMessage::namespace)).setter(ValidationMessage.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()}).build();
    private static final SdkField<String> OPTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptionName").getter(ValidationMessage.getter(ValidationMessage::optionName)).setter(ValidationMessage.setter(Builder::optionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD, SEVERITY_FIELD, NAMESPACE_FIELD, OPTION_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ValidationMessage.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String message;
    private final String severity;
    private final String namespace;
    private final String optionName;

    private ValidationMessage(BuilderImpl builder) {
        this.message = builder.message;
        this.severity = builder.severity;
        this.namespace = builder.namespace;
        this.optionName = builder.optionName;
    }

    public final String message() {
        return this.message;
    }

    public final ValidationSeverity severity() {
        return ValidationSeverity.fromValue(this.severity);
    }

    public final String severityAsString() {
        return this.severity;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String optionName() {
        return this.optionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationMessage)) {
            return false;
        }
        ValidationMessage other = (ValidationMessage)obj;
        return Objects.equals(this.message(), other.message()) && Objects.equals(this.severityAsString(), other.severityAsString()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.optionName(), other.optionName());
    }

    public final String toString() {
        return ToString.builder((String)"ValidationMessage").add("Message", (Object)this.message()).add("Severity", (Object)this.severityAsString()).add("Namespace", (Object)this.namespace()).add("OptionName", (Object)this.optionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severityAsString()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "OptionName": {
                return Optional.ofNullable(clazz.cast(this.optionName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Message", MESSAGE_FIELD);
        map.put("Severity", SEVERITY_FIELD);
        map.put("Namespace", NAMESPACE_FIELD);
        map.put("OptionName", OPTION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidationMessage, T> g) {
        return obj -> g.apply((ValidationMessage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String message;
        private String severity;
        private String namespace;
        private String optionName;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationMessage model) {
            this.message(model.message);
            this.severity(model.severity);
            this.namespace(model.namespace);
            this.optionName(model.optionName);
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(ValidationSeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getOptionName() {
            return this.optionName;
        }

        public final void setOptionName(String optionName) {
            this.optionName = optionName;
        }

        @Override
        public final Builder optionName(String optionName) {
            this.optionName = optionName;
            return this;
        }

        public ValidationMessage build() {
            return new ValidationMessage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ValidationMessage> {
        public Builder message(String var1);

        public Builder severity(String var1);

        public Builder severity(ValidationSeverity var1);

        public Builder namespace(String var1);

        public Builder optionName(String var1);
    }
}

